/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.transport.TransportService;

public class TaskAssertions {
    private static final Logger logger = LogManager.getLogger(TaskAssertions.class);

    private TaskAssertions() {
    }

    public static void awaitTaskWithPrefix(String actionPrefix) throws Exception {
        TaskAssertions.awaitTaskWithPrefix(actionPrefix, ESIntegTestCase.internalCluster().getInstances(TransportService.class));
    }

    public static void awaitTaskWithPrefixOnMaster(String actionPrefix) throws Exception {
        TaskAssertions.awaitTaskWithPrefix(actionPrefix, Collections.singletonList(ESIntegTestCase.internalCluster().getCurrentMasterNodeInstance(TransportService.class)));
    }

    private static void awaitTaskWithPrefix(String actionPrefix, Iterable<TransportService> transportServiceInstances) throws Exception {
        logger.info("--> waiting for task with prefix [{}] to start", (Object)actionPrefix);
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (TransportService transportService : transportServiceInstances) {
                List matchingTasks = transportService.getTaskManager().getTasks().values().stream().filter(t -> t.getAction().startsWith(actionPrefix)).collect(Collectors.toList());
                if (matchingTasks.isEmpty()) continue;
                logger.trace("--> found {} tasks with prefix [{}]: {}", (Object)matchingTasks.size(), (Object)actionPrefix, matchingTasks);
                return;
            }
            TestCase.fail((String)("no task with prefix [" + actionPrefix + "] found"));
        }));
    }

    public static void assertAllCancellableTasksAreCancelled(String actionPrefix) throws Exception {
        logger.info("--> checking that all tasks with prefix {} are marked as cancelled", (Object)actionPrefix);
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            boolean foundTask = false;
            for (TransportService transportService : ESIntegTestCase.internalCluster().getInstances(TransportService.class)) {
                TaskManager taskManager = transportService.getTaskManager();
                TestCase.assertTrue((boolean)taskManager.assertCancellableTaskConsistency());
                for (CancellableTask cancellableTask : taskManager.getCancellableTasks().values()) {
                    if (!cancellableTask.getAction().startsWith(actionPrefix)) continue;
                    logger.trace("--> found task with prefix [{}]: [{}]", (Object)actionPrefix, (Object)cancellableTask);
                    foundTask = true;
                    TestCase.assertTrue((String)("task " + cancellableTask.getId() + "/" + cancellableTask.getAction() + " not cancelled"), (boolean)cancellableTask.isCancelled());
                    logger.trace("--> Task with prefix [{}] is marked as cancelled: [{}]", (Object)actionPrefix, (Object)cancellableTask);
                }
            }
            TestCase.assertTrue((String)"found no cancellable tasks", (boolean)foundTask);
        }), 30L, TimeUnit.SECONDS);
    }

    public static void assertAllTasksHaveFinished(String actionPrefix) throws Exception {
        logger.info("--> checking that all tasks with prefix {} have finished", (Object)actionPrefix);
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            List tasks = ((ListTasksResponse)ESIntegTestCase.client().admin().cluster().prepareListTasks(new String[0]).get()).getTasks();
            TestCase.assertTrue((String)tasks.toString(), (boolean)tasks.stream().noneMatch(t -> t.getAction().startsWith(actionPrefix)));
        }));
    }
}

