/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.SysGlobals;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.test.ESTestCase;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReproduceInfoPrinter
extends RunListener {
    protected final Logger logger = LogManager.getLogger(ESTestCase.class);

    public void testStarted(Description description) throws Exception {
        this.logger.trace("Test {} started", (Object)description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        this.logger.trace("Test {} finished", (Object)description.getDisplayName());
    }

    static boolean inVerifyPhase() {
        return Boolean.parseBoolean(System.getProperty("tests.verify.phase"));
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssumptionViolatedException) {
            return;
        }
        String gradlew = Constants.WINDOWS ? "gradlew" : "./gradlew";
        StringBuilder b = new StringBuilder("REPRODUCE WITH: " + gradlew + " ");
        String task = System.getProperty("tests.task");
        boolean isBwcTest = Boolean.parseBoolean(System.getProperty("tests.bwc", "false"));
        b.append("'" + task + "'");
        if (isBwcTest) {
            b.append(" -Dtests.class=\"");
        } else {
            b.append(" --tests \"");
        }
        b.append(failure.getDescription().getClassName());
        String methodName = failure.getDescription().getMethodName();
        if (methodName != null) {
            if (methodName.contains(".") || isBwcTest) {
                b.append("\" -Dtests.method=\"");
                b.append(methodName);
            } else {
                b.append(".");
                b.append(methodName);
            }
        }
        b.append("\"");
        GradleMessageBuilder gradleMessageBuilder = new GradleMessageBuilder(b);
        gradleMessageBuilder.appendAllOpts(failure.getDescription());
        ReproduceInfoPrinter.printToErr(b.toString());
    }

    @SuppressForbidden(reason="printing repro info")
    private static void printToErr(String s) {
        System.err.println(s);
    }

    protected static class GradleMessageBuilder
    extends ReproduceErrorMessageBuilder {
        public GradleMessageBuilder(StringBuilder b) {
            super(b);
        }

        public ReproduceErrorMessageBuilder appendAllOpts(Description description) {
            super.appendAllOpts(description);
            return this.appendESProperties();
        }

        public ReproduceErrorMessageBuilder appendEnvironmentSettings() {
            return this;
        }

        public ReproduceErrorMessageBuilder appendOpt(String sysPropName, String value) {
            if (sysPropName.equals(SysGlobals.SYSPROP_ITERATIONS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTCLASS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTMETHOD())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_PREFIX())) {
                return this;
            }
            if (Strings.hasLength((String)value)) {
                return super.appendOpt(sysPropName, value);
            }
            return this;
        }

        private ReproduceErrorMessageBuilder appendESProperties() {
            this.appendProperties("tests.es.logger.level");
            if (ReproduceInfoPrinter.inVerifyPhase()) {
                this.appendProperties("tests.enable_mock_modules");
            }
            this.appendProperties("tests.assertion.disabled", "tests.nightly", "tests.jvms", "tests.client.ratio", "tests.heap.size", "tests.bwc", "tests.bwc.version", "build.snapshot");
            if (System.getProperty("tests.jvm.argline") != null && !System.getProperty("tests.jvm.argline").isEmpty()) {
                this.appendOpt("tests.jvm.argline", "\"" + System.getProperty("tests.jvm.argline") + "\"");
            }
            this.appendOpt("tests.locale", Locale.getDefault().toLanguageTag());
            this.appendOpt("tests.timezone", TimeZone.getDefault().getID());
            this.appendOpt("tests.distribution", System.getProperty("tests.distribution"));
            this.appendOpt("runtime.java", System.getProperty("tests.runtime.java.version", Integer.toString((Integer)JavaVersion.current().getVersion().get(0))));
            this.appendOpt("license.key", System.getProperty("licence.key"));
            this.appendOpt("tests.fips.enabled", System.getProperty("tests.fips.enabled"));
            return this;
        }

        protected ReproduceErrorMessageBuilder appendProperties(String ... properties) {
            for (String sysPropName : properties) {
                if (!Strings.hasLength((String)System.getProperty(sysPropName))) continue;
                this.appendOpt(sysPropName, System.getProperty(sysPropName));
            }
            return this;
        }
    }
}

