/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CompletableContext;
import org.elasticsearch.transport.TcpChannel;

public class FakeTcpChannel
implements TcpChannel {
    private final boolean isServer;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final String profile;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final AtomicReference<BytesReference> messageCaptor;
    private final AtomicReference<ActionListener<Void>> listenerCaptor;

    public FakeTcpChannel() {
        this(false, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer) {
        this(isServer, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer, InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this(isServer, localAddress, remoteAddress, "profile", new AtomicReference<BytesReference>());
    }

    public FakeTcpChannel(boolean isServer, AtomicReference<BytesReference> messageCaptor) {
        this(isServer, "profile", messageCaptor);
    }

    public FakeTcpChannel(boolean isServer, String profile, AtomicReference<BytesReference> messageCaptor) {
        this(isServer, null, null, profile, messageCaptor);
    }

    public FakeTcpChannel(boolean isServer, InetSocketAddress localAddress, InetSocketAddress remoteAddress, String profile, AtomicReference<BytesReference> messageCaptor) {
        this.isServer = isServer;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.profile = profile;
        this.messageCaptor = messageCaptor;
        this.listenerCaptor = new AtomicReference();
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.messageCaptor.set(reference);
        this.listenerCaptor.set(listener);
    }

    public void addConnectListener(ActionListener<Void> listener) {
    }

    public void close() {
        this.closeContext.complete(null);
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return !this.closeContext.isDone();
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public AtomicReference<BytesReference> getMessageCaptor() {
        return this.messageCaptor;
    }

    public AtomicReference<ActionListener<Void>> getListenerCaptor() {
        return this.listenerCaptor;
    }
}

