/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.common.logging.JsonLogLine;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class JsonLogsStream {
    private final XContentParser parser;
    private final BufferedReader reader;

    private JsonLogsStream(BufferedReader reader) throws IOException {
        this.reader = reader;
        this.parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (Reader)reader);
    }

    public static Stream<JsonLogLine> from(BufferedReader reader) throws IOException {
        return new JsonLogsStream(reader).stream();
    }

    public static Stream<JsonLogLine> from(Path path) throws IOException {
        return JsonLogsStream.from(Files.newBufferedReader(path));
    }

    public static Stream<Map<String, String>> mapStreamFrom(Path path) throws IOException {
        return new JsonLogsStream(Files.newBufferedReader(path)).streamMap();
    }

    private Stream<JsonLogLine> stream() {
        Spliterator<JsonLogLine> spliterator = Spliterators.spliteratorUnknownSize(new JsonIterator(), 16);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(this::close);
    }

    private Stream<Map<String, String>> streamMap() {
        Spliterator<Map<String, String>> spliterator = Spliterators.spliteratorUnknownSize(new MapIterator(), 16);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(this::close);
    }

    private void close() {
        try {
            this.parser.close();
            this.reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class JsonIterator
    implements Iterator<JsonLogLine> {
        private JsonIterator() {
        }

        @Override
        public boolean hasNext() {
            return !JsonLogsStream.this.parser.isClosed();
        }

        @Override
        public JsonLogLine next() {
            JsonLogLine apply = (JsonLogLine)JsonLogLine.PARSER.apply(JsonLogsStream.this.parser, null);
            this.nextToken();
            return apply;
        }

        private void nextToken() {
            try {
                JsonLogsStream.this.parser.nextToken();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private class MapIterator
    implements Iterator<Map<String, String>> {
        private MapIterator() {
        }

        @Override
        public boolean hasNext() {
            return !JsonLogsStream.this.parser.isClosed();
        }

        @Override
        public Map<String, String> next() {
            Map map;
            try {
                map = JsonLogsStream.this.parser.map(LinkedHashMap::new, XContentParser::text);
                JsonLogsStream.this.parser.nextToken();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return map;
        }
    }
}

