/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.transport.LeakTracker;

public class MockPageCacheRecycler
extends PageCacheRecycler {
    private final Random random = new Random(0L);

    public MockPageCacheRecycler(Settings settings) {
        super(settings);
    }

    private <T> Recycler.V<T> wrap(final Recycler.V<T> v) {
        return new Recycler.V<T>(){
            private final LeakTracker.Leak<Recycler.V<T>> leak;
            {
                this.leak = LeakTracker.INSTANCE.track(v);
            }

            public void close() {
                boolean leakReleased = this.leak.close(v);
                assert (leakReleased) : "leak should not have been released already";
                Object ref = this.v();
                if (ref instanceof Object[]) {
                    Arrays.fill((Object[])ref, 0, Array.getLength(ref), null);
                } else if (ref instanceof byte[]) {
                    Arrays.fill((byte[])ref, 0, Array.getLength(ref), (byte)MockPageCacheRecycler.this.random.nextInt(256));
                } else if (ref instanceof long[]) {
                    Arrays.fill((long[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextLong());
                } else if (ref instanceof int[]) {
                    Arrays.fill((int[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextInt());
                } else if (ref instanceof double[]) {
                    Arrays.fill((double[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextDouble() - 0.5);
                } else if (ref instanceof float[]) {
                    Arrays.fill((float[])ref, 0, Array.getLength(ref), MockPageCacheRecycler.this.random.nextFloat() - 0.5f);
                } else {
                    for (int i = 0; i < Array.getLength(ref); ++i) {
                        Array.set(ref, i, (byte)MockPageCacheRecycler.this.random.nextInt(256));
                    }
                }
                v.close();
            }

            public T v() {
                return v.v();
            }

            public boolean isRecycled() {
                return v.isRecycled();
            }
        };
    }

    public Recycler.V<byte[]> bytePage(boolean clear) {
        Recycler.V page = super.bytePage(clear);
        if (!clear) {
            Arrays.fill((byte[])page.v(), 0, ((byte[])page.v()).length, (byte)this.random.nextInt(256));
        }
        return this.wrap(page);
    }

    public Recycler.V<int[]> intPage(boolean clear) {
        Recycler.V page = super.intPage(clear);
        if (!clear) {
            Arrays.fill((int[])page.v(), 0, ((int[])page.v()).length, this.random.nextInt());
        }
        return this.wrap(page);
    }

    public Recycler.V<long[]> longPage(boolean clear) {
        Recycler.V page = super.longPage(clear);
        if (!clear) {
            Arrays.fill((long[])page.v(), 0, ((long[])page.v()).length, this.random.nextLong());
        }
        return this.wrap(page);
    }

    public Recycler.V<Object[]> objectPage() {
        return this.wrap(super.objectPage());
    }
}

