/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NameOrDefinition;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.mockito.Mockito;

public abstract class MapperServiceTestCase
extends ESTestCase {
    protected static final Settings SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT).build();
    protected static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Collections.singletonMap("include_defaults", "true"));

    protected Collection<? extends Plugin> getPlugins() {
        return Collections.emptyList();
    }

    protected Settings getIndexSettings() {
        return SETTINGS;
    }

    protected IndexAnalyzers createIndexAnalyzers(IndexSettings indexSettings) {
        return MapperServiceTestCase.createIndexAnalyzers();
    }

    protected static IndexAnalyzers createIndexAnalyzers() {
        return new IndexAnalyzers(Collections.singletonMap("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())), Collections.emptyMap(), Collections.emptyMap());
    }

    protected final String randomIndexOptions() {
        return MapperServiceTestCase.randomFrom("docs", "freqs", "positions", "offsets");
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings) throws IOException {
        return this.createMapperService(mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(Version version, XContentBuilder mappings) throws IOException {
        return this.createMapperService(version, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(Version version, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(version, this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge("_doc", mapperService, mappings);
        return mapperService.documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService.documentMapper();
    }

    protected MapperService createMapperService(XContentBuilder mappings) throws IOException {
        return this.createMapperService(Version.CURRENT, mappings);
    }

    protected final MapperService createMapperService(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService;
    }

    protected MapperService createMapperService(Settings settings, XContentBuilder mappings) throws IOException {
        return this.createMapperService(Version.CURRENT, settings, () -> true, mappings);
    }

    protected MapperService createMapperService(BooleanSupplier idFieldEnabled, XContentBuilder mappings) throws IOException {
        return this.createMapperService(Version.CURRENT, this.getIndexSettings(), idFieldEnabled, mappings);
    }

    protected final MapperService createMapperService(Settings settings, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(Version.CURRENT, settings, () -> true, this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge("_doc", mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(Version version, XContentBuilder mapping) throws IOException {
        return this.createMapperService(version, this.getIndexSettings(), () -> true, mapping);
    }

    protected final MapperService createMapperService(Version version, Settings settings, BooleanSupplier idFieldDataEnabled, XContentBuilder mapping) throws IOException {
        MapperService mapperService = this.createMapperService(version, settings, idFieldDataEnabled);
        this.merge(mapperService, mapping);
        return mapperService;
    }

    protected <T> T compileScript(Script script, ScriptContext<T> context) {
        throw new UnsupportedOperationException("Cannot compile script " + Strings.toString((ToXContent)script));
    }

    protected final MapperService createMapperService(Version version, Settings settings, BooleanSupplier idFieldDataEnabled) {
        IndexSettings indexSettings = MapperServiceTestCase.createIndexSettings(version, settings);
        MapperRegistry mapperRegistry = new IndicesModule(this.getPlugins().stream().filter(p -> p instanceof MapperPlugin).map(p -> (MapperPlugin)p).collect(Collectors.toList())).getMapperRegistry();
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
        return new MapperService(indexSettings, this.createIndexAnalyzers(indexSettings), this.xContentRegistry(), similarityService, mapperRegistry, () -> {
            throw new UnsupportedOperationException();
        }, idFieldDataEnabled, this::compileScript);
    }

    protected static IndexSettings createIndexSettings(Version version, Settings settings) {
        settings = Settings.builder().put("index.number_of_replicas", 0).put("index.number_of_shards", 1).put(settings).put("index.version.created", version).build();
        IndexMetadata meta = IndexMetadata.builder((String)"index").settings(settings).build();
        return new IndexSettings(meta, settings);
    }

    protected final void withLuceneIndex(MapperService mapperService, CheckedConsumer<RandomIndexWriter, IOException> builder, CheckedConsumer<IndexReader, IOException> test) throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(IndexShard.buildIndexAnalyzer((MapperService)mapperService));
        try (BaseDirectoryWrapper dir = MapperServiceTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)dir, iwc);){
            builder.accept((Object)iw);
            try (DirectoryReader reader = iw.getReader();){
                test.accept((Object)reader);
            }
        }
    }

    protected final SourceToParse source(CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        return this.source("1", build, null);
    }

    protected final SourceToParse source(String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing) throws IOException {
        return this.source("test", id, build, routing, org.elasticsearch.core.Map.of());
    }

    protected final SourceToParse source(String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing, Map<String, String> dynamicTemplates) throws IOException {
        return this.source("text", id, build, routing, dynamicTemplates);
    }

    protected final SourceToParse source(String index, String id, CheckedConsumer<XContentBuilder, IOException> build, @Nullable String routing, Map<String, String> dynamicTemplates) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().startObject();
        build.accept((Object)builder);
        builder.endObject();
        return new SourceToParse("test", "_doc", id, BytesReference.bytes((XContentBuilder)builder), XContentType.JSON, routing, dynamicTemplates);
    }

    protected final SourceToParse source(String source) {
        return new SourceToParse("test", "_doc", "1", (BytesReference)new BytesArray(source), XContentType.JSON);
    }

    protected final void merge(MapperService mapperService, XContentBuilder mapping) throws IOException {
        this.merge(mapperService, MapperService.MergeReason.MAPPING_UPDATE, mapping);
    }

    protected final void merge(String type, MapperService mapperService, String mapping) throws IOException {
        mapperService.merge(type, new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
    }

    protected final void merge(MapperService mapperService, MapperService.MergeReason reason, String mapping) throws IOException {
        mapperService.merge("_doc", new CompressedXContent(mapping), reason);
    }

    protected final void merge(MapperService mapperService, MapperService.MergeReason reason, XContentBuilder mapping) throws IOException {
        mapperService.merge("_doc", new CompressedXContent(BytesReference.bytes((XContentBuilder)mapping)), reason);
    }

    protected final XContentBuilder topMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject();
    }

    protected final XContentBuilder mapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected final XContentBuilder dynamicMapping(Mapping dynamicMapping) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        dynamicMapping.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder.endObject();
    }

    protected final XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected final XContentBuilder runtimeFieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return this.runtimeMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected final XContentBuilder runtimeMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("runtime");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    private AggregationContext aggregationContext(final ValuesSourceRegistry valuesSourceRegistry, final MapperService mapperService, final IndexSearcher searcher, final Query query) {
        return new AggregationContext(){
            private final CircuitBreaker breaker = (CircuitBreaker)Mockito.mock(CircuitBreaker.class);
            private final MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(Integer.MAX_VALUE, this.breaker);

            public IndexSearcher searcher() {
                return searcher;
            }

            public Aggregator profileIfEnabled(Aggregator agg) throws IOException {
                return agg;
            }

            public boolean profiling() {
                return false;
            }

            public Query query() {
                return query;
            }

            public long nowInMillis() {
                return 0L;
            }

            public Analyzer getNamedAnalyzer(String analyzer) {
                return null;
            }

            public Analyzer buildCustomAnalyzer(IndexSettings indexSettings, boolean normalizer, NameOrDefinition tokenizer, List<NameOrDefinition> charFilters, List<NameOrDefinition> tokenFilters) {
                return null;
            }

            public boolean isFieldMapped(String field) {
                throw new UnsupportedOperationException();
            }

            public SearchLookup lookup() {
                throw new UnsupportedOperationException();
            }

            public ValuesSourceRegistry getValuesSourceRegistry() {
                return valuesSourceRegistry;
            }

            public IndexSettings getIndexSettings() {
                throw new UnsupportedOperationException();
            }

            public MappedFieldType getFieldType(String path) {
                return mapperService.fieldType(path);
            }

            public Set<String> getMatchingFieldNames(String pattern) {
                throw new UnsupportedOperationException();
            }

            public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
                throw new UnsupportedOperationException();
            }

            public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query buildQuery(QueryBuilder builder) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Query filterQuery(Query query2) {
                throw new UnsupportedOperationException();
            }

            protected IndexFieldData<?> buildFieldData(MappedFieldType ft) {
                return ft.fielddataBuilder("test", null).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public BigArrays bigArrays() {
                return new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
            }

            public ObjectMapper getObjectMapper(String path) {
                throw new UnsupportedOperationException();
            }

            public NestedScope nestedScope() {
                throw new UnsupportedOperationException();
            }

            public SubSearchContext subSearchContext() {
                throw new UnsupportedOperationException();
            }

            public void addReleasable(Aggregator aggregator) {
            }

            public MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer() {
                return this.multiBucketConsumer;
            }

            public BitsetFilterCache bitsetFilterCache() {
                throw new UnsupportedOperationException();
            }

            public BucketedSort buildBucketedSort(SortBuilder<?> sort, int size, BucketedSort.ExtraData values) throws IOException {
                throw new UnsupportedOperationException();
            }

            public int shardRandomSeed() {
                throw new UnsupportedOperationException();
            }

            public long getRelativeTimeInMillis() {
                return 0L;
            }

            public boolean isCancelled() {
                return false;
            }

            public CircuitBreaker breaker() {
                return this.breaker;
            }

            public Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
                throw new UnsupportedOperationException();
            }

            public Version indexVersionCreated() {
                throw new UnsupportedOperationException();
            }

            public boolean isCacheable() {
                throw new UnsupportedOperationException();
            }

            public boolean enableRewriteToFilterByFilter() {
                throw new UnsupportedOperationException();
            }

            public void close() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected final void withAggregationContext(MapperService mapperService, List<SourceToParse> docs, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withAggregationContext(null, mapperService, docs, null, test);
    }

    protected final void withAggregationContext(ValuesSourceRegistry valuesSourceRegistry, MapperService mapperService, List<SourceToParse> docs, Query query, CheckedConsumer<AggregationContext, IOException> test) throws IOException {
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)writer -> {
            for (SourceToParse doc : docs) {
                writer.addDocuments((Iterable)mapperService.documentMapper().parse(doc).docs());
            }
        }), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)reader -> test.accept((Object)this.aggregationContext(valuesSourceRegistry, mapperService, new IndexSearcher(reader), query))));
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService) {
        return this.createSearchExecutionContext(mapperService, null);
    }

    protected SearchExecutionContext createSearchExecutionContext(MapperService mapperService, IndexSearcher searcher) {
        SimilarityService similarityService = new SimilarityService(mapperService.getIndexSettings(), null, org.elasticsearch.core.Map.of());
        long nowInMillis = MapperServiceTestCase.randomNonNegativeLong();
        return new SearchExecutionContext(0, 0, mapperService.getIndexSettings(), null, (ft, idxName, lookup) -> ft.fielddataBuilder(idxName, lookup).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()), mapperService, mapperService.mappingLookup(), similarityService, null, this.xContentRegistry(), this.writableRegistry(), null, searcher, () -> nowInMillis, null, null, () -> true, null, Collections.emptyMap());
    }

    protected BiFunction<MappedFieldType, Supplier<SearchLookup>, IndexFieldData<?>> fieldDataLookup() {
        return (mft, lookupSource) -> mft.fielddataBuilder("test", lookupSource).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
    }
}

