/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.ESBlobStoreRepositoryIntegTestCase;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class ESFsBasedRepositoryIntegTestCase
extends ESBlobStoreRepositoryIntegTestCase {
    @Override
    protected String repositoryType() {
        return "fs";
    }

    public void testMissingDirectoriesNotCreatedInReadonlyRepository() throws IOException, InterruptedException {
        Path deletedPath;
        String repoName = this.randomRepositoryName();
        Path repoPath = ESFsBasedRepositoryIntegTestCase.randomRepoPath();
        Settings repoSettings = Settings.builder().put(this.repositorySettings(repoName)).put("location", repoPath).build();
        this.createRepository(repoName, repoSettings, ESFsBasedRepositoryIntegTestCase.randomBoolean());
        String indexName = this.randomName();
        int docCount = ESFsBasedRepositoryIntegTestCase.iterations(10, 1000);
        this.logger.info("-->  create random index {} with {} records", (Object)indexName, (Object)docCount);
        this.addRandomDocuments(indexName, docCount);
        ElasticsearchAssertions.assertHitCount((SearchResponse)ESFsBasedRepositoryIntegTestCase.client().prepareSearch(new String[]{indexName}).setSize(0).get(), docCount);
        String snapshotName = this.randomName();
        this.logger.info("-->  create snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        ESFsBasedRepositoryIntegTestCase.assertSuccessfulSnapshot(ESFsBasedRepositoryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setIndices(new String[]{indexName}));
        ElasticsearchAssertions.assertAcked(ESFsBasedRepositoryIntegTestCase.client().admin().indices().prepareDelete(new String[]{indexName}));
        ElasticsearchAssertions.assertAcked(ESFsBasedRepositoryIntegTestCase.client().admin().cluster().prepareDeleteRepository(repoName));
        try (Stream<Path> contents = Files.list(repoPath.resolve("indices"));){
            deletedPath = contents.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().get();
            IOUtils.rm((Path[])new Path[]{deletedPath});
        }
        ESFsBasedRepositoryIntegTestCase.assertFalse((boolean)Files.exists(deletedPath, new LinkOption[0]));
        this.createRepository(repoName, Settings.builder().put(repoSettings).put("readonly", true).build(), ESFsBasedRepositoryIntegTestCase.randomBoolean());
        ElasticsearchException exception = (ElasticsearchException)ESFsBasedRepositoryIntegTestCase.expectThrows(ElasticsearchException.class, () -> ESFsBasedRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName).setWaitForCompletion(ESFsBasedRepositoryIntegTestCase.randomBoolean()).get());
        ESFsBasedRepositoryIntegTestCase.assertThat((Object)exception.getRootCause(), (Matcher)Matchers.instanceOf(NoSuchFileException.class));
        ESFsBasedRepositoryIntegTestCase.assertFalse((String)"deleted path is not recreated in readonly repository", (boolean)Files.exists(deletedPath, new LinkOption[0]));
    }

    public void testReadOnly() throws Exception {
        BlobPath blobPath;
        String repoName = this.randomRepositoryName();
        Path repoPath = ESFsBasedRepositoryIntegTestCase.randomRepoPath();
        Settings repoSettings = Settings.builder().put(this.repositorySettings(repoName)).put("readonly", true).put(FsRepository.LOCATION_SETTING.getKey(), repoPath).put(BlobStoreRepository.BUFFER_SIZE_SETTING.getKey(), String.valueOf(ESFsBasedRepositoryIntegTestCase.randomIntBetween(1, 8) * 1024) + "kb").build();
        this.createRepository(repoName, repoSettings, false);
        try (BlobStore store = this.newBlobStore(repoName);){
            ESFsBasedRepositoryIntegTestCase.assertFalse((boolean)Files.exists(repoPath, new LinkOption[0]));
            blobPath = BlobPath.EMPTY.add("foo");
            store.blobContainer(blobPath);
            Path storePath = repoPath;
            for (Object d : blobPath.parts()) {
                storePath = storePath.resolve((String)d);
            }
            ESFsBasedRepositoryIntegTestCase.assertFalse((boolean)Files.exists(storePath, new LinkOption[0]));
        }
        this.createRepository(repoName, Settings.builder().put(repoSettings).put("readonly", false).build(), false);
        store = this.newBlobStore(repoName);
        try {
            ESFsBasedRepositoryIntegTestCase.assertTrue((boolean)Files.exists(repoPath, new LinkOption[0]));
            blobPath = BlobPath.EMPTY.add("foo");
            BlobContainer container = store.blobContainer(blobPath);
            Path storePath = repoPath;
            for (String d : blobPath.parts()) {
                storePath = storePath.resolve(d);
            }
            ESFsBasedRepositoryIntegTestCase.assertTrue((boolean)Files.exists(storePath, new LinkOption[0]));
            ESFsBasedRepositoryIntegTestCase.assertTrue((boolean)Files.isDirectory(storePath, new LinkOption[0]));
            byte[] data = ESFsBasedRepositoryIntegTestCase.randomBytes(ESFsBasedRepositoryIntegTestCase.randomIntBetween(10, ESFsBasedRepositoryIntegTestCase.scaledRandomIntBetween(1024, 65536)));
            ESFsBasedRepositoryIntegTestCase.writeBlob(container, "test", new BytesArray(data));
            ESFsBasedRepositoryIntegTestCase.assertArrayEquals((byte[])ESFsBasedRepositoryIntegTestCase.readBlobFully(container, "test", data.length), (byte[])data);
            ESFsBasedRepositoryIntegTestCase.assertTrue((boolean)container.blobExists("test"));
        }
        finally {
            if (store != null) {
                store.close();
            }
        }
    }
}

