/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.geo;

import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.test.TestGeoShapeFieldMapperPlugin;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class GeoPointShapeQueryTestCase
extends ESSingleNodeTestCase {
    protected static final String defaultGeoFieldName = "geo";
    protected static final String defaultIndexName = "test";
    protected static final String defaultType = "_doc";

    @Override
    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.singleton(TestGeoShapeFieldMapperPlugin.class);
    }

    protected abstract void createMapping(String var1, String var2, String var3, Settings var4) throws Exception;

    protected void createMapping(String indexName, String type, String fieldName) throws Exception {
        this.createMapping(indexName, type, fieldName, Settings.EMPTY);
    }

    public void testNullShape() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("aNullshape").setSource("{\"geo\": null}", XContentType.JSON).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        GetResponse result = (GetResponse)this.client().prepareGet(defaultIndexName, defaultType, "aNullshape").get();
        GeoPointShapeQueryTestCase.assertThat((Object)result.getField("location"), (Matcher)Matchers.nullValue());
    }

    public void testIndexPointsFilterRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultGeoFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Rectangle geometry = new Rectangle(-45.0, 45.0, 45.0, -45.0);
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)geometry).relation(ShapeRelation.INTERSECTS)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)geometry)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testIndexPointsCircle() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultGeoFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Circle geometry = new Circle(-30.0, -30.0, 100.0);
        try {
            this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)geometry).relation(ShapeRelation.INTERSECTS)).get();
        }
        catch (Exception e) {
            GeoPointShapeQueryTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)("failed to create query: " + ShapeType.CIRCLE + " geometry is not supported")));
        }
    }

    public void testIndexPointsPolygon() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Polygon polygon = new Polygon(new LinearRing(new double[]{-35.0, -35.0, -25.0, -25.0, -35.0}, new double[]{-35.0, -25.0, -25.0, -35.0, -35.0}));
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)polygon).relation(ShapeRelation.INTERSECTS)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        ElasticsearchAssertions.assertHitCount(searchResponse, 1L);
        SearchHits searchHits = searchResponse.getHits();
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testIndexPointsMultiPolygon() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultGeoFieldName, "POINT(-40 -40)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 3").field(defaultGeoFieldName, "POINT(-50 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Polygon encloseDocument1Cb = new Polygon(new LinearRing(new double[]{-35.0, -35.0, -25.0, -25.0, -35.0}, new double[]{-35.0, -25.0, -25.0, -35.0, -35.0}));
        Polygon encloseDocument2Cb = new Polygon(new LinearRing(new double[]{-55.0, -55.0, -45.0, -45.0, -55.0}, new double[]{-55.0, -45.0, -45.0, -55.0, -55.0}));
        MultiPolygon multiPolygon = new MultiPolygon(List.of((Object)encloseDocument1Cb, (Object)encloseDocument2Cb));
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPolygon).relation(ShapeRelation.INTERSECTS)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        ElasticsearchAssertions.assertHitCount(searchResponse, 2L);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPolygon).relation(ShapeRelation.WITHIN)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)2L));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)2));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"2")));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPolygon).relation(ShapeRelation.DISJOINT)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)1L));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)1));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"2"));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPolygon).relation(ShapeRelation.CONTAINS)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getTotalHits().value, (Matcher)Matchers.equalTo((Object)0L));
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getHits().length, (Matcher)Matchers.equalTo((Object)0));
    }

    public void testIndexPointsRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 1").field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field("name", "Document 2").field(defaultGeoFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Rectangle rectangle = new Rectangle(-50.0, -40.0, -45.0, -55.0);
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)rectangle).relation(ShapeRelation.INTERSECTS)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        ElasticsearchAssertions.assertHitCount(searchResponse, 1L);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"2"));
    }

    public void testIndexPointsIndexedRectangle() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("point1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-30 -30)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("point2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-45 -50)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        String indexedShapeIndex = "indexed_query_shapes";
        String indexedShapePath = "shape";
        XContentBuilder xcb = XContentFactory.jsonBuilder().startObject().startObject("properties").startObject(indexedShapePath).field("type", "geo_shape").endObject().endObject().endObject();
        this.client().admin().indices().prepareCreate(indexedShapeIndex).addMapping(defaultIndexName, xcb).get();
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(indexedShapeIndex, defaultType).setId("shape1").setSource(XContentFactory.jsonBuilder().startObject().field(indexedShapePath, "BBOX(-50, -40, -45, -55)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(indexedShapeIndex, defaultType).setId("shape2").setSource(XContentFactory.jsonBuilder().startObject().field(indexedShapePath, "BBOX(-60, -50, -50, -60)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        SearchResponse searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (String)"shape1").relation(ShapeRelation.INTERSECTS).indexedShapeIndex(indexedShapeIndex)).indexedShapePath(indexedShapePath)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        ElasticsearchAssertions.assertHitCount(searchResponse, 1L);
        GeoPointShapeQueryTestCase.assertThat((Object)searchResponse.getHits().getAt(0).getId(), (Matcher)Matchers.equalTo((Object)"point2"));
        searchResponse = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)((GeoShapeQueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (String)"shape2").relation(ShapeRelation.INTERSECTS).indexedShapeIndex(indexedShapeIndex)).indexedShapePath(indexedShapePath)).get();
        ElasticsearchAssertions.assertSearchResponse(searchResponse);
        ElasticsearchAssertions.assertHitCount(searchResponse, 0L);
    }

    public void testRectangleSpanningDateline() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-169 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-179 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(171 0)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Rectangle rectangle = new Rectangle(169.0, -178.0, 1.0, -1.0);
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)rectangle);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        SearchHits searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"1")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"1")));
    }

    public void testPolygonSpanningDateline() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-169 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("4").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(171 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Polygon polygon = new Polygon(new LinearRing(new double[]{-177.0, 177.0, 177.0, -177.0, -177.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)polygon);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        SearchHits searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"1")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"1")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"4")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"4")));
    }

    public void testMultiPolygonSpanningDateline() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-169 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("2").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-179 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("3").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(171 7)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Polygon polygon1 = new Polygon(new LinearRing(new double[]{-167.0, -171.0, 171.0, -167.0, -167.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        Polygon polygon2 = new Polygon(new LinearRing(new double[]{-177.0, 177.0, 177.0, -177.0, -177.0}, new double[]{10.0, 10.0, 5.0, 5.0, 10.0}));
        MultiPolygon multiPolygon = new MultiPolygon(List.of((Object)polygon1, (Object)polygon2));
        GeoShapeQueryBuilder geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPolygon);
        geoShapeQueryBuilder.relation(ShapeRelation.INTERSECTS);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)geoShapeQueryBuilder).get();
        SearchHits searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(0).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"3")));
        GeoPointShapeQueryTestCase.assertThat((Object)searchHits.getAt(1).getId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"3")));
    }

    public void testWithInQueryLine() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        Line line = new Line(new double[]{-25.0, -35.0}, new double[]{-25.0, -35.0});
        try {
            this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)line).relation(ShapeRelation.WITHIN)).get();
        }
        catch (SearchPhaseExecutionException e) {
            GeoPointShapeQueryTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Field [geo] found an unsupported shape Line"));
        }
    }

    public void testQueryWithinMultiLine() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        Line lsb1 = new Line(new double[]{-35.0, -25.0}, new double[]{-35.0, -25.0});
        Line lsb2 = new Line(new double[]{-15.0, -5.0}, new double[]{-15.0, -5.0});
        MultiLine multiline = new MultiLine(List.of((Object)lsb1, (Object)lsb2));
        try {
            this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiline).relation(ShapeRelation.WITHIN)).get();
        }
        catch (SearchPhaseExecutionException e) {
            GeoPointShapeQueryTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Field [geo] found an unsupported shape Line"));
        }
    }

    public void testQueryLinearRing() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        LinearRing linearRing = new LinearRing(new double[]{-25.0, -35.0, -25.0}, new double[]{-25.0, -35.0, -25.0});
        GeoShapeQueryBuilder queryBuilder = new GeoShapeQueryBuilder(defaultGeoFieldName, (Geometry)linearRing);
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this.client(), SearchAction.INSTANCE);
        searchRequestBuilder.setQuery((QueryBuilder)queryBuilder);
        searchRequestBuilder.setIndices(new String[]{defaultIndexName});
        SearchPhaseExecutionException e = (SearchPhaseExecutionException)GeoPointShapeQueryTestCase.expectThrows(SearchPhaseExecutionException.class, () -> ((SearchRequestBuilder)searchRequestBuilder).get());
        GeoPointShapeQueryTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"LinearRing"));
    }

    public void testQueryPoint() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-35 -25)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        Point point = new Point(-35.0, -25.0);
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)point)).get();
        SearchHits searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)1L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)point).relation(ShapeRelation.WITHIN)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)1L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)point).relation(ShapeRelation.CONTAINS)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)1L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)point).relation(ShapeRelation.DISJOINT)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)0L, (long)searchHits.getTotalHits().value);
    }

    public void testQueryMultiPoint() throws Exception {
        this.createMapping(defaultIndexName, defaultType, defaultGeoFieldName);
        this.ensureGreen(new String[0]);
        ((IndexRequestBuilder)this.client().prepareIndex(defaultIndexName, defaultType).setId("1").setSource(XContentFactory.jsonBuilder().startObject().field(defaultGeoFieldName, "POINT(-35 -25)").endObject()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).get();
        MultiPoint multiPoint = new MultiPoint(List.of((Object)new Point(-35.0, -25.0), (Object)new Point(-15.0, -5.0)));
        SearchResponse response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPoint)).get();
        SearchHits searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)1L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPoint).relation(ShapeRelation.WITHIN)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)1L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPoint).relation(ShapeRelation.CONTAINS)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)0L, (long)searchHits.getTotalHits().value);
        response = (SearchResponse)this.client().prepareSearch(new String[]{defaultIndexName}).setQuery((QueryBuilder)QueryBuilders.geoShapeQuery((String)defaultGeoFieldName, (Geometry)multiPoint).relation(ShapeRelation.DISJOINT)).get();
        searchHits = response.getHits();
        GeoPointShapeQueryTestCase.assertEquals((long)0L, (long)searchHits.getTotalHits().value);
    }
}

