/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.AbstractWireSerializingTestCase;
import org.elasticsearch.test.AbstractXContentTestCase;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.cbor.CborXContent;
import org.elasticsearch.xcontent.smile.SmileXContent;

public abstract class AbstractSerializingTestCase<T extends ToXContent & Writeable>
extends AbstractWireSerializingTestCase<T> {
    public final void testFromXContent() throws IOException {
        AbstractXContentTestCase.xContentTester((CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), this::createXContextTestInstance, this.getToXContentParams(), this::doParseInstance).numberOfTestRuns(20).supportsUnknownFields(this.supportsUnknownFields()).shuffleFieldsExceptions(this.getShuffleFieldsExceptions()).randomFieldsExcludeFilter(this.getRandomFieldsExcludeFilter()).assertEqualsConsumer((x$0, x$1) -> this.assertEqualInstances(x$0, x$1)).assertToXContentEquivalence(this.assertToXContentEquivalence()).test();
    }

    public final void testConcurrentToXContent() throws IOException, InterruptedException, ExecutionException {
        XContentType xContentType = AbstractSerializingTestCase.randomValueOtherThanMany(type -> type.xContent() == SmileXContent.smileXContent, () -> AbstractSerializingTestCase.randomFrom(XContentType.values()));
        T testInstance = this.createXContextTestInstance(xContentType);
        ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(Collections.singletonMap("typed_keys", "true"), this.getToXContentParams());
        boolean humanReadable = AbstractSerializingTestCase.randomBoolean();
        BytesRef firstTimeBytes = XContentHelper.toXContent(testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
        int rounds = AbstractSerializingTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> AbstractSerializingTestCase.lambda$testConcurrentToXContent$3(rounds, testInstance, xContentType, (ToXContent.Params)params, humanReadable, firstTimeBytes));
    }

    protected abstract T doParseInstance(XContentParser var1) throws IOException;

    protected T createXContextTestInstance(XContentType xContentType) {
        return (T)((ToXContent)this.createTestInstance());
    }

    protected boolean supportsUnknownFields() {
        return false;
    }

    protected Predicate<String> getRandomFieldsExcludeFilter() {
        return field -> false;
    }

    protected String[] getShuffleFieldsExceptions() {
        return Strings.EMPTY_ARRAY;
    }

    protected ToXContent.Params getToXContentParams() {
        return ToXContent.EMPTY_PARAMS;
    }

    protected boolean assertToXContentEquivalence() {
        return true;
    }

    protected Date randomDate() {
        return new Date(AbstractSerializingTestCase.randomLongBetween(0L, 3000000000000L));
    }

    protected Instant randomInstant() {
        return Instant.ofEpochSecond(AbstractSerializingTestCase.randomLongBetween(0L, 3000000000L), AbstractSerializingTestCase.randomLongBetween(0L, 999999999L));
    }

    private static /* synthetic */ void lambda$testConcurrentToXContent$3(int rounds, ToXContent testInstance, XContentType xContentType, ToXContent.Params params, boolean humanReadable, BytesRef firstTimeBytes) {
        try {
            for (int r = 0; r < rounds; ++r) {
                BytesRef thisRoundBytes = XContentHelper.toXContent((ToXContent)testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
                if (firstTimeBytes.bytesEquals(thisRoundBytes)) continue;
                StringBuilder error = new StringBuilder("Failed to round trip over ");
                if (humanReadable) {
                    error.append("human readable ");
                }
                error.append(xContentType);
                error.append("\nCanonical is:\n").append(Strings.toString((ToXContent)testInstance, (boolean)true, (boolean)true));
                boolean showBytes = xContentType.xContent() == CborXContent.cborXContent;
                error.append("\nWanted : ").append(showBytes ? firstTimeBytes : firstTimeBytes.utf8ToString());
                error.append("\nBut got: ").append(showBytes ? thisRoundBytes : thisRoundBytes.utf8ToString());
                AbstractSerializingTestCase.fail((String)error.toString());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

