/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoTileGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedAutoDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedVariableWidthHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringRareTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.ParsedMedianAbsoluteDeviation;
import org.elasticsearch.search.aggregations.metrics.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.ParsedValueCount;
import org.elasticsearch.search.aggregations.metrics.ParsedWeightedAvg;
import org.elasticsearch.search.aggregations.pipeline.AvgBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.MaxBucketPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedDerivative;
import org.elasticsearch.search.aggregations.pipeline.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.ParsedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SumBucketPipelineAggregationBuilder;
import org.elasticsearch.test.AbstractNamedWriteableTestCase;
import org.elasticsearch.test.XContentTestUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class InternalAggregationTestCase<T extends InternalAggregation>
extends AbstractNamedWriteableTestCase<T> {
    public static final int DEFAULT_MAX_BUCKETS = 100000;
    protected static final double TOLERANCE = 1.0E-10;
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.isMapped() == agg2.isMapped()) {
            return 0;
        }
        if (agg1.isMapped() && !agg2.isMapped()) {
            return -1;
        }
        return 1;
    };
    private final NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(this.getNamedWriteables());
    private final NamedXContentRegistry namedXContentRegistry = new NamedXContentRegistry(this.getNamedXContents());
    private static final List<NamedXContentRegistry.Entry> namedXContents;

    public static InternalAggregation.ReduceContextBuilder emptyReduceContextBuilder() {
        return InternalAggregationTestCase.emptyReduceContextBuilder(PipelineAggregator.PipelineTree.EMPTY);
    }

    public static InternalAggregation.ReduceContextBuilder emptyReduceContextBuilder(final PipelineAggregator.PipelineTree pipelineTree) {
        return new InternalAggregation.ReduceContextBuilder(){

            public InternalAggregation.ReduceContext forPartialReduction() {
                return InternalAggregation.ReduceContext.forPartialReduction((BigArrays)BigArrays.NON_RECYCLING_INSTANCE, null, () -> pipelineTree, () -> false);
            }

            public InternalAggregation.ReduceContext forFinalReduction() {
                return InternalAggregation.ReduceContext.forFinalReduction((BigArrays)BigArrays.NON_RECYCLING_INSTANCE, null, b -> {}, (PipelineAggregator.PipelineTree)pipelineTree, () -> false);
            }
        };
    }

    public static List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        return namedXContents;
    }

    protected List<NamedXContentRegistry.Entry> getNamedXContents() {
        return namedXContents;
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.namedXContentRegistry;
    }

    @Override
    protected final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    protected List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        SearchPlugin plugin = this.registerPlugin();
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, plugin == null ? Collections.emptyList() : Collections.singletonList(plugin));
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>(searchModule.getNamedWriteables());
        if (plugin != null) {
            entries.addAll(((Plugin)plugin).getNamedWriteables());
        }
        return entries;
    }

    protected SearchPlugin registerPlugin() {
        return null;
    }

    protected abstract T createTestInstance(String var1, Map<String, Object> var2);

    protected T createUnmappedInstance(String name, Map<String, Object> metadata) {
        return this.createTestInstance(name, metadata);
    }

    @Override
    protected final Class<T> categoryClass() {
        return InternalAggregation.class;
    }

    protected List<T> randomResultsToReduce(String name, int size) {
        ArrayList<T> inputs = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T t = InternalAggregationTestCase.randomBoolean() ? this.createUnmappedInstance(name) : this.createTestInstance(name);
            inputs.add(t);
        }
        return inputs;
    }

    public void testReduceRandom() throws IOException {
        String name = InternalAggregationTestCase.randomAlphaOfLength(5);
        int size = InternalAggregationTestCase.between(1, 200);
        List<T> inputs = this.randomResultsToReduce(name, size);
        InternalAggregationTestCase.assertThat(inputs, (Matcher)Matchers.hasSize((int)size));
        ArrayList<Object> toReduce = new ArrayList<Object>();
        toReduce.addAll(inputs);
        inputs.sort(INTERNAL_AGG_COMPARATOR);
        ScriptService mockScriptService = this.mockScriptService();
        MockBigArrays bigArrays = new MockBigArrays((PageCacheRecycler)new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)new NoneCircuitBreakerService());
        if (InternalAggregationTestCase.randomBoolean() && toReduce.size() > 1) {
            Collections.shuffle(toReduce, InternalAggregationTestCase.random());
            int r = InternalAggregationTestCase.randomIntBetween(1, inputs.size());
            List<InternalAggregation> toPartialReduce = toReduce.subList(0, r);
            toPartialReduce.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forPartialReduction((BigArrays)bigArrays, (ScriptService)mockScriptService, () -> PipelineAggregator.PipelineTree.EMPTY, () -> false);
            InternalAggregation reduced = ((InternalAggregation)toPartialReduce.get(0)).reduce(toPartialReduce, context);
            int initialBucketCount = 0;
            for (InternalAggregation internalAggregation : toPartialReduce) {
                initialBucketCount += InternalMultiBucketAggregation.countInnerBucket((Aggregation)internalAggregation);
            }
            int reducedBucketCount = InternalMultiBucketAggregation.countInnerBucket((Aggregation)reduced);
            InternalAggregationTestCase.assertThat((Object)reducedBucketCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(initialBucketCount)));
            if (InternalAggregationTestCase.randomBoolean()) {
                reduced = InternalAggregationTestCase.copyNamedWriteable(reduced, this.getNamedWriteableRegistry(), this.categoryClass());
            }
            toReduce = new ArrayList(toReduce.subList(r, inputs.size()));
            toReduce.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request"));
        InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forFinalReduction((BigArrays)bigArrays, (ScriptService)mockScriptService, (IntConsumer)bucketConsumer, (PipelineAggregator.PipelineTree)PipelineAggregator.PipelineTree.EMPTY, () -> false);
        InternalAggregation reduced = ((InternalAggregation)inputs.get(0)).reduce(toReduce, context);
        this.doAssertReducedMultiBucketConsumer((Aggregation)reduced, bucketConsumer);
        this.assertReduced(reduced, inputs);
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected ScriptService mockScriptService() {
        return null;
    }

    protected abstract void assertReduced(T var1, List<T> var2);

    @Override
    public final T createTestInstance() {
        return this.createTestInstance(InternalAggregationTestCase.randomAlphaOfLength(5));
    }

    public final Map<String, Object> createTestMetadata() {
        HashMap<String, String> metadata = null;
        if (InternalAggregationTestCase.randomBoolean()) {
            metadata = new HashMap<String, String>();
            int metadataCount = InternalAggregationTestCase.between(0, 10);
            while (metadata.size() < metadataCount) {
                metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
            }
        }
        return metadata;
    }

    private T createTestInstance(String name) {
        return this.createTestInstance(name, this.createTestMetadata());
    }

    protected final T createUnmappedInstance(String name) {
        int metadataCount;
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        int n = metadataCount = InternalAggregationTestCase.randomBoolean() ? 0 : InternalAggregationTestCase.between(1, 10);
        while (metadata.size() < metadataCount) {
            metadata.put(InternalAggregationTestCase.randomAlphaOfLength(5), InternalAggregationTestCase.randomAlphaOfLength(5));
        }
        return this.createUnmappedInstance(name, metadata);
    }

    public T createTestInstanceForXContent() {
        return this.createTestInstance();
    }

    public final void testFromXContent() throws IOException {
        T aggregation = this.createTestInstanceForXContent();
        Object parsedAggregation = this.parseAndAssert((InternalAggregation)aggregation, InternalAggregationTestCase.randomBoolean(), false);
        this.assertFromXContent(aggregation, (ParsedAggregation)parsedAggregation);
    }

    public final void testFromXContentWithRandomFields() throws IOException {
        T aggregation = this.createTestInstanceForXContent();
        Object parsedAggregation = this.parseAndAssert((InternalAggregation)aggregation, InternalAggregationTestCase.randomBoolean(), true);
        this.assertFromXContent(aggregation, (ParsedAggregation)parsedAggregation);
    }

    public void testMergePipelineTreeForBWCSerialization() {
        T agg = this.createTestInstance();
        PipelineAggregator.PipelineTree pipelineTree = InternalAggregationTestCase.randomPipelineTree(agg);
        agg.mergePipelineTreeForBWCSerialization(pipelineTree);
        this.assertMergedPipelineTreeForBWCSerialization((InternalAggregation)agg, pipelineTree);
    }

    public void testMergePipelineTreeTwice() {
        T agg = this.createTestInstance();
        PipelineAggregator.PipelineTree pipelineTree = InternalAggregationTestCase.randomPipelineTree(agg);
        agg.mergePipelineTreeForBWCSerialization(pipelineTree);
        agg.mergePipelineTreeForBWCSerialization(InternalAggregationTestCase.randomPipelineTree(agg));
        this.assertMergedPipelineTreeForBWCSerialization((InternalAggregation)agg, pipelineTree);
    }

    public static PipelineAggregator.PipelineTree randomPipelineTree(InternalAggregation aggregation) {
        HashMap subTree = new HashMap();
        aggregation.forEachBucket(bucketAggs -> {
            for (Aggregation subAgg : bucketAggs) {
                if (subTree.containsKey(subAgg.getName())) continue;
                subTree.put(subAgg.getName(), InternalAggregationTestCase.randomPipelineTree((InternalAggregation)subAgg));
            }
        });
        return new PipelineAggregator.PipelineTree(Collections.emptyMap(), InternalAggregationTestCase.randomPipelineAggregators());
    }

    public static List<PipelineAggregator> randomPipelineAggregators() {
        ArrayList<PipelineAggregator> pipelines = new ArrayList<PipelineAggregator>();
        if (InternalAggregationTestCase.randomBoolean()) {
            if (InternalAggregationTestCase.randomBoolean()) {
                pipelines.add(new MaxBucketPipelineAggregationBuilder("name1", "bucket1").create());
            }
            if (InternalAggregationTestCase.randomBoolean()) {
                pipelines.add(new AvgBucketPipelineAggregationBuilder("name2", "bucket2").create());
            }
            if (InternalAggregationTestCase.randomBoolean()) {
                pipelines.add(new SumBucketPipelineAggregationBuilder("name3", "bucket3").create());
            }
        }
        return pipelines;
    }

    private void assertMergedPipelineTreeForBWCSerialization(InternalAggregation agg, PipelineAggregator.PipelineTree pipelineTree) {
        InternalAggregationTestCase.assertThat((Object)agg.pipelineAggregatorsForBwcSerialization(), (Matcher)Matchers.equalTo((Object)pipelineTree.aggregators()));
        agg.forEachBucket(bucketAggs -> {
            for (Aggregation subAgg : bucketAggs) {
                this.assertMergedPipelineTreeForBWCSerialization((InternalAggregation)subAgg, pipelineTree.subTree(subAgg.getName()));
            }
        });
    }

    protected abstract void assertFromXContent(T var1, ParsedAggregation var2) throws IOException;

    public final void testConcurrentToXContent() throws IOException, InterruptedException, ExecutionException {
        T testInstance = this.createTestInstanceForXContent();
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
        XContentType xContentType = InternalAggregationTestCase.randomFrom(XContentType.values());
        boolean humanReadable = InternalAggregationTestCase.randomBoolean();
        BytesRef firstTimeBytes = XContentHelper.toXContent(testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef();
        int rounds = InternalAggregationTestCase.scaledRandomIntBetween(300, 5000);
        this.concurrentTest(() -> InternalAggregationTestCase.lambda$testConcurrentToXContent$57(rounds, firstTimeBytes, testInstance, xContentType, (ToXContent.Params)params, humanReadable));
    }

    protected <P extends ParsedAggregation> P parseAndAssert(InternalAggregation aggregation, boolean shuffled, boolean addRandomFields) throws IOException {
        BytesReference mutated;
        BytesReference originalBytes;
        ToXContent.MapParams params = new ToXContent.MapParams(Collections.singletonMap("typed_keys", "true"));
        XContentType xContentType = InternalAggregationTestCase.randomFrom(XContentType.values());
        boolean humanReadable = InternalAggregationTestCase.randomBoolean();
        try {
            originalBytes = shuffled ? this.toShuffledXContent((ToXContent)aggregation, xContentType, (ToXContent.Params)params, humanReadable, new String[0]) : XContentHelper.toXContent((ToXContent)aggregation, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
        }
        catch (IOException e) {
            throw new IOException("error converting " + aggregation, e);
        }
        if (addRandomFields) {
            Predicate<String> basicExcludes = path -> path.isEmpty() || path.endsWith(Aggregation.CommonFields.META.getPreferredName()) || path.endsWith(Aggregation.CommonFields.BUCKETS.getPreferredName()) || path.contains("top_hits");
            Predicate<String> excludes = basicExcludes.or(this.excludePathsFromXContentInsertion());
            mutated = XContentTestUtils.insertRandomFields(xContentType, originalBytes, excludes, InternalAggregationTestCase.random());
        } else {
            mutated = originalBytes;
        }
        SetOnce parsedAggregation = new SetOnce();
        try (XContentParser parser = this.createParser(xContentType.xContent(), mutated);){
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.FIELD_NAME, (Object)parser.nextToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
            XContentParserUtils.parseTypedKeysObject((XContentParser)parser, (String)"#", Aggregation.class, arg_0 -> ((SetOnce)parsedAggregation).set(arg_0));
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.END_OBJECT, (Object)parser.currentToken());
            InternalAggregationTestCase.assertEquals((Object)XContentParser.Token.END_OBJECT, (Object)parser.nextToken());
            InternalAggregationTestCase.assertNull((Object)parser.nextToken());
            Aggregation agg = (Aggregation)parsedAggregation.get();
            InternalAggregationTestCase.assertEquals((Object)aggregation.getName(), (Object)agg.getName());
            InternalAggregationTestCase.assertEquals((Object)aggregation.getMetadata(), (Object)agg.getMetadata());
            InternalAggregationTestCase.assertTrue((boolean)(agg instanceof ParsedAggregation));
            InternalAggregationTestCase.assertEquals((Object)aggregation.getType(), (Object)agg.getType());
            BytesReference parsedBytes = XContentHelper.toXContent((ToXContent)agg, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
            ElasticsearchAssertions.assertToXContentEquivalent(originalBytes, parsedBytes, xContentType);
            ParsedAggregation parsedAggregation2 = (ParsedAggregation)agg;
            return (P)parsedAggregation2;
        }
    }

    protected Predicate<String> excludePathsFromXContentInsertion() {
        return path -> false;
    }

    public static DocValueFormat randomNumericDocValueFormat() {
        ArrayList<Supplier<DocValueFormat>> formats = new ArrayList<Supplier<DocValueFormat>>(3);
        formats.add(() -> DocValueFormat.RAW);
        formats.add(() -> new DocValueFormat.Decimal(InternalAggregationTestCase.randomFrom("###.##", "###,###.##")));
        return (DocValueFormat)((Supplier)InternalAggregationTestCase.randomFrom(formats)).get();
    }

    public static DocValueFormat randomDateDocValueFormat() {
        DocValueFormat.DateTime format = new DocValueFormat.DateTime(DateFormatter.forPattern((String)InternalAggregationTestCase.randomDateFormatterPattern()), InternalAggregationTestCase.randomZone(), InternalAggregationTestCase.randomFrom(DateFieldMapper.Resolution.values()));
        if (InternalAggregationTestCase.randomBoolean()) {
            return DocValueFormat.enableFormatSortValues((DocValueFormat)format);
        }
        return format;
    }

    public static void assertMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(InternalMultiBucketAggregation.countInnerBucket((Aggregation)agg), bucketConsumer);
    }

    private static void assertMultiBucketConsumer(int innerBucketCount, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertThat((Object)bucketConsumer.getCount(), (Matcher)Matchers.equalTo((Object)innerBucketCount));
    }

    private static /* synthetic */ void lambda$testConcurrentToXContent$57(int rounds, BytesRef firstTimeBytes, InternalAggregation testInstance, XContentType xContentType, ToXContent.Params params, boolean humanReadable) {
        try {
            for (int r = 0; r < rounds; ++r) {
                InternalAggregationTestCase.assertEquals((Object)firstTimeBytes, (Object)XContentHelper.toXContent((ToXContent)testInstance, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable).toBytesRef());
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("median_absolute_deviation", (p, c) -> ParsedMedianAbsoluteDeviation.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("weighted_avg", (p, c) -> ParsedWeightedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("auto_date_histogram", (p, c) -> ParsedAutoDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("variable_width_histogram", (p, c) -> ParsedVariableWidthHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lrareterms", (p, c) -> ParsedLongRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("srareterms", (p, c) -> ParsedStringRareTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geotile_grid", (p, c) -> ParsedGeoTileGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        namedXContents = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
    }
}

