/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.yaml.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractCCSRestTestCase
extends ESRestTestCase {
    protected static List<Node> getNodes(RestClient restClient) throws IOException {
        Response response = restClient.performRequest(new Request("GET", "_nodes"));
        ObjectPath objectPath = ObjectPath.createFromResponse(response);
        Map nodeMap = (Map)objectPath.evaluate("nodes");
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String id : nodeMap.keySet()) {
            String name = (String)objectPath.evaluate("nodes." + id + ".name");
            Version version = Version.fromString((String)((String)objectPath.evaluate("nodes." + id + ".version")));
            String transportAddress = (String)objectPath.evaluate("nodes." + id + ".transport.publish_address");
            String httpAddress = (String)objectPath.evaluate("nodes." + id + ".http.publish_address");
            Map attributes = (Map)objectPath.evaluate("nodes." + id + ".attributes");
            nodes.add(new Node(id, name, version, transportAddress, httpAddress, attributes));
        }
        return nodes;
    }

    protected static List<HttpHost> parseHosts(String props) {
        String address = System.getProperty(props);
        AbstractCCSRestTestCase.assertNotNull((String)("[" + props + "] is not configured"), (Object)address);
        String[] stringUrls = address.split(",");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
        for (String stringUrl : stringUrls) {
            int portSeparator = stringUrl.lastIndexOf(58);
            if (portSeparator < 0) {
                throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
            }
            String host = stringUrl.substring(0, portSeparator);
            int port = Integer.parseInt(stringUrl.substring(portSeparator + 1));
            hosts.add(new HttpHost(host, port, "http"));
        }
        AbstractCCSRestTestCase.assertThat((String)("[" + props + "] is empty"), hosts, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        return hosts;
    }

    private static RestClient createLocalClient(Logger logger) {
        List<HttpHost> hosts = AbstractCCSRestTestCase.parseHosts("tests.rest.cluster");
        int index = AbstractCCSRestTestCase.random().nextInt(hosts.size());
        logger.info("Using client node {}", (Object)index);
        return RestClient.builder((HttpHost[])new HttpHost[]{hosts.get(index)}).build();
    }

    public static void configureRemoteClusters(List<Node> remoteNodes, String remoteClusterAlias, Version upgradeFromVersion, Logger logger) throws Exception {
        String remoteClusterSettingPrefix = "cluster.remote." + remoteClusterAlias + ".";
        try (RestClient localClient = AbstractCCSRestTestCase.createLocalClient(logger);){
            Settings remoteConnectionSettings;
            if (upgradeFromVersion.before(Version.V_7_6_0) || AbstractCCSRestTestCase.randomBoolean()) {
                List seeds = remoteNodes.stream().filter(n -> n.attributes.containsKey("gateway")).map(n -> n.transportAddress).collect(Collectors.toList());
                logger.info("--> use sniff mode with seed [{}], remote nodes [{}]", seeds, remoteNodes);
                remoteConnectionSettings = upgradeFromVersion.before(Version.V_7_6_0) ? Settings.builder().putList(remoteClusterSettingPrefix + "seeds", seeds).build() : Settings.builder().putNull(remoteClusterSettingPrefix + "proxy_address").put(remoteClusterSettingPrefix + "mode", "sniff").putList(remoteClusterSettingPrefix + "seeds", seeds).build();
            } else {
                Node proxyNode = AbstractCCSRestTestCase.randomFrom(remoteNodes);
                logger.info("--> use proxy node [{}], remote nodes [{}]", (Object)proxyNode, remoteNodes);
                remoteConnectionSettings = Settings.builder().putNull(remoteClusterSettingPrefix + "seeds").put(remoteClusterSettingPrefix + "mode", "proxy").put(remoteClusterSettingPrefix + "proxy_address", proxyNode.transportAddress).build();
            }
            ClusterUpdateSettingsRequest settingsRequest = new ClusterUpdateSettingsRequest().persistentSettings(remoteConnectionSettings);
            AbstractCCSRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                Request request = new Request("PUT", "/_cluster/settings");
                request.setJsonEntity(Strings.toString((ToXContent)settingsRequest));
                Response resp = localClient.performRequest(request);
                AbstractCCSRestTestCase.assertOK(resp);
            }), 60L, TimeUnit.SECONDS);
            AbstractCCSRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                Response resp = localClient.performRequest(new Request("GET", "/_remote/info"));
                AbstractCCSRestTestCase.assertOK(resp);
                ObjectPath objectPath = ObjectPath.createFromResponse(resp);
                AbstractCCSRestTestCase.assertNotNull(objectPath.evaluate(remoteClusterAlias));
                AbstractCCSRestTestCase.assertTrue((boolean)((Boolean)objectPath.evaluate(remoteClusterAlias + ".connected")));
            }), 60L, TimeUnit.SECONDS);
        }
    }

    protected static class Node {
        public final String id;
        public final String name;
        public final Version version;
        public final String transportAddress;
        public final String httpAddress;
        public final Map<String, Object> attributes;

        Node(String id, String name, Version version, String transportAddress, String httpAddress, Map<String, Object> attributes) {
            this.id = id;
            this.name = name;
            this.version = version;
            this.transportAddress = transportAddress;
            this.httpAddress = httpAddress;
            this.attributes = attributes;
        }

        public String toString() {
            return "Node{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", version=" + this.version + ", transportAddress='" + this.transportAddress + '\'' + ", httpAddress='" + this.httpAddress + '\'' + ", attributes=" + this.attributes + '}';
        }
    }
}

