/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.HttpHost;
import org.elasticsearch.Version;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.test.ClasspathUtils;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.yaml.BlacklistedPathPatternMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestCandidate;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSuite;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

@TimeoutSuite(millis=1800000)
public abstract class ESClientYamlSuiteTestCase
extends ESRestTestCase {
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_BLACKLIST = "tests.rest.blacklist";
    public static final String REST_TESTS_BLACKLIST_ADDITIONS = "tests.rest.blacklist_additions";
    private static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    private static final String TESTS_PATH = "rest-api-spec/test";
    private static final String SPEC_PATH = "rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private static List<BlacklistedPathPatternMatcher> blacklistPathMatchers;
    private static ClientYamlTestExecutionContext restTestExecutionContext;
    private static ClientYamlTestExecutionContext adminExecutionContext;
    private static ClientYamlTestClient clientYamlTestClient;
    private final ClientYamlTestCandidate testCandidate;
    private static boolean useDefaultNumberOfShards;

    protected ESClientYamlSuiteTestCase(ClientYamlTestCandidate testCandidate) {
        this.testCandidate = testCandidate;
    }

    @BeforeClass
    public static void initializeUseDefaultNumberOfShards() {
        useDefaultNumberOfShards = ESClientYamlSuiteTestCase.usually();
    }

    @Before
    public void initAndResetContext() throws Exception {
        if (restTestExecutionContext == null) {
            String[] blacklistAdditions;
            assert (adminExecutionContext == null);
            assert (blacklistPathMatchers == null);
            ClientYamlSuiteRestSpec restSpec = ClientYamlSuiteRestSpec.load(SPEC_PATH);
            ESClientYamlSuiteTestCase.validateSpec(restSpec);
            List<HttpHost> hosts = this.getClusterHosts();
            Tuple<Version, Version> versionVersionTuple = this.readVersionsFromCatNodes(ESClientYamlSuiteTestCase.adminClient());
            Version esVersion = this.overwriteEsVersion((Version)versionVersionTuple.v1());
            Version masterVersion = (Version)versionVersionTuple.v2();
            String os = this.readOsFromNodesInfo(ESClientYamlSuiteTestCase.adminClient());
            this.logger.info("initializing client, minimum es version [{}], master version, [{}], hosts {}, os [{}]", (Object)esVersion, (Object)masterVersion, hosts, (Object)os);
            clientYamlTestClient = this.initClientYamlTestClient(restSpec, ESClientYamlSuiteTestCase.client(), hosts, esVersion, masterVersion, os);
            restTestExecutionContext = new ClientYamlTestExecutionContext(this.testCandidate, clientYamlTestClient, this.randomizeContentType());
            adminExecutionContext = new ClientYamlTestExecutionContext(this.testCandidate, clientYamlTestClient, false);
            String[] blacklist = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST, null);
            blacklistPathMatchers = new ArrayList<BlacklistedPathPatternMatcher>();
            for (String entry : blacklist) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
            for (String entry : blacklistAdditions = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST_ADDITIONS, null)) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
        }
        assert (restTestExecutionContext != null);
        assert (adminExecutionContext != null);
        assert (blacklistPathMatchers != null);
        adminExecutionContext.clear();
        restTestExecutionContext.clear();
    }

    protected Version overwriteEsVersion(Version esVersionFromApi) {
        return esVersionFromApi;
    }

    protected ClientYamlTestClient initClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Version masterVersion, String os) {
        return new ClientYamlTestClient(restSpec, restClient, hosts, esVersion, masterVersion, os, (CheckedSupplier<RestClientBuilder, IOException>)((CheckedSupplier)this::getClientBuilderWithSniffedHosts));
    }

    @AfterClass
    public static void closeClient() throws IOException {
        try {
            IOUtils.close((Closeable)clientYamlTestClient);
        }
        finally {
            blacklistPathMatchers = null;
            restTestExecutionContext = null;
            adminExecutionContext = null;
            clientYamlTestClient = null;
        }
    }

    public static Iterable<Object[]> createParameters() throws Exception {
        return ESClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY);
    }

    public static Iterable<Object[]> createParameters(NamedXContentRegistry executeableSectionRegistry) throws Exception {
        String[] paths = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, "");
        Map<String, Set<Path>> yamlSuites = ESClientYamlSuiteTestCase.loadSuites(paths);
        ArrayList<ClientYamlTestSuite> suites = new ArrayList<ClientYamlTestSuite>();
        Throwable validationException = null;
        for (String api : yamlSuites.keySet()) {
            ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
            for (Path yamlFile : yamlFiles) {
                ClientYamlTestSuite suite = ClientYamlTestSuite.parse(executeableSectionRegistry, api, yamlFile);
                suites.add(suite);
                try {
                    suite.validate();
                }
                catch (IllegalArgumentException e) {
                    if (validationException == null) {
                        validationException = new IllegalArgumentException("Validation errors for the following test suites:\n- " + e.getMessage());
                    } else {
                        String previousMessage = validationException.getMessage();
                        Throwable[] suppressed = validationException.getSuppressed();
                        validationException = new IllegalArgumentException(previousMessage + "\n- " + e.getMessage());
                        for (Throwable t : suppressed) {
                            validationException.addSuppressed(t);
                        }
                    }
                    validationException.addSuppressed(e);
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (ClientYamlTestSuite yamlTestSuite : suites) {
            for (ClientYamlTestSection testSection : yamlTestSuite.getTestSections()) {
                tests.add(new Object[]{new ClientYamlTestCandidate(yamlTestSuite, testSection)});
            }
        }
        tests.sort(Comparator.comparing(o -> ((ClientYamlTestCandidate)o[0]).getTestPath()));
        return tests;
    }

    static Map<String, Set<Path>> loadSuites(String ... paths) throws Exception {
        Path[] roots;
        HashMap<String, Set<Path>> files = new HashMap<String, Set<Path>>();
        for (Path root : roots = ClasspathUtils.findFilePaths(ESClientYamlSuiteTestCase.class.getClassLoader(), TESTS_PATH)) {
            for (String strPath : paths) {
                Path path = root.resolve(strPath);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.walk(path, new FileVisitOption[0]).forEach(file -> {
                        if (file.toString().endsWith(".yml")) {
                            ESClientYamlSuiteTestCase.addSuite(root, file, files);
                        } else if (file.toString().endsWith(".yaml")) {
                            throw new IllegalArgumentException("yaml files are no longer supported: " + file);
                        }
                    });
                    continue;
                }
                path = root.resolve(strPath + ".yml");
                assert (Files.exists(path, new LinkOption[0]));
                ESClientYamlSuiteTestCase.addSuite(root, path, files);
            }
        }
        return files;
    }

    private static void addSuite(Path root, Path file, Map<String, Set<Path>> files) {
        String groupName = root.relativize(file.getParent()).toString();
        Set<Path> filesSet = files.get(groupName);
        if (filesSet == null) {
            filesSet = new HashSet<Path>();
            files.put(groupName, filesSet);
        }
        filesSet.add(file);
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    protected ClientYamlTestExecutionContext getAdminExecutionContext() {
        return adminExecutionContext;
    }

    private static void validateSpec(ClientYamlSuiteRestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (ClientYamlSuiteRestApi restApi : restSpec.getApis()) {
                if (!restApi.isBodySupported()) continue;
                for (ClientYamlSuiteRestApi.Path path : restApi.getPaths()) {
                    List<String> methodsList = Arrays.asList(path.getMethods());
                    if (!methodsList.contains("GET") || !restApi.isBodySupported() || methodsList.contains("POST")) continue;
                    errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
                }
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    private Tuple<Version, Version> readVersionsFromCatNodes(RestClient restClient) throws IOException {
        Request request = new Request("GET", "/_cat/nodes");
        request.addParameter("h", "version,master");
        request.setOptions(this.getCatNodesVersionMasterRequestOptions());
        Response response = restClient.performRequest(request);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response);
        String nodesCatResponse = restTestResponse.getBodyAsString();
        String[] split = nodesCatResponse.split("\n");
        Version version = null;
        Version masterVersion = null;
        for (String perNode : split) {
            String[] versionAndMaster = perNode.split("\\s+");
            assert (versionAndMaster.length == 2) : "invalid line: " + perNode + " length: " + versionAndMaster.length;
            Version currentVersion = Version.fromString((String)versionAndMaster[0]);
            boolean master = versionAndMaster[1].trim().equals("*");
            if (master) {
                assert (masterVersion == null);
                masterVersion = currentVersion;
            }
            if (version == null) {
                version = currentVersion;
                continue;
            }
            if (!version.onOrAfter(currentVersion)) continue;
            version = currentVersion;
        }
        return new Tuple(version, masterVersion);
    }

    private String readOsFromNodesInfo(RestClient restClient) throws IOException {
        Request request = new Request("GET", "/_nodes/os");
        Response response = restClient.performRequest(request);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response);
        TreeSet<String> osPrettyNames = new TreeSet<String>();
        Map nodes = (Map)restTestResponse.evaluate("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            osPrettyNames.add((String)XContentMapValues.extractValue((String)"os.pretty_name", (Map)nodeInfo));
        }
        assert (!osPrettyNames.isEmpty()) : "no os found";
        return (String)osPrettyNames.last();
    }

    protected RequestOptions getCatNodesVersionMasterRequestOptions() {
        return RequestOptions.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws IOException {
        for (BlacklistedPathPatternMatcher blacklistedPathMatcher : blacklistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: blacklisted"), (boolean)blacklistedPathMatcher.isSuffixMatch(testPath));
        }
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getSetupSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getSetupSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTeardownSection().getSkipSection().getSkipMessage(this.testCandidate.getSuitePath()), (boolean)this.testCandidate.getTeardownSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTestSection().getSkipSection().getSkipMessage(this.testCandidate.getTestPath()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.esVersion()));
        ESClientYamlSuiteTestCase.assumeFalse((String)this.testCandidate.getTestSection().getSkipSection().getSkipMessage(this.testCandidate.getTestPath()), (boolean)this.testCandidate.getTestSection().getSkipSection().skip(restTestExecutionContext.os()));
        if (this.testCandidate.getTestSection().getExecutableSections().size() == 0) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        if (!useDefaultNumberOfShards && !this.testCandidate.getTestSection().getSkipSection().getFeatures().contains("default_shards")) {
            Request request = new Request("PUT", "/_template/global");
            request.setJsonEntity("{\"index_patterns\":[\"*\"],\"settings\":{\"index.number_of_shards\":2}}");
            RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
            builder.setWarningsHandler(WarningsHandler.PERMISSIVE);
            request.setOptions(builder.build());
            ESClientYamlSuiteTestCase.adminClient().performRequest(request);
        }
        ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: in fips 140 mode"), (ESClientYamlSuiteTestCase.inFipsJvm() && this.testCandidate.getTestSection().getSkipSection().getFeatures().contains("fips_140") ? 1 : 0) != 0);
        if (!this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.debug("start setup test [{}]", (Object)this.testCandidate.getTestPath());
            for (ExecutableSection executableSection : this.testCandidate.getSetupSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
            this.logger.debug("end setup test [{}]", (Object)this.testCandidate.getTestPath());
        }
        restTestExecutionContext.clear();
        try {
            for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
        }
        catch (Throwable throwable) {
            this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
            for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
                this.executeSection(doSection);
            }
            this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
            throw throwable;
        }
        this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
        for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
            this.executeSection(doSection);
        }
        this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
    }

    private void executeSection(ExecutableSection executableSection) {
        try {
            executableSection.execute(restTestExecutionContext);
        }
        catch (AssertionError | Exception e) {
            this.logger.info("Stash dump on test failure [{}]", (Object)Strings.toString((ToXContent)restTestExecutionContext.stash(), (boolean)true, (boolean)true).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t"));
            if (e instanceof AssertionError) {
                throw new AssertionError(this.errorMessage(executableSection, (Throwable)e), (Throwable)e);
            }
            throw new RuntimeException(this.errorMessage(executableSection, (Throwable)e), (Throwable)e);
        }
    }

    private String errorMessage(ExecutableSection executableSection, Throwable t) {
        return "Failure at [" + this.testCandidate.getSuitePath() + ":" + executableSection.getLocation().lineNumber + "]: " + t.getMessage();
    }

    protected boolean randomizeContentType() {
        return true;
    }

    protected final RestClientBuilder getClientBuilderWithSniffedHosts() throws IOException {
        ElasticsearchNodesSniffer.Scheme scheme = ElasticsearchNodesSniffer.Scheme.valueOf((String)this.getProtocol().toUpperCase(Locale.ROOT));
        ElasticsearchNodesSniffer sniffer = new ElasticsearchNodesSniffer(ESClientYamlSuiteTestCase.adminClient(), ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
        RestClientBuilder builder = RestClient.builder((Node[])sniffer.sniff().toArray(new Node[0]));
        ESClientYamlSuiteTestCase.configureClient(builder, this.restClientSettings());
        return builder;
    }
}

