/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LengthAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(LengthAssertion.class);

    public static LengthAssertion parse(XContentParser parser) throws IOException {
        int value;
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        assert (stringObjectTuple.v2() != null);
        if (stringObjectTuple.v2() instanceof Number) {
            value = ((Number)stringObjectTuple.v2()).intValue();
        } else {
            try {
                value = Integer.valueOf(stringObjectTuple.v2().toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("length is not a valid number", e);
            }
        }
        return new LengthAssertion(location, (String)stringObjectTuple.v1(), value);
    }

    public LengthAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        logger.trace("assert that [{}] has length [{}] (field: [{}])", actualValue, expectedValue, (Object)this.getField());
        Assert.assertThat((String)("expected value of [" + this.getField() + "] is not numeric (got [" + expectedValue.getClass() + "]"), (Object)expectedValue, (Matcher)Matchers.instanceOf(Number.class));
        int length = ((Number)expectedValue).intValue();
        if (actualValue instanceof String) {
            Assert.assertThat((String)this.errorMessage(), (Object)((String)actualValue).length(), (Matcher)Matchers.equalTo((Object)length));
        } else if (actualValue instanceof List) {
            Assert.assertThat((String)this.errorMessage(), (Object)((List)actualValue).size(), (Matcher)Matchers.equalTo((Object)length));
        } else if (actualValue instanceof Map) {
            Assert.assertThat((String)this.errorMessage(), (Object)((Map)actualValue).keySet().size(), (Matcher)Matchers.equalTo((Object)length));
        } else {
            throw new UnsupportedOperationException("value is of unsupported type [" + this.safeClass(actualValue) + "]");
        }
    }

    private String errorMessage() {
        return "field [" + this.getField() + "] doesn't have length [" + this.getExpectedValue() + "]";
    }
}

