/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public class TransformAndSetSection
implements ExecutableSection {
    private final Map<String, String> transformStash = new HashMap<String, String>();
    private final XContentLocation location;

    public static TransformAndSetSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        TransformAndSetSection transformAndStashSection = new TransformAndSetSection(parser.getTokenLocation());
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            transformAndStashSection.addSet(currentFieldName, parser.text());
        }
        parser.nextToken();
        if (transformAndStashSection.getStash().isEmpty()) {
            throw new ParsingException(transformAndStashSection.location, "transform_and_set section must set at least a value", new Object[0]);
        }
        return transformAndStashSection;
    }

    public TransformAndSetSection(XContentLocation location) {
        this.location = location;
    }

    public void addSet(String stashedField, String transformThis) {
        this.transformStash.put(stashedField, transformThis);
    }

    public Map<String, String> getStash() {
        return this.transformStash;
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        for (Map.Entry<String, String> entry : this.transformStash.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.startsWith("#base64EncodeCredentials(") && value.endsWith(")")) {
                value = entry.getValue().substring("#base64EncodeCredentials(".length(), entry.getValue().lastIndexOf(")"));
                String[] idAndPassword = value.split(",");
                if (idAndPassword.length == 2) {
                    String credentials = executionContext.response(idAndPassword[0].trim()) + ":" + executionContext.response(idAndPassword[1].trim());
                    value = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
                } else {
                    throw new IllegalArgumentException("base64EncodeCredentials requires a username/id and a password parameters");
                }
            }
            executionContext.stash().stashValue(key, value);
        }
    }
}

