/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(category="Converter", name="TestInfoPatternConverter")
@ConverterKeys(value={"test_thread_info"})
public class TestThreadInfoPatternConverter
extends LogEventPatternConverter {
    private static final Pattern ELASTICSEARCH_THREAD_NAME_PATTERN = Pattern.compile("elasticsearch\\[(.+)\\]\\[.+\\].+");
    private static final Pattern TEST_THREAD_NAME_PATTERN = Pattern.compile("TEST-.+\\.(.+)-seed#\\[.+\\]");
    private static final Pattern TEST_SUITE_INIT_THREAD_NAME_PATTERN = Pattern.compile("SUITE-.+-worker");
    private static final Pattern NOT_YET_NAMED_NODE_THREAD_NAME_PATTERN = Pattern.compile("test_SUITE-CHILD_VM.+cluster\\[T#(.+)\\]");

    public static TestThreadInfoPatternConverter newInstance(String[] options) {
        if (options.length > 0) {
            throw new IllegalArgumentException("no options supported but options provided: " + Arrays.toString(options));
        }
        return new TestThreadInfoPatternConverter();
    }

    private TestThreadInfoPatternConverter() {
        super("TestInfo", "test_thread_info");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        toAppendTo.append(TestThreadInfoPatternConverter.threadInfo(event.getThreadName()));
        if (!event.getContextData().isEmpty()) {
            toAppendTo.append(event.getContextData());
        }
    }

    static String threadInfo(String threadName) {
        Matcher m = ELASTICSEARCH_THREAD_NAME_PATTERN.matcher(threadName);
        if (m.matches()) {
            return m.group(1);
        }
        m = TEST_THREAD_NAME_PATTERN.matcher(threadName);
        if (m.matches()) {
            return m.group(1);
        }
        m = TEST_SUITE_INIT_THREAD_NAME_PATTERN.matcher(threadName);
        if (m.matches()) {
            return "suite";
        }
        m = NOT_YET_NAMED_NODE_THREAD_NAME_PATTERN.matcher(threadName);
        if (m.matches()) {
            return "integ_" + m.group(1) + "";
        }
        return "[" + threadName + "]";
    }
}

