/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.List;
import java.util.concurrent.Executor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;

public class AsyncRecoveryTarget
implements RecoveryTargetHandler {
    private final RecoveryTargetHandler target;
    private final Executor executor;

    public AsyncRecoveryTarget(RecoveryTargetHandler target, Executor executor) {
        this.executor = executor;
        this.target = target;
    }

    public void prepareForTranslogOperations(boolean fileBasedRecovery, int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.prepareForTranslogOperations(fileBasedRecovery, totalTranslogOps, listener));
    }

    public void finalizeRecovery(long globalCheckpoint, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.finalizeRecovery(globalCheckpoint, listener));
    }

    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext) {
        this.target.handoffPrimaryContext(primaryContext);
    }

    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        this.executor.execute(() -> this.target.indexTranslogOperations(operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary, listener));
    }

    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.receiveFileInfo(phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps, listener));
    }

    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetaData, ActionListener<Void> listener) {
        this.executor.execute(() -> this.target.cleanFiles(totalTranslogOps, globalCheckpoint, sourceMetaData, listener));
    }

    public void writeFileChunk(StoreFileMetaData fileMetaData, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        BytesArray copy = new BytesArray(BytesRef.deepCopyOf((BytesRef)content.toBytesRef()));
        this.executor.execute(() -> this.lambda$writeFileChunk$5(fileMetaData, position, (BytesReference)copy, lastChunk, totalTranslogOps, listener));
    }

    private /* synthetic */ void lambda$writeFileChunk$5(StoreFileMetaData fileMetaData, long position, BytesReference copy, boolean lastChunk, int totalTranslogOps, ActionListener listener) {
        this.target.writeFileChunk(fileMetaData, position, copy, lastChunk, totalTranslogOps, listener);
    }
}

