/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.support.PlainBlobMetaData;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESSingleNodeTestCase;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class AbstractThirdPartyRepositoryTestCase
extends ESSingleNodeTestCase {
    @Override
    protected Settings nodeSettings() {
        return Settings.builder().put(super.nodeSettings()).setSecureSettings(this.credentials()).build();
    }

    protected abstract SecureSettings credentials();

    protected abstract void createRepository(String var1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRepository("test-repo");
        final BlobStoreRepository repo = this.getRepository();
        final PlainActionFuture future = PlainActionFuture.newFuture();
        repo.threadPool().generic().execute((Runnable)new ActionRunnable<Void>((ActionListener)future){

            protected void doRun() throws Exception {
                AbstractThirdPartyRepositoryTestCase.deleteContents(repo.blobStore().blobContainer(repo.basePath()));
                future.onResponse(null);
            }
        });
        future.actionGet();
        this.assertChildren(repo.basePath(), Collections.emptyList());
    }

    private static void deleteContents(BlobContainer container) throws IOException {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry child : container.children().entrySet()) {
            AbstractThirdPartyRepositoryTestCase.deleteContents((BlobContainer)child.getValue());
            toDelete.add((String)child.getKey());
        }
        toDelete.addAll(container.listBlobs().keySet());
        container.deleteBlobsIgnoringIfNotExists(toDelete);
    }

    public void testCreateSnapshot() {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1", "doc", Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-2", "doc", Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-3", "doc", Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.client().admin().cluster().prepareCreateSnapshot("test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)this.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((AcknowledgedResponse)this.client().admin().cluster().prepareDeleteSnapshot("test-repo", snapshotName).get()).isAcknowledged());
    }

    public void testListChildren() throws Exception {
        final BlobStoreRepository repo = this.getRepository();
        final PlainActionFuture future = PlainActionFuture.newFuture();
        ExecutorService genericExec = repo.threadPool().generic();
        final int testBlobLen = AbstractThirdPartyRepositoryTestCase.randomIntBetween(1, 100);
        genericExec.execute((Runnable)new ActionRunnable<Void>((ActionListener)future){

            protected void doRun() throws Exception {
                BlobStore blobStore = repo.blobStore();
                blobStore.blobContainer(repo.basePath().add("foo")).writeBlob("nested-blob", (InputStream)new ByteArrayInputStream(ESTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
                blobStore.blobContainer(repo.basePath().add("foo").add("nested")).writeBlob("bar", (InputStream)new ByteArrayInputStream(ESTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
                blobStore.blobContainer(repo.basePath().add("foo").add("nested2")).writeBlob("blub", (InputStream)new ByteArrayInputStream(ESTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
                future.onResponse(null);
            }
        });
        future.actionGet();
        this.assertChildren(repo.basePath(), Collections.singleton("foo"));
        this.assertBlobsByPrefix(repo.basePath(), "fo", Collections.emptyMap());
        this.assertChildren(repo.basePath().add("foo"), Arrays.asList("nested", "nested2"));
        this.assertBlobsByPrefix(repo.basePath().add("foo"), "nest", Collections.singletonMap("nested-blob", new PlainBlobMetaData("nested-blob", (long)testBlobLen)));
        this.assertChildren(repo.basePath().add("foo").add("nested"), Collections.emptyList());
    }

    protected void assertBlobsByPrefix(final BlobPath path, final String prefix, Map<String, BlobMetaData> blobs) throws Exception {
        final PlainActionFuture future = PlainActionFuture.newFuture();
        final BlobStoreRepository repository = this.getRepository();
        repository.threadPool().generic().execute((Runnable)new ActionRunnable<Map<String, BlobMetaData>>((ActionListener)future){

            protected void doRun() throws Exception {
                BlobStore blobStore = repository.blobStore();
                future.onResponse((Object)blobStore.blobContainer(path).listBlobsByPrefix(prefix));
            }
        });
        Map foundBlobs = (Map)future.actionGet();
        if (blobs.isEmpty()) {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundBlobs.keySet(), (Matcher)Matchers.empty());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundBlobs.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])blobs.keySet().toArray(Strings.EMPTY_ARRAY)));
            for (Map.Entry entry : foundBlobs.entrySet()) {
                AbstractThirdPartyRepositoryTestCase.assertEquals((long)((BlobMetaData)entry.getValue()).length(), (long)blobs.get(entry.getKey()).length());
            }
        }
    }

    protected void assertChildren(final BlobPath path, Collection<String> children) throws Exception {
        final PlainActionFuture future = PlainActionFuture.newFuture();
        final BlobStoreRepository repository = this.getRepository();
        repository.threadPool().generic().execute((Runnable)new ActionRunnable<Set<String>>((ActionListener)future){

            protected void doRun() throws Exception {
                BlobStore blobStore = repository.blobStore();
                future.onResponse(blobStore.blobContainer(path).children().keySet());
            }
        });
        Set foundChildren = (Set)future.actionGet();
        if (children.isEmpty()) {
            AbstractThirdPartyRepositoryTestCase.assertThat((Object)foundChildren, (Matcher)Matchers.empty());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat((Object)foundChildren, (Matcher)Matchers.containsInAnyOrder((Object[])children.toArray(Strings.EMPTY_ARRAY)));
        }
    }

    private BlobStoreRepository getRepository() {
        return (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
    }
}

