/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.disruption.SingleNodeDisruption;

public class LongGCDisruption
extends SingleNodeDisruption {
    private static final Pattern[] unsafeClasses = new Pattern[]{Pattern.compile("logging\\.log4j"), Pattern.compile("java\\.lang\\.SecurityManager"), Pattern.compile("java\\.security\\.SecureRandom")};
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    protected final String disruptedNode;
    private Set<Thread> suspendedThreads;
    private Thread blockDetectionThread;

    public LongGCDisruption(Random random, String disruptedNode) {
        super(random);
        this.disruptedNode = disruptedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startDisrupting() {
        if (this.suspendedThreads == null) {
            boolean success = false;
            try {
                this.suspendedThreads = ConcurrentHashMap.newKeySet();
                String currentThreadName = Thread.currentThread().getName();
                assert (!this.isDisruptedNodeThread(currentThreadName)) : "current thread match pattern. thread name: " + currentThreadName + ", node: " + this.disruptedNode;
                final AtomicReference suspendingError = new AtomicReference();
                Thread suspendingThread = new Thread((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        suspendingError.set(e);
                    }

                    protected void doRun() throws Exception {
                        while (LongGCDisruption.this.suspendThreads(LongGCDisruption.this.suspendedThreads)) {
                            if (!Thread.interrupted()) continue;
                            return;
                        }
                    }
                });
                suspendingThread.setName(currentThreadName + "[LongGCDisruption][threadSuspender]");
                suspendingThread.start();
                try {
                    suspendingThread.join(this.getSuspendingTimeoutInMillis());
                }
                catch (InterruptedException e) {
                    suspendingThread.interrupt();
                    throw new RuntimeException(e);
                }
                if (suspendingError.get() != null) {
                    throw new RuntimeException("unknown error while suspending threads", (Throwable)suspendingError.get());
                }
                if (suspendingThread.isAlive()) {
                    this.logger.warn("failed to suspend node [{}]'s threads within [{}] millis. Suspending thread stack trace:\n {}\nThreads that weren't suspended:\n {}", (Object)this.disruptedNode, (Object)this.getSuspendingTimeoutInMillis(), (Object)this.stackTrace(suspendingThread.getStackTrace()), (Object)this.suspendedThreads.stream().map(t -> t.getName() + "\n----\n" + this.stackTrace(t.getStackTrace())).collect(Collectors.joining("\n")));
                    suspendingThread.interrupt();
                    try {
                        suspendingThread.join();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    throw new RuntimeException("suspending node threads took too long");
                }
                if (this.isBlockDetectionSupported()) {
                    this.blockDetectionThread = new Thread((Runnable)new AbstractRunnable(){

                        public void onFailure(Exception e) {
                            if (!(e instanceof InterruptedException)) {
                                throw new AssertionError("unexpected exception in blockDetectionThread", e);
                            }
                        }

                        protected void doRun() throws Exception {
                            while (!Thread.currentThread().isInterrupted()) {
                                ThreadInfo[] threadInfos;
                                for (ThreadInfo threadInfo : threadInfos = threadBean.dumpAllThreads(true, true)) {
                                    if (LongGCDisruption.this.isDisruptedNodeThread(threadInfo.getThreadName()) || threadInfo.getLockOwnerName() == null || !LongGCDisruption.this.isDisruptedNodeThread(threadInfo.getLockOwnerName())) continue;
                                    ThreadInfo blockingThreadInfo = null;
                                    for (ThreadInfo otherThreadInfo : threadInfos) {
                                        if (otherThreadInfo.getThreadId() != threadInfo.getLockOwnerId()) continue;
                                        blockingThreadInfo = otherThreadInfo;
                                        break;
                                    }
                                    LongGCDisruption.this.onBlockDetected(threadInfo, blockingThreadInfo);
                                }
                                Thread.sleep(LongGCDisruption.this.getBlockDetectionIntervalInMillis());
                            }
                        }
                    });
                    this.blockDetectionThread.setName(currentThreadName + "[LongGCDisruption][blockDetection]");
                    this.blockDetectionThread.start();
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.stopBlockDetection();
                    this.resumeThreads(this.suspendedThreads);
                    this.suspendedThreads = null;
                }
            }
        }
        throw new IllegalStateException("can't disrupt twice, call stopDisrupting() first");
    }

    public boolean isDisruptedNodeThread(String threadName) {
        return threadName.contains("[" + this.disruptedNode + "]");
    }

    private String stackTrace(StackTraceElement[] stackTraceElements) {
        return Arrays.stream(stackTraceElements).map(Object::toString).collect(Collectors.joining("\n"));
    }

    @Override
    public synchronized void stopDisrupting() {
        this.stopBlockDetection();
        if (this.suspendedThreads != null) {
            this.resumeThreads(this.suspendedThreads);
            this.suspendedThreads = null;
        }
    }

    private void stopBlockDetection() {
        if (this.blockDetectionThread != null) {
            try {
                this.blockDetectionThread.interrupt();
                this.blockDetectionThread.join(this.getSuspendingTimeoutInMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.blockDetectionThread = null;
        }
    }

    @Override
    public void removeAndEnsureHealthy(InternalTestCluster cluster) {
        this.removeFromCluster(cluster);
        this.ensureNodeCount(cluster);
    }

    @Override
    public TimeValue expectedTimeToHeal() {
        return TimeValue.timeValueMillis((long)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="suspends/resumes threads intentionally")
    protected boolean suspendThreads(Set<Thread> nodeThreads) {
        Thread[] allThreads = null;
        while (allThreads == null) {
            allThreads = new Thread[Thread.activeCount()];
            if (Thread.enumerate(allThreads) <= allThreads.length) continue;
            allThreads = null;
        }
        boolean liveThreadsFound = false;
        for (Thread thread : allThreads) {
            String threadName;
            if (thread == null || !this.isDisruptedNodeThread(threadName = thread.getName()) || !thread.isAlive() || !nodeThreads.add(thread)) continue;
            liveThreadsFound = true;
            this.logger.trace("suspending thread [{}]", (Object)threadName);
            boolean safe = false;
            try {
                boolean definitelySafe = true;
                thread.suspend();
                block5: for (StackTraceElement stackElement : thread.getStackTrace()) {
                    String className = stackElement.getClassName();
                    for (Pattern unsafePattern : this.getUnsafeClasses()) {
                        if (!unsafePattern.matcher(className).find()) continue;
                        definitelySafe = false;
                        break block5;
                    }
                }
                safe = definitelySafe;
            }
            finally {
                if (!safe) {
                    thread.resume();
                    this.logger.trace("resumed thread [{}] as it is in a critical section", (Object)threadName);
                    nodeThreads.remove(thread);
                }
            }
        }
        return liveThreadsFound;
    }

    protected Pattern[] getUnsafeClasses() {
        return unsafeClasses;
    }

    protected long getSuspendingTimeoutInMillis() {
        return TimeValue.timeValueSeconds((long)30L).getMillis();
    }

    public boolean isBlockDetectionSupported() {
        return threadBean.isObjectMonitorUsageSupported() && threadBean.isSynchronizerUsageSupported();
    }

    protected long getBlockDetectionIntervalInMillis() {
        return 3000L;
    }

    protected void onBlockDetected(ThreadInfo blockedThread, @Nullable ThreadInfo blockingThread) {
        String blockedThreadStackTrace = this.stackTrace(blockedThread.getStackTrace());
        String blockingThreadStackTrace = blockingThread != null ? this.stackTrace(blockingThread.getStackTrace()) : "not available";
        throw new AssertionError((Object)("Thread [" + blockedThread.getThreadName() + "] is blocked waiting on the resource [" + blockedThread.getLockInfo() + "] held by the suspended thread [" + blockedThread.getLockOwnerName() + "] of the disrupted node [" + this.disruptedNode + "].\nPlease add this occurrence to the unsafeClasses list in [" + LongGCDisruption.class.getName() + "].\nStack trace of blocked thread: " + blockedThreadStackTrace + "\nStack trace of blocking thread: " + blockingThreadStackTrace));
    }

    @SuppressForbidden(reason="suspends/resumes threads intentionally")
    protected void resumeThreads(Set<Thread> threads) {
        for (Thread thread : threads) {
            thread.resume();
        }
    }
}

