/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class OptionalMatchers {
    public static IsEmptyMatcher isEmpty() {
        return new IsEmptyMatcher();
    }

    public static IsPresentMatcher isPresent() {
        return new IsPresentMatcher();
    }

    private static class IsPresentMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private IsPresentMatcher() {
        }

        protected boolean matchesSafely(Optional<?> item) {
            return item != null && item.isPresent();
        }

        public void describeTo(Description description) {
            description.appendText("expected non-empty optional");
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText("was empty");
            }
        }
    }

    private static class IsEmptyMatcher
    extends TypeSafeMatcher<Optional<?>> {
        private IsEmptyMatcher() {
        }

        protected boolean matchesSafely(Optional<?> item) {
            return item != null && !item.isPresent();
        }

        public void describeTo(Description description) {
            description.appendText("expected empty optional");
        }

        protected void describeMismatchSafely(Optional<?> item, Description mismatchDescription) {
            if (item == null) {
                mismatchDescription.appendText("was null");
            } else {
                mismatchDescription.appendText("was ").appendText(item.toString());
            }
        }
    }
}

