/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.Version;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    public static final String CLIENT_PATH_PREFIX = "client.path.prefix";
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;
    private static Boolean hasXPack;
    private static TreeSet<Version> nodeVersions;

    public static Map<String, Object> entityAsMap(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    public static boolean hasXPack() {
        if (hasXPack == null) {
            throw new IllegalStateException("must be called inside of a rest test case test");
        }
        return hasXPack;
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            assert (hasXPack == null);
            assert (nodeVersions == null);
            String cluster = System.getProperty("tests.rest.cluster");
            if (cluster == null) {
                throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
            }
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(this.buildHttpHost(host, port));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            hasXPack = false;
            nodeVersions = new TreeSet();
            Map<String, Object> response = ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "_nodes/plugins")));
            Map nodes = (Map)response.get("nodes");
            for (Map.Entry node : nodes.entrySet()) {
                Map nodeInfo = (Map)node.getValue();
                nodeVersions.add(Version.fromString((String)nodeInfo.get("version").toString()));
                for (Object module : (List)nodeInfo.get("modules")) {
                    Map moduleInfo = (Map)module;
                    if (!moduleInfo.get("name").toString().startsWith("x-pack-")) continue;
                    hasXPack = true;
                }
            }
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
        assert (hasXPack != null);
        assert (nodeVersions != null);
    }

    public static RequestOptions expectVersionSpecificWarnings(Consumer<VersionSensitiveWarningsHandler> expectationsSetter) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        VersionSensitiveWarningsHandler warningsHandler = new VersionSensitiveWarningsHandler(nodeVersions);
        expectationsSetter.accept(warningsHandler);
        builder.setWarningsHandler((WarningsHandler)warningsHandler);
        return builder.build();
    }

    public static RequestOptions expectWarnings(String ... warnings) {
        return ESRestTestCase.expectVersionSpecificWarnings(consumer -> consumer.current(warnings));
    }

    @Deprecated
    public static RequestOptions allowTypesRemovalWarnings() {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setWarningsHandler(new WarningsHandler(){

            public boolean warningsShouldFailRequest(List<String> warnings) {
                for (String warning : warnings) {
                    if (warning.startsWith("[types removal]")) continue;
                    return true;
                }
                return false;
            }
        });
        return builder.build();
    }

    protected HttpHost buildHttpHost(String host, int port) {
        return new HttpHost(host, port, this.getProtocol());
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            if (nodeVersions.stream().noneMatch(version -> version.before(Version.V_6_2_0))) {
                ESRestTestCase.ensureNoInitializingShards();
            }
            this.wipeCluster();
            this.waitForClusterStateUpdatesToFinish();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
            hasXPack = null;
            nodeVersions = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    public static void waitForPendingTasks(RestClient adminClient) throws Exception {
        ESRestTestCase.waitForPendingTasks(adminClient, taskName -> false);
    }

    public static void waitForPendingTasks(RestClient adminClient, Predicate<String> taskFilter) throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block8: {
                try {
                    Request request = new Request("GET", "/_cat/tasks");
                    request.addParameter("detailed", "true");
                    Response response = adminClient.performRequest(request);
                    if (response.getStatusLine().getStatusCode() != 200) break block8;
                    try (BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                        String line;
                        int activeTasks = 0;
                        StringBuilder tasksListString = new StringBuilder();
                        while ((line = responseReader.readLine()) != null) {
                            String taskName = line.split("\\s+")[0];
                            if (taskName.startsWith("cluster:monitor/tasks/lists") || taskFilter.test(taskName)) continue;
                            ++activeTasks;
                            tasksListString.append(line);
                            tasksListString.append('\n');
                        }
                        ESRestTestCase.assertEquals((String)(activeTasks + " active tasks found:\n" + tasksListString), (long)0L, (long)activeTasks);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("error getting active tasks list", e);
                }
            }
        }));
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean preserveClusterSettings() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    protected boolean preserveRollupJobsUponCompletion() {
        return false;
    }

    protected boolean preserveILMPoliciesUponCompletion() {
        return false;
    }

    private void wipeCluster() throws Exception {
        Map<String, List<Map<?, ?>>> inProgressSnapshots;
        block12: {
            if (hasXPack.booleanValue() && !this.preserveRollupJobsUponCompletion()) {
                this.wipeRollupJobs();
                this.waitForPendingRollupTasks();
            }
            inProgressSnapshots = this.wipeSnapshots();
            if (!this.preserveIndicesUponCompletion()) {
                try {
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "*"));
                }
                catch (ResponseException e) {
                    if (e.getResponse().getStatusLine().getStatusCode() == 404) break block12;
                    throw e;
                }
            }
        }
        if (!this.preserveTemplatesUponCompletion()) {
            if (hasXPack.booleanValue()) {
                Request request = new Request("GET", "_cat/templates");
                request.addParameter("h", "name");
                String templates = EntityUtils.toString((HttpEntity)ESRestTestCase.adminClient().performRequest(request).getEntity());
                if (!"".equals(templates)) {
                    for (String template : templates.split("\n")) {
                        if (ESRestTestCase.isXPackTemplate(template)) continue;
                        if ("".equals(template)) {
                            throw new IllegalStateException("empty template in templates list:\n" + templates);
                        }
                        this.logger.debug("Clearing template [{}]", (Object)template);
                        ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/" + template));
                    }
                }
            } else {
                this.logger.debug("Clearing all templates");
                ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/*"));
            }
        }
        if (!this.preserveClusterSettings()) {
            this.wipeClusterSettings();
        }
        if (hasXPack.booleanValue() && !this.preserveILMPoliciesUponCompletion()) {
            ESRestTestCase.deleteAllPolicies();
        }
        ESRestTestCase.assertTrue((String)("Found in progress snapshots [" + inProgressSnapshots + "]."), (boolean)inProgressSnapshots.isEmpty());
    }

    private Map<String, List<Map<?, ?>>> wipeSnapshots() throws IOException {
        HashMap inProgressSnapshots = new HashMap();
        for (Map.Entry<String, Object> repo : ESRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "/_snapshot/_all"))).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                Request listRequest = new Request("GET", "/_snapshot/" + repoName + "/_all");
                listRequest.addParameter("ignore_unavailable", "true");
                List snapshots = (List)ESRestTestCase.entityAsMap(adminClient.performRequest(listRequest)).get("snapshots");
                for (Object snapshot : snapshots) {
                    Map snapshotInfo = (Map)snapshot;
                    String name = (String)snapshotInfo.get("snapshot");
                    if (!SnapshotState.valueOf((String)((String)snapshotInfo.get("state"))).completed()) {
                        inProgressSnapshots.computeIfAbsent(repoName, key -> new ArrayList()).add(snapshotInfo);
                    }
                    this.logger.debug("wiping snapshot [{}/{}]", (Object)repoName, (Object)name);
                    ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_snapshot/" + repoName + "/" + name));
                }
            }
            if (this.preserveReposUponCompletion()) continue;
            this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "_snapshot/" + repoName));
        }
        return inProgressSnapshots;
    }

    private void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = ESRestTestCase.entityAsMap(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/settings")));
        boolean mustClear = false;
        XContentBuilder clearCommand = JsonXContent.contentBuilder();
        clearCommand.startObject();
        for (Map.Entry<String, Object> entry : getResponse.entrySet()) {
            String type = entry.getKey().toString();
            Map settings = (Map)entry.getValue();
            if (settings.isEmpty()) continue;
            mustClear = true;
            clearCommand.startObject(type);
            for (Object key : settings.keySet()) {
                clearCommand.field(key + ".*").nullValue();
            }
            clearCommand.endObject();
        }
        clearCommand.endObject();
        if (mustClear) {
            Request request = new Request("PUT", "/_cluster/settings");
            request.setJsonEntity(Strings.toString((XContentBuilder)clearCommand));
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    private void wipeRollupJobs() throws IOException {
        Request request;
        String jobId;
        Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_rollup/job/_all"));
        Map<String, Object> jobs = ESRestTestCase.entityAsMap(response);
        List jobConfigs = (List)XContentMapValues.extractValue((String)"jobs", jobs);
        if (jobConfigs == null) {
            return;
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("POST", "/_rollup/job/" + jobId + "/_stop");
            request.addParameter("ignore", "404");
            request.addParameter("wait_for_completion", "true");
            request.addParameter("timeout", "10s");
            this.logger.debug("stopping rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
        for (Map jobConfig : jobConfigs) {
            jobId = (String)((Map)jobConfig.get("config")).get("id");
            request = new Request("DELETE", "/_rollup/job/" + jobId);
            request.addParameter("ignore", "404");
            this.logger.debug("deleting rollup job [{}]", (Object)jobId);
            ESRestTestCase.adminClient().performRequest(request);
        }
    }

    private void waitForPendingRollupTasks() throws Exception {
        ESRestTestCase.waitForPendingTasks(ESRestTestCase.adminClient(), taskName -> !taskName.startsWith("xpack/rollup/job"));
    }

    private static void deleteAllPolicies() throws IOException {
        Map<String, Object> policies;
        try {
            Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_ilm/policy"));
            policies = ESRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        for (String policyName : policies.keySet()) {
            ESRestTestCase.adminClient().performRequest(new Request("DELETE", "/_ilm/policy/" + policyName));
        }
    }

    private void logIfThereAreRunningTasks() throws IOException {
        Set<String> runningTasks = this.runningTasks(ESRestTestCase.adminClient().performRequest(new Request("GET", "/_tasks")));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private void waitForClusterStateUpdatesToFinish() throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                Response response = ESRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/pending_tasks"));
                List tasks = (List)ESRestTestCase.entityAsMap(response).get("tasks");
                if (!tasks.isEmpty()) {
                    StringBuilder message = new StringBuilder("there are still running tasks:");
                    for (Object task : tasks) {
                        message.append('\n').append(task.toString());
                    }
                    ESRestTestCase.fail((String)message.toString());
                }
            }
            catch (IOException e) {
                ESRestTestCase.fail((String)("cannot get cluster's pending tasks: " + e.getMessage()));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        Settings.Builder builder = Settings.builder();
        if (System.getProperty("tests.rest.client_path_prefix") != null) {
            builder.put(CLIENT_PATH_PREFIX, System.getProperty("tests.rest.client_path_prefix"));
        }
        return builder.build();
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        ESRestTestCase.configureClient(builder, settings);
        builder.setStrictDeprecationMode(true);
        return builder.build();
    }

    protected static void configureClient(RestClientBuilder builder, Settings settings) throws IOException {
        String keystorePath = settings.get(TRUSTSTORE_PATH);
        if (keystorePath != null) {
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)keystorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                String keyStoreType = keystorePath.endsWith(".p12") ? "PKCS12" : "jks";
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    keyStore.load(is, keystorePass.toCharArray());
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        try (ThreadContext threadContext = new ThreadContext(settings);){
            Header[] defaultHeaders = new Header[threadContext.getHeaders().size()];
            int i = 0;
            for (Map.Entry entry : threadContext.getHeaders().entrySet()) {
                defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
            }
            builder.setDefaultHeaders(defaultHeaders);
        }
        String socketTimeoutString = settings.get(CLIENT_SOCKET_TIMEOUT);
        if (socketTimeoutString != null) {
            TimeValue socketTimeout = TimeValue.parseTimeValue((String)socketTimeoutString, (String)CLIENT_SOCKET_TIMEOUT);
            builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        }
        if (settings.hasValue(CLIENT_PATH_PREFIX)) {
            builder.setPathPrefix(settings.get(CLIENT_PATH_PREFIX));
        }
    }

    private Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)ESRestTestCase.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    protected static void assertOK(Response response) {
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)201)));
    }

    protected static void ensureGreen(String index) throws IOException {
        Request request = new Request("GET", "/_cluster/health/" + index);
        request.addParameter("wait_for_status", "green");
        request.addParameter("wait_for_no_relocating_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        try {
            ESRestTestCase.client().performRequest(request);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 408) {
                try {
                    Response clusterStateResponse = ESRestTestCase.client().performRequest(new Request("GET", "/_cluster/state"));
                    ESRestTestCase.fail((String)("timed out waiting for green state for index [" + index + "] cluster state [" + EntityUtils.toString((HttpEntity)clusterStateResponse.getEntity()) + "]"));
                }
                catch (Exception inner) {
                    e.addSuppressed((Throwable)inner);
                }
            }
            throw e;
        }
    }

    protected static void ensureNoInitializingShards() throws IOException {
        Request request = new Request("GET", "/_cluster/health");
        request.addParameter("wait_for_no_initializing_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        ESRestTestCase.adminClient().performRequest(request);
    }

    protected static void createIndex(String name, Settings settings) throws IOException {
        Request request = new Request("PUT", "/" + name);
        request.setJsonEntity("{\n \"settings\": " + Strings.toString((ToXContent)settings) + "}");
        ESRestTestCase.client().performRequest(request);
    }

    protected static void createIndex(String name, Settings settings, String mapping) throws IOException {
        Request request = new Request("PUT", "/" + name);
        request.setJsonEntity("{\n \"settings\": " + Strings.toString((ToXContent)settings) + ", \"mappings\" : {" + mapping + "} }");
        ESRestTestCase.client().performRequest(request);
    }

    protected static void createIndex(String name, Settings settings, String mapping, String aliases) throws IOException {
        Request request = new Request("PUT", "/" + name);
        request.setJsonEntity("{\n \"settings\": " + Strings.toString((ToXContent)settings) + ", \"mappings\" : {" + mapping + "}, \"aliases\": {" + aliases + "} }");
        ESRestTestCase.client().performRequest(request);
    }

    protected static void deleteIndex(String name) throws IOException {
        Request request = new Request("DELETE", "/" + name);
        ESRestTestCase.client().performRequest(request);
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        ESRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        Request request = new Request("PUT", "/" + index + "/_settings");
        request.setJsonEntity(Strings.toString((ToXContent)settings));
        ESRestTestCase.client().performRequest(request);
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        Request request = new Request("GET", "/" + index + "/_settings");
        request.addParameter("flat_settings", "true");
        Response response = ESRestTestCase.client().performRequest(request);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_close"));
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_open"));
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("HEAD", "/" + index + "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        String endpoint = "/_alias";
        if (!Strings.isEmpty((CharSequence)index)) {
            endpoint = index + endpoint;
        }
        if (!Strings.isEmpty((CharSequence)alias)) {
            endpoint = endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = ESRestTestCase.getAsMap(endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        Response response = ESRestTestCase.client().performRequest(new Request("GET", endpoint));
        XContentType entityContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)false);
        ESRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }

    private static boolean isXPackTemplate(String name) {
        if (name.startsWith(".monitoring-")) {
            return true;
        }
        if (name.startsWith(".watch") || name.startsWith(".triggered_watches")) {
            return true;
        }
        if (name.startsWith(".data-frame-")) {
            return true;
        }
        if (name.startsWith(".ml-")) {
            return true;
        }
        switch (name) {
            case ".triggered_watches": 
            case ".watches": 
            case "logstash-index-template": 
            case "security_audit_log": {
                return true;
            }
        }
        return false;
    }

    public static class VersionSensitiveWarningsHandler
    implements WarningsHandler {
        Set<String> requiredSameVersionClusterWarnings = new HashSet<String>();
        Set<String> allowedWarnings = new HashSet<String>();
        final Set<Version> testNodeVersions;

        public VersionSensitiveWarningsHandler(Set<Version> nodeVersions) {
            this.testNodeVersions = nodeVersions;
        }

        public void current(String ... requiredWarnings) {
            this.requiredSameVersionClusterWarnings.addAll(Arrays.asList(requiredWarnings));
        }

        public void compatible(String ... allowedWarnings) {
            this.allowedWarnings.addAll(Arrays.asList(allowedWarnings));
        }

        public boolean warningsShouldFailRequest(List<String> warnings) {
            if (this.isExclusivelyTargetingCurrentVersionCluster()) {
                HashSet<String> actual = new HashSet<String>(warnings);
                return false == this.requiredSameVersionClusterWarnings.equals(actual);
            }
            for (String actualWarning : warnings) {
                if (this.allowedWarnings.contains(actualWarning) || this.requiredSameVersionClusterWarnings.contains(actualWarning)) continue;
                return true;
            }
            return false;
        }

        private boolean isExclusivelyTargetingCurrentVersionCluster() {
            Assert.assertFalse((String)"Node versions running in the cluster are missing", (boolean)this.testNodeVersions.isEmpty());
            return this.testNodeVersions.size() == 1 && this.testNodeVersions.iterator().next().equals((Object)Version.CURRENT);
        }
    }
}

