/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.test.rest.yaml.ObjectPath;

public class Stash
implements ToXContentFragment {
    private static final Pattern EXTENDED_KEY = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final Pattern PATH = Pattern.compile("\\$_path");
    private static final Logger logger = LogManager.getLogger(Stash.class);
    public static final Stash EMPTY = new Stash();
    private final Map<String, Object> stash = new HashMap<String, Object>();
    private final ObjectPath stashObjectPath = new ObjectPath(this.stash);

    public void stashValue(String key, Object value) {
        logger.trace("stashing [{}]=[{}]", (Object)key, value);
        Object old = this.stash.put(key, value);
        if (old != null && old != value) {
            logger.trace("replaced stashed value [{}] with same key [{}]", old, (Object)key);
        }
    }

    public void clear() {
        this.stash.clear();
    }

    public boolean containsStashedValue(Object key) {
        if (key == null || !(key instanceof CharSequence)) {
            return false;
        }
        String stashKey = key.toString();
        if (!Strings.hasLength((String)stashKey)) {
            return false;
        }
        if (stashKey.startsWith("$")) {
            return true;
        }
        return EXTENDED_KEY.matcher(stashKey).find();
    }

    public Object getValue(String key) throws IOException {
        if (key.charAt(0) == '$' && key.charAt(1) != '{') {
            return this.unstash(key.substring(1));
        }
        Matcher matcher = EXTENDED_KEY.matcher(key);
        StringBuffer result = new StringBuffer(key.length());
        if (!matcher.find()) {
            throw new IllegalArgumentException("Doesn't contain any stash keys [" + key + "]");
        }
        do {
            matcher.appendReplacement(result, Matcher.quoteReplacement(this.unstash(matcher.group(1)).toString()));
        } while (matcher.find());
        matcher.appendTail(result);
        return result.toString();
    }

    private Object unstash(String key) throws IOException {
        Object stashedValue = this.stashObjectPath.evaluate(key);
        if (stashedValue == null) {
            throw new IllegalArgumentException("stashed value not found for key [" + key + "]");
        }
        return stashedValue;
    }

    public Map<String, Object> replaceStashedValues(Map<String, Object> map) throws IOException {
        return (Map)this.unstashObject(new ArrayList<Object>(), map);
    }

    private Object unstashObject(List<Object> path, Object obj) throws IOException {
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList<Object> result = new ArrayList<Object>();
            int index = 0;
            for (Object o : list) {
                path.add(index++);
                if (this.containsStashedValue(o)) {
                    result.add(this.getValue(path, o.toString()));
                } else {
                    result.add(this.unstashObject(path, o));
                }
                path.remove(path.size() - 1);
            }
            return result;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (this.containsStashedValue(key)) {
                    key = this.getValue(key).toString();
                }
                path.add(key);
                value = this.containsStashedValue(value) ? this.getValue(path, value.toString()) : this.unstashObject(path, value);
                path.remove(path.size() - 1);
                if (null == result.putIfAbsent(key, value)) continue;
                throw new IllegalArgumentException("Unstashing has caused a key conflict! The map is [" + result + "] and the key is [" + entry.getKey() + "] which unstashes to [" + key + "]");
            }
            return result;
        }
        return obj;
    }

    private Object getValue(List<Object> path, String key) throws IOException {
        Matcher matcher = PATH.matcher(key);
        if (!matcher.find()) {
            return this.getValue(key);
        }
        StringBuilder pathBuilder = new StringBuilder();
        Iterator<Object> element = path.iterator();
        if (element.hasNext()) {
            pathBuilder.append(element.next().toString().replace(".", "\\."));
            while (element.hasNext()) {
                pathBuilder.append('.');
                pathBuilder.append(element.next().toString().replace(".", "\\."));
            }
        }
        String builtPath = Matcher.quoteReplacement(pathBuilder.toString());
        StringBuffer newKey = new StringBuffer(key.length());
        do {
            matcher.appendReplacement(newKey, builtPath);
        } while (matcher.find());
        matcher.appendTail(newKey);
        return this.getValue(newKey.toString());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("stash", this.stash);
        return builder;
    }
}

