/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.restspec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestPath;

public class ClientYamlSuiteRestApi {
    private final String location;
    private final String name;
    private List<String> methods = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    private Map<String, Boolean> pathParts = new HashMap<String, Boolean>();
    private Map<String, Boolean> params = new HashMap<String, Boolean>();
    private Body body = Body.NOT_SUPPORTED;
    private Stability stability = Stability.UNKNOWN;

    ClientYamlSuiteRestApi(String location, String name) {
        this.location = location;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public List<String> getSupportedMethods(Set<String> restParams) {
        if ("index".equals(this.name) || "create".equals(this.name)) {
            ArrayList<String> indexMethods = new ArrayList<String>();
            for (String method : this.methods) {
                if (restParams.contains("id")) {
                    if (!"PUT".equals(method)) continue;
                    indexMethods.add(method);
                    continue;
                }
                if (!"POST".equals(method)) continue;
                indexMethods.add(method);
            }
            return indexMethods;
        }
        return this.methods;
    }

    void addMethod(String method) {
        this.methods.add(method);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    void addPath(String path) {
        this.paths.add(path);
    }

    public Map<String, Boolean> getPathParts() {
        return this.pathParts;
    }

    void addPathPart(String pathPart, boolean required) {
        this.pathParts.put(pathPart, required);
    }

    public Map<String, Boolean> getParams() {
        return this.params;
    }

    void addParam(String param, boolean required) {
        this.params.put(param, required);
    }

    void setBodyOptional() {
        this.body = Body.OPTIONAL;
    }

    void setBodyRequired() {
        this.body = Body.REQUIRED;
    }

    public boolean isBodySupported() {
        return this.body != Body.NOT_SUPPORTED;
    }

    public boolean isBodyRequired() {
        return this.body == Body.REQUIRED;
    }

    public void setStability(String stability) {
        this.stability = Stability.valueOf(stability.toUpperCase(Locale.ROOT));
    }

    public Stability getStability() {
        return this.stability;
    }

    public ClientYamlSuiteRestPath[] getFinalPaths(Map<String, String> pathParams) {
        List<ClientYamlSuiteRestPath> matchingRestPaths = this.findMatchingRestPaths(pathParams.keySet());
        if (matchingRestPaths == null || matchingRestPaths.isEmpty()) {
            throw new IllegalArgumentException("unable to find matching rest path for api [" + this.name + "] and path params " + pathParams);
        }
        ClientYamlSuiteRestPath[] restPaths = new ClientYamlSuiteRestPath[matchingRestPaths.size()];
        for (int i = 0; i < matchingRestPaths.size(); ++i) {
            ClientYamlSuiteRestPath restPath = matchingRestPaths.get(i);
            restPaths[i] = restPath.replacePlaceholders(pathParams);
        }
        return restPaths;
    }

    private List<ClientYamlSuiteRestPath> findMatchingRestPaths(Set<String> restParams) {
        ClientYamlSuiteRestPath[] restPaths;
        ArrayList<ClientYamlSuiteRestPath> matchingRestPaths = new ArrayList<ClientYamlSuiteRestPath>();
        for (ClientYamlSuiteRestPath restPath : restPaths = this.buildRestPaths()) {
            if (!restPath.matches(restParams)) continue;
            matchingRestPaths.add(restPath);
        }
        return matchingRestPaths;
    }

    private ClientYamlSuiteRestPath[] buildRestPaths() {
        ClientYamlSuiteRestPath[] restPaths = new ClientYamlSuiteRestPath[this.paths.size()];
        for (int i = 0; i < restPaths.length; ++i) {
            restPaths[i] = new ClientYamlSuiteRestPath(this.paths.get(i));
        }
        return restPaths;
    }

    public static enum Body {
        NOT_SUPPORTED,
        OPTIONAL,
        REQUIRED;

    }

    public static enum Stability {
        UNKNOWN,
        EXPERIMENTAL,
        BETA,
        STABLE;

    }
}

