/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.tasks.MockTaskManager;
import org.elasticsearch.test.transport.StubbableConnectionManager;
import org.elasticsearch.test.transport.StubbableTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.nio.MockNioTransport;

public final class MockTransportService
extends TransportService {
    private static final Logger logger = LogManager.getLogger(MockTransportService.class);
    private final Map<DiscoveryNode, List<Transport.Connection>> openConnections = new HashMap<DiscoveryNode, List<Transport.Connection>>();
    private final Transport original;

    public static MockTransportService createNewService(Settings settings, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings) {
        MockNioTransport mockTransport = MockTransportService.newMockTransport(settings, version, threadPool);
        return MockTransportService.createNewService(settings, (Transport)mockTransport, version, threadPool, clusterSettings, Collections.emptySet());
    }

    public static String getPortRange() {
        return MockTransportService.getBasePort() + "-" + (MockTransportService.getBasePort() + 99);
    }

    protected static int getBasePort() {
        int startAt;
        String workerId = System.getProperty("org.gradle.test.worker");
        int n = startAt = workerId == null ? 0 : (int)Math.floorMod((long)Long.valueOf(workerId), 223L);
        assert (startAt >= 0) : "Unexpected test worker Id, resulting port range would be negative";
        return 10300 + startAt * 100;
    }

    public static MockNioTransport newMockTransport(Settings settings, Version version, ThreadPool threadPool) {
        settings = Settings.builder().put(TransportSettings.PORT.getKey(), MockTransportService.getPortRange()).put(settings).build();
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
        return new MockNioTransport(settings, version, threadPool, new NetworkService(Collections.emptyList()), new MockPageCacheRecycler(settings), namedWriteableRegistry, (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    public static MockTransportService createNewService(Settings settings, Transport transport, Version version, ThreadPool threadPool, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        return new MockTransportService(settings, transport, threadPool, TransportService.NOOP_TRANSPORT_INTERCEPTOR, boundAddress -> new DiscoveryNode((String)Node.NODE_NAME_SETTING.get(settings), UUIDs.randomBase64UUID(), boundAddress.publishAddress(), Node.NODE_ATTRIBUTES.getAsMap(settings), DiscoveryNode.getRolesFromSettings((Settings)settings), version), clusterSettings, taskHeaders);
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, @Nullable ClusterSettings clusterSettings) {
        this(settings, transport, threadPool, interceptor, (BoundTransportAddress boundAddress) -> DiscoveryNode.createLocal((Settings)settings, (TransportAddress)boundAddress.publishAddress(), (String)settings.get(Node.NODE_NAME_SETTING.getKey(), UUIDs.randomBase64UUID())), clusterSettings, Collections.emptySet());
    }

    public MockTransportService(Settings settings, Transport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        this(settings, new StubbableTransport(transport), threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders);
    }

    private MockTransportService(Settings settings, StubbableTransport transport, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        super(settings, (Transport)transport, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, (ConnectionManager)new StubbableConnectionManager(new ConnectionManager(settings, (Transport)transport), settings, transport));
        this.original = transport.getDelegate();
    }

    private static TransportAddress[] extractTransportAddresses(TransportService transportService) {
        HashSet<TransportAddress> transportAddresses = new HashSet<TransportAddress>();
        BoundTransportAddress boundTransportAddress = transportService.boundAddress();
        transportAddresses.addAll(Arrays.asList(boundTransportAddress.boundAddresses()));
        transportAddresses.add(boundTransportAddress.publishAddress());
        return transportAddresses.toArray(new TransportAddress[transportAddresses.size()]);
    }

    protected TaskManager createTaskManager(Settings settings, ThreadPool threadPool, Set<String> taskHeaders) {
        if (((Boolean)MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING.get(settings)).booleanValue()) {
            return new MockTaskManager(settings, threadPool, taskHeaders);
        }
        return super.createTaskManager(settings, threadPool, taskHeaders);
    }

    public void clearAllRules() {
        this.transport().clearBehaviors();
        this.connectionManager().clearBehaviors();
    }

    public void clearRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.clearRule(transportAddress);
        }
    }

    public void clearRule(TransportAddress transportAddress) {
        this.transport().clearBehavior(transportAddress);
        this.connectionManager().clearBehavior(transportAddress);
    }

    public void addFailToSendNoConnectRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> {
            listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "DISCONNECT: simulated"));
            return () -> {};
        });
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            connection.close();
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addFailToSendNoConnectRule(TransportService transportService, String ... blockedActions) {
        this.addFailToSendNoConnectRule(transportService, new HashSet<String>(Arrays.asList(blockedActions)));
    }

    public void addFailToSendNoConnectRule(TransportService transportService, Set<String> blockedActions) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addFailToSendNoConnectRule(transportAddress, blockedActions);
        }
    }

    public void addFailToSendNoConnectRule(TransportAddress transportAddress, Set<String> blockedActions) {
        this.transport().addSendBehavior(transportAddress, (Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) -> {
            if (blockedActions.contains(action)) {
                logger.info("--> preventing {} request", (Object)action);
                connection.close();
            }
            connection.sendRequest(requestId, action, request, options);
        });
    }

    public void addUnresponsiveRule(TransportService transportService) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress) {
        this.transport().addConnectBehavior(transportAddress, (Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) -> {
            listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
            return () -> {};
        });
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(){
            private Set<Transport.Connection> toClose = ConcurrentHashMap.newKeySet();

            @Override
            public void sendRequest(Transport.Connection connection, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
                this.toClose.add(connection);
            }

            @Override
            public void clearCallback() {
                try {
                    IOUtils.close(this.toClose);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void addUnresponsiveRule(TransportService transportService, TimeValue duration) {
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            this.addUnresponsiveRule(transportAddress, duration);
        }
    }

    public void addUnresponsiveRule(TransportAddress transportAddress, TimeValue duration) {
        long startTime = System.currentTimeMillis();
        final Supplier<TimeValue> delaySupplier = () -> new TimeValue(duration.millis() - (System.currentTimeMillis() - startTime));
        this.transport().addConnectBehavior(transportAddress, new StubbableTransport.OpenConnectionBehavior(){
            private CountDownLatch stopLatch = new CountDownLatch(1);

            @Override
            public Releasable openConnection(Transport transport, DiscoveryNode discoveryNode, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    return MockTransportService.this.original.openConnection(discoveryNode, profile, listener);
                }
                TimeValue connectingTimeout = (TimeValue)TransportSettings.CONNECT_TIMEOUT.getDefault(Settings.EMPTY);
                try {
                    if (delay.millis() < connectingTimeout.millis()) {
                        this.stopLatch.await(delay.millis(), TimeUnit.MILLISECONDS);
                        return MockTransportService.this.original.openConnection(discoveryNode, profile, listener);
                    }
                    this.stopLatch.await(connectingTimeout.millis(), TimeUnit.MILLISECONDS);
                    listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                    return () -> {};
                }
                catch (InterruptedException e) {
                    listener.onFailure((Exception)new ConnectTransportException(discoveryNode, "UNRESPONSIVE: simulated"));
                    return () -> {};
                }
            }

            @Override
            public void clearCallback() {
                this.stopLatch.countDown();
            }
        });
        this.transport().addSendBehavior(transportAddress, new StubbableTransport.SendRequestBehavior(){
            private final Queue<Runnable> requestsToSendWhenCleared = new LinkedBlockingDeque<Runnable>();
            private boolean cleared = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendRequest(final Transport.Connection connection, final long requestId, final String action, TransportRequest request, final TransportRequestOptions options) throws IOException {
                TimeValue delay = (TimeValue)delaySupplier.get();
                if (delay.millis() <= 0L) {
                    connection.sendRequest(requestId, action, request, options);
                    return;
                }
                RequestHandlerRegistry reg = MockTransportService.this.getRequestHandler(action);
                BytesStreamOutput bStream = new BytesStreamOutput();
                request.writeTo((StreamOutput)bStream);
                final TransportRequest clonedRequest = reg.newRequest(bStream.bytes().streamInput());
                RunOnce runnable = new RunOnce((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception e) {
                        logger.debug("failed to send delayed request", (Throwable)e);
                    }

                    protected void doRun() throws IOException {
                        connection.sendRequest(requestId, action, clonedRequest, options);
                    }
                });
                3 var12_11 = this;
                synchronized (var12_11) {
                    if (this.cleared) {
                        runnable.run();
                    } else {
                        this.requestsToSendWhenCleared.add((Runnable)runnable);
                        MockTransportService.this.threadPool.schedule((Runnable)runnable, delay, "generic");
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearCallback() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    assert (!this.cleared);
                    this.cleared = true;
                    this.requestsToSendWhenCleared.forEach(Runnable::run);
                }
            }
        });
    }

    public boolean addSendBehavior(TransportService transportService, StubbableTransport.SendRequestBehavior sendBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addSendBehavior(transportAddress, sendBehavior);
        }
        return noRegistered;
    }

    public boolean addSendBehavior(TransportAddress transportAddress, StubbableTransport.SendRequestBehavior sendBehavior) {
        return this.transport().addSendBehavior(transportAddress, sendBehavior);
    }

    public boolean addSendBehavior(StubbableTransport.SendRequestBehavior behavior) {
        return this.transport().setDefaultSendBehavior(behavior);
    }

    public boolean addConnectBehavior(TransportService transportService, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        boolean noRegistered = true;
        for (TransportAddress transportAddress : MockTransportService.extractTransportAddresses(transportService)) {
            noRegistered &= this.addConnectBehavior(transportAddress, connectBehavior);
        }
        return noRegistered;
    }

    public boolean addConnectBehavior(TransportAddress transportAddress, StubbableTransport.OpenConnectionBehavior connectBehavior) {
        return this.transport().addConnectBehavior(transportAddress, connectBehavior);
    }

    public boolean addGetConnectionBehavior(TransportAddress transportAddress, StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().addConnectBehavior(transportAddress, behavior);
    }

    public boolean addGetConnectionBehavior(StubbableConnectionManager.GetConnectionBehavior behavior) {
        return this.connectionManager().setDefaultGetConnectionBehavior(behavior);
    }

    public boolean addNodeConnectedBehavior(TransportAddress transportAddress, StubbableConnectionManager.NodeConnectedBehavior behavior) {
        return this.connectionManager().addNodeConnectedBehavior(transportAddress, behavior);
    }

    public boolean addNodeConnectedBehavior(StubbableConnectionManager.NodeConnectedBehavior behavior) {
        return this.connectionManager().setDefaultNodeConnectedBehavior(behavior);
    }

    public StubbableTransport transport() {
        return (StubbableTransport)this.transport;
    }

    public StubbableConnectionManager connectionManager() {
        return (StubbableConnectionManager)this.connectionManager;
    }

    public Transport getOriginalTransport() {
        StubbableTransport transport = this.transport();
        while (transport instanceof StubbableTransport) {
            transport = transport.getDelegate();
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
        Transport.Connection connection = super.openConnection(node, profile);
        Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
        synchronized (map) {
            this.openConnections.computeIfAbsent(node, n -> new CopyOnWriteArrayList()).add(connection);
            connection.addCloseListener(ActionListener.wrap(() -> {
                Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
                synchronized (map) {
                    List<Transport.Connection> connections = this.openConnections.get(node);
                    boolean remove = connections.remove(connection);
                    assert (remove) : "Should have removed connection";
                    if (connections.isEmpty()) {
                        this.openConnections.remove(node);
                    }
                    if (this.openConnections.isEmpty()) {
                        this.openConnections.notifyAll();
                    }
                }
            }));
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        super.doClose();
        try {
            Map<DiscoveryNode, List<Transport.Connection>> map = this.openConnections;
            synchronized (map) {
                if (!this.openConnections.isEmpty()) {
                    this.openConnections.wait(TimeUnit.SECONDS.toMillis(30L));
                }
                assert (this.openConnections.size() == 0) : "still open connections: " + this.openConnections;
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public DiscoveryNode getLocalDiscoNode() {
        return this.getLocalNode();
    }

    public static class TestPlugin
    extends Plugin {
        public List<Setting<?>> getSettings() {
            return Arrays.asList(MockTaskManager.USE_MOCK_TASK_MANAGER_SETTING);
        }
    }
}

