/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;

public class StubbableConnectionManager
extends ConnectionManager {
    private final ConnectionManager delegate;
    private final ConcurrentMap<TransportAddress, GetConnectionBehavior> getConnectionBehaviors;
    private final ConcurrentMap<TransportAddress, NodeConnectedBehavior> nodeConnectedBehaviors;
    private volatile GetConnectionBehavior defaultGetConnectionBehavior = ConnectionManager::getConnection;
    private volatile NodeConnectedBehavior defaultNodeConnectedBehavior = ConnectionManager::nodeConnected;

    public StubbableConnectionManager(ConnectionManager delegate, Settings settings, Transport transport) {
        super(settings, transport);
        this.delegate = delegate;
        this.getConnectionBehaviors = new ConcurrentHashMap<TransportAddress, GetConnectionBehavior>();
        this.nodeConnectedBehaviors = new ConcurrentHashMap<TransportAddress, NodeConnectedBehavior>();
    }

    public boolean addConnectBehavior(TransportAddress transportAddress, GetConnectionBehavior connectBehavior) {
        return this.getConnectionBehaviors.put(transportAddress, connectBehavior) == null;
    }

    public boolean setDefaultGetConnectionBehavior(GetConnectionBehavior behavior) {
        GetConnectionBehavior prior = this.defaultGetConnectionBehavior;
        this.defaultGetConnectionBehavior = behavior;
        return prior == null;
    }

    public boolean addNodeConnectedBehavior(TransportAddress transportAddress, NodeConnectedBehavior behavior) {
        return this.nodeConnectedBehaviors.put(transportAddress, behavior) == null;
    }

    public boolean setDefaultNodeConnectedBehavior(NodeConnectedBehavior behavior) {
        NodeConnectedBehavior prior = this.defaultNodeConnectedBehavior;
        this.defaultNodeConnectedBehavior = behavior;
        return prior == null;
    }

    public void clearBehaviors() {
        this.defaultGetConnectionBehavior = ConnectionManager::getConnection;
        this.getConnectionBehaviors.clear();
        this.defaultNodeConnectedBehavior = ConnectionManager::nodeConnected;
        this.nodeConnectedBehaviors.clear();
    }

    public void clearBehavior(TransportAddress transportAddress) {
        this.getConnectionBehaviors.remove(transportAddress);
        this.nodeConnectedBehaviors.remove(transportAddress);
    }

    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile connectionProfile) {
        return this.delegate.openConnection(node, connectionProfile);
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        TransportAddress address = node.getAddress();
        GetConnectionBehavior behavior = this.getConnectionBehaviors.getOrDefault(address, this.defaultGetConnectionBehavior);
        return behavior.getConnection(this.delegate, node);
    }

    public boolean nodeConnected(DiscoveryNode node) {
        TransportAddress address = node.getAddress();
        NodeConnectedBehavior behavior = this.nodeConnectedBehaviors.getOrDefault(address, this.defaultNodeConnectedBehavior);
        return behavior.nodeConnected(this.delegate, node);
    }

    public void addListener(TransportConnectionListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(TransportConnectionListener listener) {
        this.delegate.removeListener(listener);
    }

    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, CheckedBiConsumer<Transport.Connection, ConnectionProfile, IOException> connectionValidator) throws ConnectTransportException {
        this.delegate.connectToNode(node, connectionProfile, connectionValidator);
    }

    public void disconnectFromNode(DiscoveryNode node) {
        this.delegate.disconnectFromNode(node);
    }

    public int size() {
        return this.delegate.size();
    }

    public void close() {
        this.delegate.close();
    }

    @FunctionalInterface
    public static interface NodeConnectedBehavior {
        public boolean nodeConnected(ConnectionManager var1, DiscoveryNode var2);
    }

    @FunctionalInterface
    public static interface GetConnectionBehavior {
        public Transport.Connection getConnection(ConnectionManager var1, DiscoveryNode var2);
    }
}

