/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.plugins.MetaDataUpgrader;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.mockito.Mockito;

public class MockGatewayMetaState
extends GatewayMetaState {
    private final DiscoveryNode localNode;

    public MockGatewayMetaState(DiscoveryNode localNode) {
        this.localNode = localNode;
    }

    void upgradeMetaData(Settings settings, MetaStateService metaStateService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) {
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        return ClusterStateUpdaters.setLocalNode((ClusterState)clusterState, (DiscoveryNode)this.localNode);
    }

    public void start(Settings settings, NodeEnvironment nodeEnvironment, NamedXContentRegistry xContentRegistry) {
        TransportService transportService = (TransportService)Mockito.mock(TransportService.class);
        Mockito.when((Object)transportService.getThreadPool()).thenReturn((Object)((ThreadPool)Mockito.mock(ThreadPool.class)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        Mockito.when((Object)clusterService.getClusterSettings()).thenReturn((Object)new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
        this.start(settings, transportService, clusterService, new MetaStateService(nodeEnvironment, xContentRegistry), null, null);
    }
}

