/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.lucene.geo.GeoTestUtil;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.test.ESTestCase;

public class GeometryTestUtils {
    public static double randomLat() {
        return GeoTestUtil.nextLatitude();
    }

    public static double randomLon() {
        return GeoTestUtil.nextLongitude();
    }

    public static double randomAlt() {
        return ESTestCase.randomDouble();
    }

    public static Circle randomCircle(boolean hasAlt) {
        if (hasAlt) {
            return new Circle(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), ESTestCase.randomDouble(), ESTestCase.randomDoubleBetween(0.0, 100.0, false));
        }
        return new Circle(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), ESTestCase.randomDoubleBetween(0.0, 100.0, false));
    }

    public static Line randomLine(boolean hasAlts) {
        org.apache.lucene.geo.Polygon lucenePolygon = GeoTestUtil.nextPolygon();
        int size = lucenePolygon.numPoints() - 1;
        double[] lats = new double[size];
        double[] lons = new double[size];
        double[] alts = hasAlts ? new double[size] : null;
        for (int i = 0; i < size; ++i) {
            lats[i] = lucenePolygon.getPolyLat(i);
            lons[i] = lucenePolygon.getPolyLon(i);
            if (!hasAlts) continue;
            alts[i] = GeometryTestUtils.randomAlt();
        }
        if (hasAlts) {
            return new Line(lons, lats, alts);
        }
        return new Line(lons, lats);
    }

    public static Point randomPoint() {
        return GeometryTestUtils.randomPoint(ESTestCase.randomBoolean());
    }

    public static Point randomPoint(boolean hasAlt) {
        if (hasAlt) {
            return new Point(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), GeometryTestUtils.randomAlt());
        }
        return new Point(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat());
    }

    public static Polygon randomPolygon(boolean hasAlt) {
        org.apache.lucene.geo.Polygon lucenePolygon = GeoTestUtil.nextPolygon();
        if (lucenePolygon.numHoles() > 0) {
            org.apache.lucene.geo.Polygon[] luceneHoles = lucenePolygon.getHoles();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < lucenePolygon.numHoles(); ++i) {
                org.apache.lucene.geo.Polygon poly = luceneHoles[i];
                holes.add(GeometryTestUtils.linearRing(poly.getPolyLons(), poly.getPolyLats(), hasAlt));
            }
            return new Polygon(GeometryTestUtils.linearRing(lucenePolygon.getPolyLons(), lucenePolygon.getPolyLats(), hasAlt), holes);
        }
        return new Polygon(GeometryTestUtils.linearRing(lucenePolygon.getPolyLons(), lucenePolygon.getPolyLats(), hasAlt));
    }

    private static double[] randomAltRing(int size) {
        double[] alts = new double[size];
        for (int i = 0; i < size - 1; ++i) {
            alts[i] = GeometryTestUtils.randomAlt();
        }
        alts[size - 1] = alts[0];
        return alts;
    }

    public static LinearRing linearRing(double[] lons, double[] lats, boolean generateAlts) {
        if (generateAlts) {
            return new LinearRing(lons, lats, GeometryTestUtils.randomAltRing(lats.length));
        }
        return new LinearRing(lons, lats);
    }

    public static Rectangle randomRectangle() {
        org.apache.lucene.geo.Rectangle rectangle = GeoTestUtil.nextBox();
        return new Rectangle(rectangle.minLon, rectangle.maxLon, rectangle.maxLat, rectangle.minLat);
    }

    public static MultiPoint randomMultiPoint(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            points.add(GeometryTestUtils.randomPoint(hasAlt));
        }
        return new MultiPoint(points);
    }

    public static MultiLine randomMultiLine(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < size; ++i) {
            lines.add(GeometryTestUtils.randomLine(hasAlt));
        }
        return new MultiLine(lines);
    }

    public static MultiPolygon randomMultiPolygon(boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(3, 10);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < size; ++i) {
            polygons.add(GeometryTestUtils.randomPolygon(hasAlt));
        }
        return new MultiPolygon(polygons);
    }

    public static GeometryCollection<Geometry> randomGeometryCollection(boolean hasAlt) {
        return GeometryTestUtils.randomGeometryCollection(0, hasAlt);
    }

    private static GeometryCollection<Geometry> randomGeometryCollection(int level, boolean hasAlt) {
        int size = ESTestCase.randomIntBetween(1, 10);
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        for (int i = 0; i < size; ++i) {
            shapes.add(GeometryTestUtils.randomGeometry(level, hasAlt));
        }
        return new GeometryCollection(shapes);
    }

    public static Geometry randomGeometry(boolean hasAlt) {
        return GeometryTestUtils.randomGeometry(0, hasAlt);
    }

    protected static Geometry randomGeometry(int level, boolean hasAlt) {
        Function geometry = ESTestCase.randomFrom(GeometryTestUtils::randomCircle, GeometryTestUtils::randomLine, GeometryTestUtils::randomPoint, GeometryTestUtils::randomPolygon, GeometryTestUtils::randomMultiLine, GeometryTestUtils::randomMultiPoint, GeometryTestUtils::randomMultiPolygon, hasAlt ? GeometryTestUtils::randomPoint : b -> GeometryTestUtils.randomRectangle(), level < 3 ? b -> GeometryTestUtils.randomGeometryCollection(level + 1, b) : GeometryTestUtils::randomPoint);
        return (Geometry)geometry.apply(hasAlt);
    }
}

