/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.test.rest.yaml.ObjectPath;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class RetentionLeaseUtils {
    private RetentionLeaseUtils() {
    }

    public static Map<String, RetentionLease> toMapExcludingPeerRecoveryRetentionLeases(RetentionLeases retentionLeases) {
        return retentionLeases.leases().stream().filter(l -> !"peer recovery".equals(l.source())).collect(Collectors.toMap(RetentionLease::id, Function.identity(), (o1, o2) -> {
            throw new AssertionError((Object)("unexpectedly merging " + o1 + " and " + o2));
        }, LinkedHashMap::new));
    }

    public static void assertAllCopiesHavePeerRecoveryRetentionLeases(RestClient restClient, String index) throws IOException {
        Request statsRequest = new Request("GET", "/" + index + "/_stats");
        statsRequest.addParameter("level", "shards");
        Map shardsStats = (Map)ObjectPath.createFromResponse(restClient.performRequest(statsRequest)).evaluate("indices." + index + ".shards");
        for (Map.Entry shardCopiesEntry : shardsStats.entrySet()) {
            List shardCopiesList = (List)shardCopiesEntry.getValue();
            HashSet<String> expectedLeaseIds = new HashSet<String>();
            for (Object shardCopyStats : shardCopiesList) {
                String nodeId = Objects.requireNonNull((String)((Map)((Map)shardCopyStats).get("routing")).get("node"));
                expectedLeaseIds.add(ReplicationTracker.getPeerRecoveryRetentionLeaseId((ShardRouting)ShardRouting.newUnassigned((ShardId)new ShardId("_na_", "test", 0), (boolean)false, (RecoverySource)RecoverySource.PeerRecoverySource.INSTANCE, (UnassignedInfo)new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, "test")).initialize(nodeId, null, 0L)));
            }
            HashSet<String> actualLeaseIds = new HashSet<String>();
            for (Object shardCopyStats : shardCopiesList) {
                List leases = (List)((Map)((Map)shardCopyStats).get("retention_leases")).get("leases");
                for (Object lease : leases) {
                    actualLeaseIds.add(Objects.requireNonNull((String)((Map)lease).get("id")));
                }
            }
            Assert.assertThat((String)("[" + index + "][" + shardCopiesEntry.getKey() + "] has leases " + actualLeaseIds + " but expected " + expectedLeaseIds), actualLeaseIds, (Matcher)Matchers.hasItems((Object[])expectedLeaseIds.toArray(new String[0])));
        }
    }
}

