/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class BlobStoreTestUtil {
    public static void assertRepoConsistency(InternalTestCluster testCluster, String repoName) {
        BlobStoreRepository repo = (BlobStoreRepository)testCluster.getCurrentMasterNodeInstance(RepositoriesService.class).repository(repoName);
        BlobStoreTestUtil.assertConsistency(repo, repo.threadPool().executor("generic"));
    }

    public static boolean blobExists(BlobContainer container, String blobName) throws IOException {
        boolean bl;
        block8: {
            InputStream ignored = container.readBlob(blobName);
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    public static void assertConsistency(BlobStoreRepository repository, Executor executor) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        executor.execute((Runnable)ActionRunnable.run((ActionListener)listener, () -> {
            RepositoryData repositoryData;
            long latestGen;
            BlobContainer blobContainer = repository.blobContainer();
            try (DataInputStream inputStream = new DataInputStream(blobContainer.readBlob("index.latest"));){
                latestGen = inputStream.readLong();
            }
            catch (NoSuchFileException e) {
                throw new AssertionError((Object)("Could not find index.latest blob for repo [" + repository + "]"));
            }
            BlobStoreTestUtil.assertIndexGenerations(blobContainer, latestGen);
            try (InputStream blob = blobContainer.readBlob("index-" + latestGen);
                 XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);){
                repositoryData = RepositoryData.snapshotsFromXContent((XContentParser)parser, (long)latestGen);
            }
            BlobStoreTestUtil.assertIndexUUIDs(blobContainer, repositoryData);
            BlobStoreTestUtil.assertSnapshotUUIDs(repository, repositoryData);
        }));
        listener.actionGet(TimeValue.timeValueMinutes((long)1L));
    }

    private static void assertIndexGenerations(BlobContainer repoRoot, long latestGen) throws IOException {
        long[] indexGenerations = repoRoot.listBlobsByPrefix("index-").keySet().stream().map(s -> s.replace("index-", "")).mapToLong(Long::parseLong).sorted().toArray();
        Assert.assertEquals((long)latestGen, (long)indexGenerations[indexGenerations.length - 1]);
        Assert.assertTrue((indexGenerations.length <= 2 ? 1 : 0) != 0);
    }

    private static void assertIndexUUIDs(BlobContainer repoRoot, RepositoryData repositoryData) throws IOException {
        List<String> expectedIndexUUIDs = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toList());
        BlobContainer indicesContainer = (BlobContainer)repoRoot.children().get("indices");
        List foundIndexUUIDs = indicesContainer == null ? Collections.emptyList() : indicesContainer.children().keySet().stream().filter(s -> !s.startsWith("extra")).collect(Collectors.toList());
        Assert.assertThat(foundIndexUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedIndexUUIDs.toArray(Strings.EMPTY_ARRAY)));
    }

    private static void assertSnapshotUUIDs(BlobStoreRepository repository, RepositoryData repositoryData) throws IOException {
        BlobContainer repoRoot = repository.blobContainer();
        Collection snapshotIds = repositoryData.getSnapshotIds();
        List<String> expectedSnapshotUUIDs = snapshotIds.stream().map(SnapshotId::getUUID).collect(Collectors.toList());
        for (String prefix : new String[]{"snap-", "meta-"}) {
            Collection foundSnapshotUUIDs = repoRoot.listBlobs().keySet().stream().filter(p -> p.startsWith(prefix)).map(p -> p.replace(prefix, "").replace(".dat", "")).collect(Collectors.toSet());
            Assert.assertThat((Object)foundSnapshotUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedSnapshotUUIDs.toArray(Strings.EMPTY_ARRAY)));
        }
        BlobContainer indicesContainer = (BlobContainer)repository.getBlobContainer().children().get("indices");
        Map indices = indicesContainer == null ? Collections.emptyMap() : indicesContainer.children();
        for (SnapshotId snapshotId : snapshotIds) {
            SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            for (String index : snapshotInfo.indices()) {
                IndexId indexId = repositoryData.resolveIndexId(index);
                Assert.assertThat((Object)indices, (Matcher)Matchers.hasKey((Object)indexId.getId()));
                BlobContainer indexContainer = (BlobContainer)indices.get(indexId.getId());
                Assert.assertThat((Object)indexContainer.listBlobs(), (Matcher)Matchers.hasKey((Object)String.format(Locale.ROOT, "meta-%s.dat", snapshotId.getUUID())));
                for (Map.Entry entry : indexContainer.children().entrySet()) {
                    if (((String)entry.getKey()).startsWith("extra") || !snapshotInfo.shardFailures().stream().noneMatch(shardFailure -> shardFailure.index().equals(index) && shardFailure.shardId() == Integer.parseInt((String)entry.getKey()))) continue;
                    Map shardPathContents = ((BlobContainer)entry.getValue()).listBlobs();
                    Assert.assertThat((Object)shardPathContents, (Matcher)Matchers.hasKey((Object)String.format(Locale.ROOT, "snap-%s.dat", snapshotId.getUUID())));
                    Assert.assertThat((Object)shardPathContents.keySet().stream().filter(name -> name.startsWith("index-")).count(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
                }
            }
        }
    }

    public static long createDanglingIndex(BlobStoreRepository repository, String name, Set<String> files) throws InterruptedException, ExecutionException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        AtomicLong totalSize = new AtomicLong();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            BlobContainer container = blobStore.blobContainer(repository.basePath().add("indices").add(name));
            for (String file : files) {
                int size = ESTestCase.randomIntBetween(0, 10);
                totalSize.addAndGet(size);
                container.writeBlob(file, (InputStream)new ByteArrayInputStream(new byte[size]), (long)size, false);
            }
        }));
        future.get();
        return totalSize.get();
    }

    public static void assertCorruptionVisible(BlobStoreRepository repository, Map<String, Set<String>> indexToFiles) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            for (String index : indexToFiles.keySet()) {
                if (!blobStore.blobContainer(repository.basePath().add("indices")).children().containsKey(index)) {
                    return false;
                }
                for (String file : (Set)indexToFiles.get(index)) {
                    try {
                        InputStream ignored = blobStore.blobContainer(repository.basePath().add("indices").add(index)).readBlob(file);
                        if (ignored == null) continue;
                        ignored.close();
                    }
                    catch (NoSuchFileException e) {
                        return false;
                    }
                }
            }
            return true;
        }));
        Assert.assertTrue((boolean)((Boolean)future.actionGet()));
    }

    public static void assertBlobsByPrefix(BlobStoreRepository repository, BlobPath path, String prefix, Map<String, BlobMetaData> blobs) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).listBlobsByPrefix(prefix)));
        Map foundBlobs = (Map)future.actionGet();
        if (blobs.isEmpty()) {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.empty());
        } else {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])blobs.keySet().toArray(Strings.EMPTY_ARRAY)));
            for (Map.Entry entry : foundBlobs.entrySet()) {
                Assert.assertEquals((long)((BlobMetaData)entry.getValue()).length(), (long)blobs.get(entry.getKey()).length());
            }
        }
    }
}

