/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.repositories.blobstore.BlobStoreTestUtil;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class ESBlobStoreRepositoryIntegTestCase
extends ESIntegTestCase {
    protected abstract String repositoryType();

    protected Settings repositorySettings() {
        return Settings.builder().put("compress", ESBlobStoreRepositoryIntegTestCase.randomBoolean()).build();
    }

    protected final String createRepository(String name) {
        return this.createRepository(name, this.repositorySettings());
    }

    protected final String createRepository(String name, Settings settings) {
        boolean verify = ESBlobStoreRepositoryIntegTestCase.randomBoolean();
        this.logger.debug("-->  creating repository [name: {}, verify: {}, settings: {}]", (Object)name, (Object)verify, (Object)settings);
        ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().preparePutRepository(name).setType(this.repositoryType()).setVerify(verify).setSettings(settings));
        ESBlobStoreRepositoryIntegTestCase.internalCluster().getDataOrMasterNodeInstances(RepositoriesService.class).forEach(repositories -> {
            ESBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name), (Matcher)Matchers.notNullValue());
            ESBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name), (Matcher)Matchers.instanceOf(BlobStoreRepository.class));
            ESBlobStoreRepositoryIntegTestCase.assertThat((Object)repositories.repository(name).isReadOnly(), (Matcher)Matchers.is((Object)false));
            BlobStore blobStore = ((BlobStoreRepository)repositories.repository(name)).getBlobStore();
            ESBlobStoreRepositoryIntegTestCase.assertThat((String)"blob store has to be lazy initialized", (Object)blobStore, (Matcher)(verify ? Matchers.is((Matcher)Matchers.notNullValue()) : Matchers.is((Matcher)Matchers.nullValue())));
        });
        return name;
    }

    public void testSnapshotAndRestore() throws Exception {
        String repoName = this.createRepository(ESBlobStoreRepositoryIntegTestCase.randomName());
        int indexCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 5);
        int[] docCounts = new int[indexCount];
        String[] indexNames = this.generateRandomNames(indexCount);
        for (int i = 0; i < indexCount; ++i) {
            docCounts[i] = ESBlobStoreRepositoryIntegTestCase.iterations(10, 1000);
            this.logger.info("-->  create random index {} with {} records", (Object)indexNames[i], (Object)docCounts[i]);
            this.addRandomDocuments(indexNames[i], docCounts[i]);
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexNames[i]}).setSize(0).get(), docCounts[i]);
        }
        String snapshotName = ESBlobStoreRepositoryIntegTestCase.randomName();
        this.logger.info("-->  create snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshotName).setWaitForCompletion(true).setIndices(indexNames));
        List<String> deleteIndices = ESBlobStoreRepositoryIntegTestCase.randomSubsetOf(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, indexCount), indexNames);
        if (deleteIndices.size() > 0) {
            this.logger.info("-->  delete indices {}", deleteIndices);
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareDelete(deleteIndices.toArray(new String[deleteIndices.size()])));
        }
        HashSet<String> closeIndices = new HashSet<String>(Arrays.asList(indexNames));
        closeIndices.removeAll(deleteIndices);
        if (closeIndices.size() > 0) {
            for (String index : closeIndices) {
                if (ESBlobStoreRepositoryIntegTestCase.randomBoolean()) {
                    this.logger.info("--> add random documents to {}", (Object)index);
                    this.addRandomDocuments(index, ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000));
                    continue;
                }
                int docCount = (int)((SearchResponse)ESBlobStoreRepositoryIntegTestCase.client().prepareSearch((String[])new String[]{index}).setSize((int)0).get()).getHits().getTotalHits().value;
                int deleteCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, docCount);
                this.logger.info("--> delete {} random documents from {}", (Object)deleteCount, (Object)index);
                for (int i = 0; i < deleteCount; ++i) {
                    int doc = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, docCount - 1);
                    ESBlobStoreRepositoryIntegTestCase.client().prepareDelete(index, index, Integer.toString(doc)).get();
                }
                ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{index}).get();
            }
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close indices {}", closeIndices);
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(closeIndices.toArray(new String[closeIndices.size()])));
        }
        this.logger.info("--> restore all indices from the snapshot");
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName).setWaitForCompletion(true));
        this.ensureGreen(new String[0]);
        for (int i = 0; i < indexCount; ++i) {
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexNames[i]}).setSize(0).get(), docCounts[i]);
        }
        this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)snapshotName);
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, snapshotName).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareGetSnapshots(repoName).setSnapshots(new String[]{snapshotName}).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotMissingException.class, () -> ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, snapshotName).get());
        ESBlobStoreRepositoryIntegTestCase.expectThrows(SnapshotRestoreException.class, () -> ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName).setWaitForCompletion(ESBlobStoreRepositoryIntegTestCase.randomBoolean()).get());
    }

    public void testMultipleSnapshotAndRollback() throws Exception {
        int i;
        String repoName = this.createRepository(ESBlobStoreRepositoryIntegTestCase.randomName());
        int iterationCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(2, 5);
        int[] docCounts = new int[iterationCount];
        String indexName = ESBlobStoreRepositoryIntegTestCase.randomName();
        String snapshotName = ESBlobStoreRepositoryIntegTestCase.randomName();
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareCreate(indexName).get());
        for (int i2 = 0; i2 < iterationCount; ++i2) {
            int docCount;
            if (ESBlobStoreRepositoryIntegTestCase.randomBoolean() && i2 > 0) {
                docCount = docCounts[i2 - 1];
                if (docCount > 0) {
                    int deleteCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, docCount);
                    this.logger.info("--> delete {} random documents from {}", (Object)deleteCount, (Object)indexName);
                    for (int j = 0; j < deleteCount; ++j) {
                        int doc = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, docCount - 1);
                        ESBlobStoreRepositoryIntegTestCase.client().prepareDelete(indexName, indexName, Integer.toString(doc)).get();
                    }
                    ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareRefresh(new String[]{indexName}).get();
                }
            } else {
                docCount = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(10, 1000);
                this.logger.info("--> add {} random documents to {}", (Object)docCount, (Object)indexName);
                this.addRandomDocuments(indexName, docCount);
            }
            docCounts[i2] = (int)((SearchResponse)ESBlobStoreRepositoryIntegTestCase.client().prepareSearch((String[])new String[]{indexName}).setSize((int)0).get()).getHits().getTotalHits().value;
            this.logger.info("-->  create snapshot {}:{} with {} documents", (Object)repoName, (Object)(snapshotName + "-" + i2), (Object)docCounts[i2]);
            ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareCreateSnapshot(repoName, snapshotName + "-" + i2).setWaitForCompletion(true).setIndices(new String[]{indexName}));
        }
        int restoreOperations = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 3);
        for (i = 0; i < restoreOperations; ++i) {
            int iterationToRestore = ESBlobStoreRepositoryIntegTestCase.randomIntBetween(0, iterationCount - 1);
            this.logger.info("-->  performing restore of the iteration {}", (Object)iterationToRestore);
            this.ensureGreen(new String[0]);
            this.logger.info("-->  close index");
            ElasticsearchAssertions.assertAcked(ESBlobStoreRepositoryIntegTestCase.client().admin().indices().prepareClose(new String[]{indexName}));
            this.logger.info("--> restore index from the snapshot");
            ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareRestoreSnapshot(repoName, snapshotName + "-" + iterationToRestore).setWaitForCompletion(true));
            this.ensureGreen(new String[0]);
            ElasticsearchAssertions.assertHitCount((SearchResponse)ESBlobStoreRepositoryIntegTestCase.client().prepareSearch(new String[]{indexName}).setSize(0).get(), docCounts[iterationToRestore]);
        }
        for (i = 0; i < iterationCount; ++i) {
            this.logger.info("-->  delete snapshot {}:{}", (Object)repoName, (Object)(snapshotName + "-" + i));
            ElasticsearchAssertions.assertAcked((AcknowledgedResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, snapshotName + "-" + i).get());
        }
    }

    public void testIndicesDeletedFromRepository() throws Exception {
        String repoName = this.createRepository("test-repo");
        Client client = ESBlobStoreRepositoryIntegTestCase.client();
        this.createIndex("test-idx-1", "test-idx-2", "test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 20; ++i) {
            this.index("test-idx-1", "doc", Integer.toString(i), "foo", "bar" + i);
            this.index("test-idx-2", "doc", Integer.toString(i), "foo", "baz" + i);
            this.index("test-idx-3", "doc", Integer.toString(i), "foo", "baz" + i);
        }
        this.refresh(new String[0]);
        this.logger.info("--> take a snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(repoName, "test-snap").setWaitForCompletion(true).get();
        ESBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> indexing more data");
        for (int i = 20; i < 40; ++i) {
            this.index("test-idx-1", "doc", Integer.toString(i), "foo", "bar" + i);
            this.index("test-idx-2", "doc", Integer.toString(i), "foo", "baz" + i);
            this.index("test-idx-3", "doc", Integer.toString(i), "foo", "baz" + i);
        }
        this.logger.info("--> take another snapshot with only 2 of the 3 indices");
        createSnapshotResponse = (CreateSnapshotResponse)client.admin().cluster().prepareCreateSnapshot(repoName, "test-snap2").setWaitForCompletion(true).setIndices(new String[]{"test-idx-1", "test-idx-2"}).get();
        ESBlobStoreRepositoryIntegTestCase.assertEquals((long)createSnapshotResponse.getSnapshotInfo().successfulShards(), (long)createSnapshotResponse.getSnapshotInfo().totalShards());
        this.logger.info("--> delete a snapshot");
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, "test-snap").get());
        this.logger.info("--> verify index folder deleted from blob container");
        RepositoriesService repositoriesSvc = ESBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(RepositoriesService.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getMasterName());
        ThreadPool threadPool = ESBlobStoreRepositoryIntegTestCase.internalCluster().getInstance(ThreadPool.class, ESBlobStoreRepositoryIntegTestCase.internalCluster().getMasterName());
        BlobStoreRepository repository = (BlobStoreRepository)repositoriesSvc.repository(repoName);
        SetOnce indicesBlobContainer = new SetOnce();
        SetOnce repositoryData = new SetOnce();
        CountDownLatch latch = new CountDownLatch(1);
        threadPool.executor("snapshot").execute(() -> {
            indicesBlobContainer.set((Object)repository.blobStore().blobContainer(repository.basePath().add("indices")));
            repositoryData.set((Object)repository.getRepositoryData());
            latch.countDown();
        });
        latch.await();
        for (IndexId indexId : ((RepositoryData)repositoryData.get()).getIndices().values()) {
            if (!indexId.getName().equals("test-idx-3")) continue;
            ESBlobStoreRepositoryIntegTestCase.assertFalse((boolean)BlobStoreTestUtil.blobExists((BlobContainer)indicesBlobContainer.get(), indexId.getId()));
        }
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)ESBlobStoreRepositoryIntegTestCase.client().admin().cluster().prepareDeleteSnapshot(repoName, "test-snap2").get());
    }

    protected void addRandomDocuments(String name, int numDocs) throws InterruptedException {
        IndexRequestBuilder[] indexRequestBuilders = new IndexRequestBuilder[numDocs];
        for (int i = 0; i < numDocs; ++i) {
            indexRequestBuilders[i] = ESBlobStoreRepositoryIntegTestCase.client().prepareIndex(name, name, Integer.toString(i)).setRouting(ESBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 10))).setSource(new Object[]{"field", "value"});
        }
        this.indexRandom(true, indexRequestBuilders);
    }

    private String[] generateRandomNames(int num) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < num; ++i) {
            String name;
            while (names.contains(name = ESBlobStoreRepositoryIntegTestCase.randomName())) {
            }
            names.add(name);
        }
        return names.toArray(new String[num]);
    }

    protected static void assertSuccessfulSnapshot(CreateSnapshotRequestBuilder requestBuilder) {
        CreateSnapshotResponse response = (CreateSnapshotResponse)requestBuilder.get();
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulSnapshot(response);
    }

    private static void assertSuccessfulSnapshot(CreateSnapshotResponse response) {
        ESBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ESBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)response.getSnapshotInfo().totalShards()));
    }

    protected static void assertSuccessfulRestore(RestoreSnapshotRequestBuilder requestBuilder) {
        RestoreSnapshotResponse response = (RestoreSnapshotResponse)requestBuilder.get();
        ESBlobStoreRepositoryIntegTestCase.assertSuccessfulRestore(response);
    }

    private static void assertSuccessfulRestore(RestoreSnapshotResponse response) {
        ESBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getRestoreInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ESBlobStoreRepositoryIntegTestCase.assertThat((Object)response.getRestoreInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)response.getRestoreInfo().totalShards()));
    }

    protected static String randomName() {
        return ESBlobStoreRepositoryIntegTestCase.randomAlphaOfLength(ESBlobStoreRepositoryIntegTestCase.randomIntBetween(1, 10)).toLowerCase(Locale.ROOT);
    }
}

