/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.index.query.IntervalFilterScript;
import org.elasticsearch.index.similarity.ScriptedSimilarity;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.BucketAggregationScript;
import org.elasticsearch.script.BucketAggregationSelectorScript;
import org.elasticsearch.script.FieldScript;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.IngestConditionalScript;
import org.elasticsearch.script.IngestScript;
import org.elasticsearch.script.NumberSortScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.ScriptedMetricAggContexts;
import org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import org.elasticsearch.script.SimilarityScript;
import org.elasticsearch.script.SimilarityWeightScript;
import org.elasticsearch.script.StringSortScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.TermsSetQueryScript;
import org.elasticsearch.script.UpdateScript;
import org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class MockScriptEngine
implements ScriptEngine {
    public static final String NAME = "mockscript";
    private final String type;
    private final Map<String, Function<Map<String, Object>, Object>> scripts;
    private final Map<ScriptContext<?>, ContextCompiler> contexts;

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> scripts, Map<ScriptContext<?>, ContextCompiler> contexts) {
        this.type = type;
        this.scripts = Collections.unmodifiableMap(scripts);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public MockScriptEngine() {
        this(NAME, Collections.emptyMap(), Collections.emptyMap());
    }

    public String getType() {
        return this.type;
    }

    public <T> T compile(String name, String source, ScriptContext<T> context, Map<String, String> params) {
        final Function<Map<String, Object>, Object> script = this.scripts.get(source);
        if (script == null) {
            throw new IllegalArgumentException("No pre defined script matching [" + source + "] for script with name [" + name + "], did you declare the mocked script?");
        }
        MockCompiledScript mockCompiled = new MockCompiledScript(name, params, source, script);
        if (context.instanceClazz.equals(FieldScript.class)) {
            FieldScript.Factory factory = (parameters, lookup) -> ctx -> new FieldScript(parameters, lookup, ctx){

                public Object execute() {
                    Map vars = MockScriptEngine.this.createVars(parameters);
                    vars.putAll(this.getLeafLookup().asMap());
                    return script.apply(vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(FieldScript.class)) {
            FieldScript.Factory factory = (parameters, lookup) -> ctx -> new FieldScript(parameters, lookup, ctx){

                public Object execute() {
                    Map vars = MockScriptEngine.this.createVars(parameters);
                    vars.putAll(this.getLeafLookup().asMap());
                    return script.apply(vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(TermsSetQueryScript.class)) {
            TermsSetQueryScript.Factory factory = (parameters, lookup) -> ctx -> new TermsSetQueryScript(parameters, lookup, ctx){

                public Number execute() {
                    HashMap<String, Map> vars = new HashMap<String, Map>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return (Number)script.apply(vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(NumberSortScript.class)) {
            NumberSortScript.Factory factory = (parameters, lookup) -> new NumberSortScript.LeafFactory(){

                public NumberSortScript newInstance(LeafReaderContext ctx) {
                    return new NumberSortScript(parameters, lookup, ctx){

                        public double execute() {
                            HashMap<String, Map> vars = new HashMap<String, Map>(parameters);
                            vars.put("params", parameters);
                            vars.put("doc", this.getDoc());
                            return ((Number)script.apply(vars)).doubleValue();
                        }
                    };
                }

                public boolean needs_score() {
                    return false;
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(StringSortScript.class)) {
            StringSortScript.Factory factory = (parameters, lookup) -> ctx -> new StringSortScript(parameters, lookup, ctx){

                public String execute() {
                    HashMap<String, Map> vars = new HashMap<String, Map>(parameters);
                    vars.put("params", parameters);
                    vars.put("doc", this.getDoc());
                    return String.valueOf(script.apply(vars));
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IngestScript.class)) {
            IngestScript.Factory factory = vars -> new IngestScript(vars){

                public void execute(Map<String, Object> ctx) {
                    script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(AggregationScript.class)) {
            AggregationScript.Factory factory = (parameters, lookup) -> new AggregationScript.LeafFactory(){

                public AggregationScript newInstance(LeafReaderContext ctx) {
                    return new AggregationScript(parameters, lookup, ctx){

                        public Object execute() {
                            HashMap<String, Object> vars = new HashMap<String, Object>(parameters);
                            vars.put("params", parameters);
                            vars.put("doc", this.getDoc());
                            vars.put("_score", this.get_score());
                            vars.put("_value", this.get_value());
                            return script.apply(vars);
                        }
                    };
                }

                public boolean needs_score() {
                    return true;
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IngestScript.class)) {
            IngestScript.Factory factory = vars -> new IngestScript(vars){

                public void execute(Map<String, Object> ctx) {
                    script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IngestConditionalScript.class)) {
            IngestConditionalScript.Factory factory = parameters -> new IngestConditionalScript(parameters){

                public boolean execute(Map<String, Object> ctx) {
                    return (Boolean)script.apply(ctx);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(UpdateScript.class)) {
            UpdateScript.Factory factory = (parameters, ctx) -> new UpdateScript(parameters, ctx){

                public void execute() {
                    HashMap<String, Map> vars = new HashMap<String, Map>();
                    vars.put("ctx", ctx);
                    vars.put("params", parameters);
                    vars.putAll(parameters);
                    script.apply(vars);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationScript.class)) {
            BucketAggregationScript.Factory factory = parameters -> new BucketAggregationScript(parameters){

                public Double execute() {
                    Object ret = script.apply(this.getParams());
                    if (ret == null) {
                        return null;
                    }
                    return ((Number)ret).doubleValue();
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationSelectorScript.class)) {
            BucketAggregationSelectorScript.Factory factory = parameters -> new BucketAggregationSelectorScript(parameters){

                public boolean execute() {
                    return (Boolean)script.apply(this.getParams());
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SignificantTermsHeuristicScoreScript.class)) {
            SignificantTermsHeuristicScoreScript.Factory factory = () -> new SignificantTermsHeuristicScoreScript(){

                public double execute(Map<String, Object> vars) {
                    return ((Number)script.apply(vars)).doubleValue();
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(TemplateScript.class)) {
            TemplateScript.Factory factory = vars -> {
                final HashMap<String, Map> varsWithParams = new HashMap<String, Map>();
                if (vars != null) {
                    varsWithParams.put("params", vars);
                }
                return new TemplateScript(vars){

                    public String execute() {
                        return (String)script.apply(varsWithParams);
                    }
                };
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(FilterScript.class)) {
            FilterScript.Factory factory = mockCompiled::createFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityScript.class)) {
            SimilarityScript.Factory factory = mockCompiled::createSimilarityScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityWeightScript.class)) {
            SimilarityWeightScript.Factory factory = mockCompiled::createSimilarityWeightScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(MovingFunctionScript.class)) {
            MovingFunctionScript.Factory factory = () -> new MovingFunctionScript(){

                public double execute(Map<String, Object> params1, double[] values) {
                    params1.put("_values", values);
                    return (Double)script.apply(params1);
                }
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScoreScript.class)) {
            MockScoreScript factory = new MockScoreScript(script);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.InitScript.class)) {
            ScriptedMetricAggContexts.InitScript.Factory factory = mockCompiled::createMetricAggInitScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.MapScript.class)) {
            ScriptedMetricAggContexts.MapScript.Factory factory = mockCompiled::createMetricAggMapScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.CombineScript.class)) {
            ScriptedMetricAggContexts.CombineScript.Factory factory = mockCompiled::createMetricAggCombineScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScriptedMetricAggContexts.ReduceScript.class)) {
            ScriptedMetricAggContexts.ReduceScript.Factory factory = mockCompiled::createMetricAggReduceScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(IntervalFilterScript.class)) {
            IntervalFilterScript.Factory factory = mockCompiled::createIntervalFilterScript;
            return context.factoryClazz.cast(factory);
        }
        ContextCompiler compiler = this.contexts.get(context);
        if (compiler != null) {
            return context.factoryClazz.cast(compiler.compile(script, params));
        }
        throw new IllegalArgumentException("mock script engine does not know how to handle context [" + context.name + "]");
    }

    private Map<String, Object> createVars(Map<String, Object> params) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("params", params);
        return vars;
    }

    public static Script mockInlineScript(String script) {
        return new Script(ScriptType.INLINE, "mock", script, Collections.emptyMap());
    }

    public class MockScoreScript
    implements ScoreScript.Factory {
        private final Function<Map<String, Object>, Object> script;

        public MockScoreScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public ScoreScript.LeafFactory newFactory(final Map<String, Object> params, final SearchLookup lookup) {
            return new ScoreScript.LeafFactory(){

                public boolean needs_score() {
                    return true;
                }

                public ScoreScript newInstance(LeafReaderContext ctx) throws IOException {
                    final Scorable[] scorerHolder = new Scorable[1];
                    return new ScoreScript(params, lookup, ctx){

                        public double execute(ScoreScript.ExplanationHolder explanation) {
                            HashMap<String, Object> vars = new HashMap<String, Object>(this.getParams());
                            vars.put("doc", this.getDoc());
                            if (scorerHolder[0] != null) {
                                vars.put("_score", new ScoreAccessor(scorerHolder[0]));
                            }
                            return ((Number)MockScoreScript.this.script.apply(vars)).doubleValue();
                        }

                        public void setScorer(Scorable scorer) {
                            scorerHolder[0] = scorer;
                        }
                    };
                }
            };
        }
    }

    public static class MockMetricAggReduceScript
    extends ScriptedMetricAggContexts.ReduceScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggReduceScript(Map<String, Object> params, List<Object> states, Function<Map<String, Object>, Object> script) {
            super(params, states);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("states", this.getStates());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggCombineScript
    extends ScriptedMetricAggContexts.CombineScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggCombineScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public Object execute() {
            HashMap<String, Map> map = new HashMap<String, Map>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            return this.script.apply(map);
        }
    }

    public static class MockMetricAggMapScript
    implements ScriptedMetricAggContexts.MapScript.LeafFactory {
        private final Map<String, Object> params;
        private final Map<String, Object> state;
        private final SearchLookup lookup;
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggMapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup, Function<Map<String, Object>, Object> script) {
            this.params = params;
            this.state = state;
            this.lookup = lookup;
            this.script = script;
        }

        public ScriptedMetricAggContexts.MapScript newInstance(LeafReaderContext context) {
            return new ScriptedMetricAggContexts.MapScript(this.params, this.state, this.lookup, context){

                public void execute() {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    if (this.getParams() != null) {
                        map.putAll(this.getParams());
                        map.put("params", this.getParams());
                    }
                    map.put("state", this.getState());
                    map.put("doc", this.getDoc());
                    map.put("_score", this.get_score());
                    script.apply(map);
                }
            };
        }
    }

    public static class MockMetricAggInitScript
    extends ScriptedMetricAggContexts.InitScript {
        private final Function<Map<String, Object>, Object> script;

        MockMetricAggInitScript(Map<String, Object> params, Map<String, Object> state, Function<Map<String, Object>, Object> script) {
            super(params, state);
            this.script = script;
        }

        public void execute() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.getParams() != null) {
                map.putAll(this.getParams());
                map.put("params", this.getParams());
            }
            map.put("state", this.getState());
            this.script.apply(map);
        }
    }

    public class MockSimilarityWeightScript
    extends SimilarityWeightScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityWeightScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("query", query);
            map.put("field", field);
            map.put("term", term);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public class MockSimilarityScript
    extends SimilarityScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(double weight, ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term, ScriptedSimilarity.Doc doc) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("weight", weight);
            map.put("query", (Double)query);
            map.put("field", (Double)field);
            map.put("term", (Double)term);
            map.put("doc", (Double)doc);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public static class MockFilterScript
    implements FilterScript.LeafFactory {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockFilterScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public FilterScript newInstance(LeafReaderContext context) throws IOException {
            final LeafSearchLookup leafLookup = this.lookup.getLeafSearchLookup(context);
            final HashMap<String, Object> ctx = new HashMap<String, Object>(leafLookup.asMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            return new FilterScript(ctx, this.lookup, context){

                public boolean execute() {
                    return (Boolean)script.apply(ctx);
                }

                public void setDocument(int doc) {
                    leafLookup.setDocument(doc);
                }
            };
        }
    }

    public class MockCompiledScript {
        private final String name;
        private final String source;
        private final Map<String, String> options;
        private final Function<Map<String, Object>, Object> script;

        public MockCompiledScript(String name, Map<String, String> options, String source, Function<Map<String, Object>, Object> script) {
            this.name = name;
            this.source = source;
            this.options = options;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public FilterScript.LeafFactory createFilterScript(Map<String, Object> params, SearchLookup lookup) {
            return new MockFilterScript(lookup, params, this.script);
        }

        public SimilarityScript createSimilarityScript() {
            return new MockSimilarityScript(this.script != null ? this.script : ctx -> 42.0);
        }

        public SimilarityWeightScript createSimilarityWeightScript() {
            return new MockSimilarityWeightScript(this.script != null ? this.script : ctx -> 42.0);
        }

        public ScriptedMetricAggContexts.InitScript createMetricAggInitScript(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggInitScript(params, state, this.script != null ? this.script : ctx -> 42.0);
        }

        public ScriptedMetricAggContexts.MapScript.LeafFactory createMetricAggMapScript(Map<String, Object> params, Map<String, Object> state, SearchLookup lookup) {
            return new MockMetricAggMapScript(params, state, lookup, this.script != null ? this.script : ctx -> 42.0);
        }

        public ScriptedMetricAggContexts.CombineScript createMetricAggCombineScript(Map<String, Object> params, Map<String, Object> state) {
            return new MockMetricAggCombineScript(params, state, this.script != null ? this.script : ctx -> 42.0);
        }

        public ScriptedMetricAggContexts.ReduceScript createMetricAggReduceScript(Map<String, Object> params, List<Object> states) {
            return new MockMetricAggReduceScript(params, states, this.script != null ? this.script : ctx -> 42.0);
        }

        public IntervalFilterScript createIntervalFilterScript() {
            return new IntervalFilterScript(){

                public boolean execute(IntervalFilterScript.Interval interval) {
                    return false;
                }
            };
        }
    }

    public static interface ContextCompiler {
        public Object compile(Function<Map<String, Object>, Object> var1, Map<String, String> var2);
    }
}

