/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots.mockstore;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.snapshots.mockstore.BlobContainerWrapper;
import org.elasticsearch.snapshots.mockstore.BlobStoreWrapper;
import org.elasticsearch.threadpool.ThreadPool;

public class MockRepository
extends FsRepository {
    private static final Logger logger = LogManager.getLogger(MockRepository.class);
    private final AtomicLong failureCounter = new AtomicLong();
    private final double randomControlIOExceptionRate;
    private final double randomDataFileIOExceptionRate;
    private final boolean useLuceneCorruptionException;
    private final long maximumNumberOfFailures;
    private final long waitAfterUnblock;
    private final String randomPrefix;
    private volatile boolean blockOnControlFiles;
    private volatile boolean blockOnDataFiles;
    private volatile boolean blockOnWriteIndexFile;
    private volatile boolean blockAndFailOnWriteSnapFile;
    private volatile boolean blocked = false;

    public long getFailureCount() {
        return this.failureCounter.get();
    }

    public MockRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
        super(MockRepository.overrideSettings(metadata, environment), environment, namedXContentRegistry, threadPool);
        this.randomControlIOExceptionRate = metadata.settings().getAsDouble("random_control_io_exception_rate", Double.valueOf(0.0));
        this.randomDataFileIOExceptionRate = metadata.settings().getAsDouble("random_data_file_io_exception_rate", Double.valueOf(0.0));
        this.useLuceneCorruptionException = metadata.settings().getAsBoolean("use_lucene_corruption", Boolean.valueOf(false));
        this.maximumNumberOfFailures = metadata.settings().getAsLong("max_failure_number", Long.valueOf(100L));
        this.blockOnControlFiles = metadata.settings().getAsBoolean("block_on_control", Boolean.valueOf(false));
        this.blockOnDataFiles = metadata.settings().getAsBoolean("block_on_data", Boolean.valueOf(false));
        this.blockAndFailOnWriteSnapFile = metadata.settings().getAsBoolean("block_on_snap", Boolean.valueOf(false));
        this.randomPrefix = metadata.settings().get("random", "default");
        this.waitAfterUnblock = metadata.settings().getAsLong("wait_after_unblock", Long.valueOf(0L));
        logger.info("starting mock repository with random prefix {}", (Object)this.randomPrefix);
    }

    private static RepositoryMetaData overrideSettings(RepositoryMetaData metadata, Environment environment) {
        if (metadata.settings().getAsBoolean("localize_location", Boolean.valueOf(false)).booleanValue()) {
            Path location = PathUtils.get((String)metadata.settings().get("location"), (String[])new String[0]);
            location = location.resolve(Integer.toString(environment.hashCode()));
            return new RepositoryMetaData(metadata.name(), metadata.type(), Settings.builder().put(metadata.settings()).put("location", location.toAbsolutePath()).build());
        }
        return metadata;
    }

    private long incrementAndGetFailureCount() {
        return this.failureCounter.incrementAndGet();
    }

    protected void doStop() {
        this.unblock();
        super.doStop();
    }

    protected BlobStore createBlobStore() throws Exception {
        return new MockBlobStore(super.createBlobStore());
    }

    public synchronized void unblock() {
        this.blocked = false;
        this.blockOnDataFiles = false;
        this.blockOnControlFiles = false;
        this.blockOnWriteIndexFile = false;
        this.blockAndFailOnWriteSnapFile = false;
        ((Object)((Object)this)).notifyAll();
    }

    public void blockOnDataFiles(boolean blocked) {
        this.blockOnDataFiles = blocked;
    }

    public void setBlockAndFailOnWriteSnapFiles(boolean blocked) {
        this.blockAndFailOnWriteSnapFile = blocked;
    }

    public void setBlockOnWriteIndexFile(boolean blocked) {
        this.blockOnWriteIndexFile = blocked;
    }

    public boolean blocked() {
        return this.blocked;
    }

    private synchronized boolean blockExecution() {
        logger.debug("[{}] Blocking execution", (Object)this.metadata.name());
        boolean wasBlocked = false;
        try {
            while (this.blockOnDataFiles || this.blockOnControlFiles || this.blockOnWriteIndexFile || this.blockAndFailOnWriteSnapFile) {
                this.blocked = true;
                ((Object)((Object)this)).wait();
                wasBlocked = true;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        logger.debug("[{}] Unblocking execution", (Object)this.metadata.name());
        return wasBlocked;
    }

    public class MockBlobStore
    extends BlobStoreWrapper {
        ConcurrentMap<String, AtomicLong> accessCounts;

        private long incrementAndGet(String path) {
            AtomicLong value = (AtomicLong)this.accessCounts.get(path);
            if (value == null) {
                value = this.accessCounts.putIfAbsent(path, new AtomicLong(1L));
            }
            if (value != null) {
                return value.incrementAndGet();
            }
            return 1L;
        }

        public MockBlobStore(BlobStore delegate) {
            super(delegate);
            this.accessCounts = new ConcurrentHashMap<String, AtomicLong>();
        }

        @Override
        public BlobContainer blobContainer(BlobPath path) {
            return new MockBlobContainer(super.blobContainer(path));
        }

        private class MockBlobContainer
        extends BlobContainerWrapper {
            private MessageDigest digest;

            private boolean shouldFail(String blobName, double probability) {
                if (probability > 0.0) {
                    String path = this.path().add(blobName).buildAsString() + MockRepository.this.randomPrefix;
                    path = path + "/" + MockBlobStore.this.incrementAndGet(path);
                    logger.info("checking [{}] [{}]", (Object)path, (Object)((double)Math.abs(this.hashCode(path)) < 2.147483647E9 * probability ? 1 : 0));
                    return (double)Math.abs(this.hashCode(path)) < 2.147483647E9 * probability;
                }
                return false;
            }

            private int hashCode(String path) {
                try {
                    this.digest = MessageDigest.getInstance("MD5");
                    byte[] bytes = this.digest.digest(path.getBytes("UTF-8"));
                    int i = 0;
                    return (bytes[i++] & 0xFF) << 24 | (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
                }
                catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
                    throw new ElasticsearchException("cannot calculate hashcode", (Throwable)ex, new Object[0]);
                }
            }

            private void maybeIOExceptionOrBlock(String blobName) throws IOException {
                if (blobName.startsWith("__")) {
                    if (this.shouldFail(blobName, MockRepository.this.randomDataFileIOExceptionRate) && MockRepository.this.incrementAndGetFailureCount() < MockRepository.this.maximumNumberOfFailures) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        if (MockRepository.this.useLuceneCorruptionException) {
                            throw new CorruptIndexException("Random corruption", "random file");
                        }
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnDataFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    }
                } else {
                    if (this.shouldFail(blobName, MockRepository.this.randomControlIOExceptionRate) && MockRepository.this.incrementAndGetFailureCount() < MockRepository.this.maximumNumberOfFailures) {
                        logger.info("throwing random IOException for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                        throw new IOException("Random IOException");
                    }
                    if (MockRepository.this.blockOnControlFiles) {
                        this.blockExecutionAndMaybeWait(blobName);
                    } else if (blobName.startsWith("snap-") && MockRepository.this.blockAndFailOnWriteSnapFile) {
                        this.blockExecutionAndFail(blobName);
                    }
                }
            }

            private void blockExecutionAndMaybeWait(String blobName) {
                logger.info("[{}] blocking I/O operation for file [{}] at path [{}]", (Object)MockRepository.this.metadata.name(), (Object)blobName, (Object)this.path());
                if (MockRepository.this.blockExecution() && MockRepository.this.waitAfterUnblock > 0L) {
                    try {
                        Thread.sleep(MockRepository.this.waitAfterUnblock);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void blockExecutionAndFail(String blobName) throws IOException {
                logger.info("blocking I/O operation for file [{}] at path [{}]", (Object)blobName, (Object)this.path());
                MockRepository.this.blockExecution();
                throw new IOException("exception after block");
            }

            MockBlobContainer(BlobContainer delegate) {
                super(delegate);
            }

            @Override
            public InputStream readBlob(String name) throws IOException {
                this.maybeIOExceptionOrBlock(name);
                return super.readBlob(name);
            }

            @Override
            public void deleteBlob(String blobName) throws IOException {
                this.maybeIOExceptionOrBlock(blobName);
                super.deleteBlob(blobName);
            }

            @Override
            public void deleteBlobIgnoringIfNotExists(String blobName) throws IOException {
                this.maybeIOExceptionOrBlock(blobName);
                super.deleteBlobIgnoringIfNotExists(blobName);
            }

            @Override
            public DeleteResult delete() throws IOException {
                DeleteResult deleteResult = DeleteResult.ZERO;
                for (BlobContainer child : this.children().values()) {
                    deleteResult = deleteResult.add(child.delete());
                }
                Map<String, BlobMetaData> blobs = this.listBlobs();
                long deleteBlobCount = blobs.size();
                long deleteByteCount = 0L;
                for (String blob : blobs.values().stream().map(BlobMetaData::name).collect(Collectors.toList())) {
                    this.deleteBlobIgnoringIfNotExists(blob);
                    deleteByteCount += blobs.get(blob).length();
                }
                MockRepository.this.blobStore().blobContainer(this.path().parent()).deleteBlob(this.path().toArray()[this.path().toArray().length - 1]);
                return deleteResult.add(deleteBlobCount, deleteByteCount);
            }

            @Override
            public Map<String, BlobMetaData> listBlobs() throws IOException {
                this.maybeIOExceptionOrBlock("");
                return super.listBlobs();
            }

            @Override
            public Map<String, BlobContainer> children() throws IOException {
                HashMap<String, BlobContainer> res = new HashMap<String, BlobContainer>();
                for (Map.Entry<String, BlobContainer> entry : super.children().entrySet()) {
                    res.put(entry.getKey(), new MockBlobContainer(entry.getValue()));
                }
                return res;
            }

            @Override
            public Map<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
                this.maybeIOExceptionOrBlock(blobNamePrefix);
                return super.listBlobsByPrefix(blobNamePrefix);
            }

            @Override
            public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
                this.maybeIOExceptionOrBlock(blobName);
                super.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
                if (RandomizedContext.current().getRandom().nextBoolean()) {
                    this.maybeIOExceptionOrBlock(blobName);
                }
            }

            @Override
            public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
                Random random = RandomizedContext.current().getRandom();
                if (blobName.startsWith("index-") && MockRepository.this.blockOnWriteIndexFile) {
                    this.blockExecutionAndFail(blobName);
                }
                if (MockBlobStore.this.delegate() instanceof FsBlobContainer && random.nextBoolean()) {
                    String tempBlobName = FsBlobContainer.tempBlobName((String)blobName);
                    super.writeBlob(tempBlobName, inputStream, blobSize, failIfAlreadyExists);
                    this.maybeIOExceptionOrBlock(blobName);
                    FsBlobContainer fsBlobContainer = (FsBlobContainer)MockBlobStore.this.delegate();
                    fsBlobContainer.moveBlobAtomic(tempBlobName, blobName, failIfAlreadyExists);
                } else {
                    this.maybeIOExceptionOrBlock(blobName);
                    super.writeBlobAtomic(blobName, inputStream, blobSize, failIfAlreadyExists);
                }
            }
        }
    }

    public static class Plugin
    extends org.elasticsearch.plugins.Plugin
    implements RepositoryPlugin {
        public static final Setting<String> USERNAME_SETTING = Setting.simpleString((String)"secret.mock.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> PASSWORD_SETTING = Setting.simpleString((String)"secret.mock.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});

        public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ThreadPool threadPool) {
            return Collections.singletonMap("mock", metadata -> new MockRepository(metadata, env, namedXContentRegistry, threadPool));
        }

        public List<Setting<?>> getSettings() {
            return Arrays.asList(USERNAME_SETTING, PASSWORD_SETTING);
        }
    }
}

