/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;

public abstract class AbstractWireTestCase<T>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    protected abstract T createTestInstance();

    protected abstract Writeable.Reader<T> instanceReader();

    protected T mutateInstance(T instance) throws IOException {
        return null;
    }

    public final void testEqualsAndHashcode() {
        for (int runs = 0; runs < 20; ++runs) {
            EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestInstance(), this::copyInstance, this::mutateInstance);
        }
    }

    public final void testSerialization() throws IOException {
        for (int runs = 0; runs < 20; ++runs) {
            T testInstance = this.createTestInstance();
            this.assertSerialization(testInstance);
        }
    }

    protected final T assertSerialization(T testInstance) throws IOException {
        return this.assertSerialization(testInstance, Version.CURRENT);
    }

    protected final T assertSerialization(T testInstance, Version version) throws IOException {
        T deserializedInstance = this.copyInstance(testInstance, version);
        this.assertEqualInstances(testInstance, deserializedInstance);
        return deserializedInstance;
    }

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        AbstractWireTestCase.assertNotSame(newInstance, expectedInstance);
        AbstractWireTestCase.assertEquals(expectedInstance, newInstance);
        AbstractWireTestCase.assertEquals((long)expectedInstance.hashCode(), (long)newInstance.hashCode());
    }

    protected final T copyInstance(T instance) throws IOException {
        return this.copyInstance(instance, Version.CURRENT);
    }

    protected abstract T copyInstance(T var1, Version var2) throws IOException;

    protected NamedWriteableRegistry getNamedWriteableRegistry() {
        return new NamedWriteableRegistry(Collections.emptyList());
    }
}

