/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class FakeRestRequest
extends RestRequest {
    public FakeRestRequest() {
        this(NamedXContentRegistry.EMPTY, new FakeHttpRequest(RestRequest.Method.GET, "", (BytesReference)BytesArray.EMPTY, new HashMap()), new HashMap<String, String>(), new FakeHttpChannel(null));
    }

    private FakeRestRequest(NamedXContentRegistry xContentRegistry, HttpRequest httpRequest, Map<String, String> params, HttpChannel httpChannel) {
        super(xContentRegistry, params, httpRequest.uri(), httpRequest.getHeaders(), httpRequest, httpChannel);
    }

    public static class Builder {
        private final NamedXContentRegistry xContentRegistry;
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Map<String, String> params = new HashMap<String, String>();
        private BytesReference content = BytesArray.EMPTY;
        private String path = "/";
        private RestRequest.Method method = RestRequest.Method.GET;
        private InetSocketAddress address = null;

        public Builder(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
        }

        public Builder withHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder withContent(BytesReference content, XContentType xContentType) {
            this.content = content;
            if (xContentType != null) {
                this.headers.put("Content-Type", Collections.singletonList(xContentType.mediaType()));
            }
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder withRemoteAddress(InetSocketAddress address) {
            this.address = address;
            return this;
        }

        public FakeRestRequest build() {
            FakeHttpRequest fakeHttpRequest = new FakeHttpRequest(this.method, this.path, this.content, this.headers);
            return new FakeRestRequest(this.xContentRegistry, fakeHttpRequest, this.params, new FakeHttpChannel(this.address));
        }
    }

    private static class FakeHttpChannel
    implements HttpChannel {
        private final InetSocketAddress remoteAddress;

        private FakeHttpChannel(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public void addCloseListener(ActionListener<Void> listener) {
        }

        public boolean isOpen() {
            return true;
        }

        public void close() {
        }
    }

    private static class FakeHttpRequest
    implements HttpRequest {
        private final RestRequest.Method method;
        private final String uri;
        private final BytesReference content;
        private final Map<String, List<String>> headers;

        private FakeHttpRequest(RestRequest.Method method, String uri, BytesReference content, Map<String, List<String>> headers) {
            this.method = method;
            this.uri = uri;
            this.content = content;
            this.headers = headers;
        }

        public RestRequest.Method method() {
            return this.method;
        }

        public String uri() {
            return this.uri;
        }

        public BytesReference content() {
            return this.content;
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public List<String> strictCookies() {
            return Collections.emptyList();
        }

        public HttpRequest.HttpVersion protocolVersion() {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }

        public HttpRequest removeHeader(String header) {
            this.headers.remove(header);
            return this;
        }

        public HttpResponse createResponse(RestStatus status, BytesReference content) {
            final HashMap headers = new HashMap();
            return new HttpResponse(){

                public void addHeader(String name, String value) {
                    headers.put(name, value);
                }

                public boolean containsHeader(String name) {
                    return headers.containsKey(name);
                }
            };
        }
    }
}

