/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningsHandler;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponseException;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;

public class ClientYamlTestClient
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ClientYamlTestClient.class);
    private static final ContentType YAML_CONTENT_TYPE = ContentType.create((String)"application/yaml");
    private final ClientYamlSuiteRestSpec restSpec;
    private final Map<NodeSelector, RestClient> restClients = new HashMap<NodeSelector, RestClient>();
    private final Version esVersion;
    private final Version masterVersion;
    private final CheckedSupplier<RestClientBuilder, IOException> clientBuilderWithSniffedNodes;

    ClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts, Version esVersion, Version masterVersion, CheckedSupplier<RestClientBuilder, IOException> clientBuilderWithSniffedNodes) {
        assert (hosts.size() > 0);
        this.restSpec = restSpec;
        this.restClients.put(NodeSelector.ANY, restClient);
        this.esVersion = esVersion;
        this.masterVersion = masterVersion;
        this.clientBuilderWithSniffedNodes = clientBuilderWithSniffedNodes;
    }

    public Version getEsVersion() {
        return this.esVersion;
    }

    public Version getMasterVersion() {
        return this.masterVersion;
    }

    public ClientYamlTestResponse callApi(String apiName, Map<String, String> params, HttpEntity entity, Map<String, String> headers, NodeSelector nodeSelector) throws IOException {
        String requestMethod;
        ClientYamlSuiteRestApi restApi = this.restApi(apiName);
        Set apiRequiredParameters = restApi.getParams().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        List<ClientYamlSuiteRestApi.Path> bestPaths = restApi.getBestMatchingPaths(params.keySet());
        ClientYamlSuiteRestApi.Path path = (ClientYamlSuiteRestApi.Path)RandomizedTest.randomFrom(bestPaths);
        HashMap<String, String> pathParts = new HashMap<String, String>();
        HashMap<String, String> queryStringParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (path.getParts().contains(entry.getKey())) {
                pathParts.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (restApi.getParams().containsKey(entry.getKey()) || this.restSpec.isGlobalParameter(entry.getKey()) || this.restSpec.isClientParameter(entry.getKey())) {
                queryStringParams.put(entry.getKey(), entry.getValue());
                apiRequiredParameters.remove(entry.getKey());
                continue;
            }
            throw new IllegalArgumentException("path/param [" + entry.getKey() + "] not supported by [" + restApi.getName() + "] api");
        }
        if (!apiRequiredParameters.isEmpty()) {
            throw new IllegalArgumentException("missing required parameter: " + apiRequiredParameters + " by [" + restApi.getName() + "] api");
        }
        Set partNames = pathParts.keySet();
        if (path.getParts().size() != partNames.size() || !path.getParts().containsAll(partNames)) {
            throw new IllegalStateException("provided path parts don't match the best matching path: " + path.getParts() + " - " + partNames);
        }
        String finalPath = path.getPath();
        for (Map.Entry pathPart : pathParts.entrySet()) {
            try {
                URI uri = new URI(null, null, null, -1, "/" + (String)pathPart.getValue(), null, null);
                String encodedPathPart = uri.getRawPath().substring(1).replaceAll("/", "%2F");
                finalPath = finalPath.replace("{" + (String)pathPart.getKey() + "}", encodedPathPart);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("unable to build uri", e);
            }
        }
        List<String> supportedMethods = Arrays.asList(path.getMethods());
        if (entity != null) {
            if (!restApi.isBodySupported()) {
                throw new IllegalArgumentException("body is not supported by [" + restApi.getName() + "] api");
            }
            String contentType = entity.getContentType().getValue();
            if (ClientYamlTestClient.sendBodyAsSourceParam(supportedMethods, contentType, entity.getContentLength())) {
                logger.debug("sending the request body as source param with GET method");
                queryStringParams.put("source", EntityUtils.toString((HttpEntity)entity));
                queryStringParams.put("source_content_type", contentType);
                requestMethod = "GET";
                entity = null;
            } else {
                requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
            }
        } else {
            if (restApi.isBodyRequired()) {
                throw new IllegalArgumentException("body is required by [" + restApi.getName() + "] api");
            }
            requestMethod = (String)RandomizedTest.randomFrom(supportedMethods);
        }
        logger.debug("calling api [{}]", (Object)apiName);
        Request request = new Request(requestMethod, finalPath);
        for (Map.Entry param : queryStringParams.entrySet()) {
            request.addParameter((String)param.getKey(), (String)param.getValue());
        }
        request.setEntity(entity);
        ClientYamlTestClient.setOptions(request, headers);
        try {
            Response response = this.getRestClient(nodeSelector).performRequest(request);
            return new ClientYamlTestResponse(response);
        }
        catch (ResponseException e) {
            throw new ClientYamlTestResponseException(e);
        }
    }

    protected RestClient getRestClient(NodeSelector nodeSelector) {
        return this.restClients.computeIfAbsent(nodeSelector, selector -> {
            RestClientBuilder builder;
            try {
                builder = (RestClientBuilder)this.clientBuilderWithSniffedNodes.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            builder.setNodeSelector(selector);
            return builder.build();
        });
    }

    protected static void setOptions(Request request, Map<String, String> headers) {
        RequestOptions.Builder options = request.getOptions().toBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            logger.debug("Adding header {} with value {}", (Object)header.getKey(), (Object)header.getValue());
            options.addHeader(header.getKey(), header.getValue());
        }
        options.setWarningsHandler(WarningsHandler.PERMISSIVE);
        request.setOptions(options);
    }

    private static boolean sendBodyAsSourceParam(List<String> supportedMethods, String contentType, long contentLength) {
        if (!supportedMethods.contains("GET")) {
            return false;
        }
        if (contentLength < 0L) {
            return false;
        }
        if (contentLength > 2000L) {
            return false;
        }
        if (!contentType.startsWith(ContentType.APPLICATION_JSON.getMimeType()) && !contentType.startsWith(YAML_CONTENT_TYPE.getMimeType())) {
            return false;
        }
        return RandomizedTest.rarely();
    }

    private ClientYamlSuiteRestApi restApi(String apiName) {
        ClientYamlSuiteRestApi restApi = this.restSpec.getApi(apiName);
        if (restApi == null) {
            throw new IllegalArgumentException("rest api [" + apiName + "] doesn't exist in the rest spec");
        }
        return restApi;
    }

    @Override
    public void close() throws IOException {
        for (RestClient restClient : this.restClients.values()) {
            restClient.close();
        }
    }
}

