/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.BytesWriteHandler;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSelectorGroup;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.Page;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.nio.TestEventHandler;

public class MockNioTransport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(MockNioTransport.class);
    private final ConcurrentMap<String, MockTcpChannelFactory> profileToChannelFactory = ConcurrentCollections.newConcurrentMap();
    private final TransportThreadWatchdog transportThreadWatchdog;
    private volatile NioSelectorGroup nioGroup;
    private volatile MockTcpChannelFactory clientChannelFactory;

    public MockNioTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        this.transportThreadWatchdog = new TransportThreadWatchdog(threadPool, settings);
    }

    protected MockServerChannel bind(String name, InetSocketAddress address) throws IOException {
        MockTcpChannelFactory channelFactory = (MockTcpChannelFactory)((Object)this.profileToChannelFactory.get(name));
        MockServerChannel serverChannel = (MockServerChannel)this.nioGroup.bindServerChannel(address, (ChannelFactory)channelFactory);
        PlainActionFuture future = PlainActionFuture.newFuture();
        serverChannel.addBindListener(ActionListener.toBiConsumer((ActionListener)future));
        future.actionGet();
        return serverChannel;
    }

    protected MockSocketChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        return (MockSocketChannel)this.nioGroup.openChannel(address, (ChannelFactory)this.clientChannelFactory);
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.nioGroup = new NioSelectorGroup(EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"transport_worker"), 2, s -> new TestEventHandler(this::onNonChannelException, (Supplier<NioSelector>)s, this.transportThreadWatchdog));
            TcpTransport.ProfileSettings clientProfileSettings = new TcpTransport.ProfileSettings(this.settings, "default");
            this.clientChannelFactory = new MockTcpChannelFactory(true, clientProfileSettings, "client");
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    String profileName = profileSettings.profileName;
                    MockTcpChannelFactory factory = new MockTcpChannelFactory(false, profileSettings, profileName);
                    this.profileToChannelFactory.putIfAbsent(profileName, factory);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected void stopInternal() {
        try {
            this.transportThreadWatchdog.stop();
            this.nioGroup.close();
        }
        catch (Exception e) {
            logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
        this.profileToChannelFactory.clear();
    }

    protected ConnectionProfile maybeOverrideConnectionProfile(ConnectionProfile connectionProfile) {
        if (connectionProfile.getNumConnections() <= 3) {
            return connectionProfile;
        }
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        HashSet<TransportRequestOptions.Type> allTypesWithConnection = new HashSet<TransportRequestOptions.Type>();
        HashSet<TransportRequestOptions.Type> allTypesWithoutConnection = new HashSet<TransportRequestOptions.Type>();
        for (TransportRequestOptions.Type type : TransportRequestOptions.Type.values()) {
            int numConnections = connectionProfile.getNumConnectionsPerType(type);
            if (numConnections > 0) {
                allTypesWithConnection.add(type);
                continue;
            }
            allTypesWithoutConnection.add(type);
        }
        builder.addConnections(3, allTypesWithConnection.toArray(new TransportRequestOptions.Type[0]));
        if (!allTypesWithoutConnection.isEmpty()) {
            builder.addConnections(0, allTypesWithoutConnection.toArray(new TransportRequestOptions.Type[0]));
        }
        builder.setHandshakeTimeout(connectionProfile.getHandshakeTimeout());
        builder.setConnectTimeout(connectionProfile.getConnectTimeout());
        builder.setPingInterval(connectionProfile.getPingInterval());
        builder.setCompressionEnabled(connectionProfile.getCompressionEnabled().booleanValue());
        return builder.build();
    }

    private void onNonChannelException(Exception exception) {
        logger.warn((Message)new ParameterizedMessage("exception caught on transport layer [thread={}]", (Object)Thread.currentThread().getName()), (Throwable)exception);
    }

    private void exceptionCaught(NioSocketChannel channel, Exception exception) {
        this.onException((TcpChannel)channel, exception);
    }

    private void acceptChannel(NioSocketChannel channel) {
        this.serverAcceptedChannel((TcpChannel)channel);
    }

    static final class TransportThreadWatchdog {
        private static final TimeValue CHECK_INTERVAL = TimeValue.timeValueSeconds((long)2L);
        private final long warnThreshold;
        private final ThreadPool threadPool;
        private final ConcurrentHashMap<Thread, Long> registry = new ConcurrentHashMap();
        private volatile boolean stopped;

        TransportThreadWatchdog(ThreadPool threadPool, Settings settings) {
            this.threadPool = threadPool;
            this.warnThreshold = ((TimeValue)ThreadPool.ESTIMATED_TIME_INTERVAL_SETTING.get(settings)).nanos() + TimeValue.timeValueMillis((long)100L).nanos();
            threadPool.schedule(this::logLongRunningExecutions, CHECK_INTERVAL, "generic");
        }

        public boolean register() {
            Long previousValue = this.registry.put(Thread.currentThread(), this.threadPool.relativeTimeInNanos());
            return previousValue == null;
        }

        public void unregister() {
            Long previousValue = this.registry.remove(Thread.currentThread());
            assert (previousValue != null);
            this.maybeLogElapsedTime(previousValue);
        }

        private void maybeLogElapsedTime(long startTime) {
            long elapsedTime = this.threadPool.relativeTimeInNanos() - startTime;
            if (elapsedTime > this.warnThreshold) {
                logger.warn((Message)new ParameterizedMessage("Slow execution on network thread [{} milliseconds]", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedTime)), (Throwable)new RuntimeException("Slow exception on network thread"));
            }
        }

        private void logLongRunningExecutions() {
            for (Map.Entry<Thread, Long> entry : this.registry.entrySet()) {
                Long blockedSinceInNanos = entry.getValue();
                long elapsedTimeInNanos = this.threadPool.relativeTimeInNanos() - blockedSinceInNanos;
                if (elapsedTimeInNanos <= this.warnThreshold) continue;
                Thread thread = entry.getKey();
                String stackTrace = Arrays.stream(thread.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n"));
                Thread.State threadState = thread.getState();
                if (blockedSinceInNanos != this.registry.get(thread)) continue;
                logger.warn("Potentially blocked execution on network thread [{}] [{}] [{} milliseconds]: \n{}", (Object)thread.getName(), (Object)threadState, (Object)TimeUnit.NANOSECONDS.toMillis(elapsedTimeInNanos), (Object)stackTrace);
            }
            if (!this.stopped) {
                this.threadPool.scheduleUnlessShuttingDown(CHECK_INTERVAL, "generic", this::logLongRunningExecutions);
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    private static class MockSocketChannel
    extends NioSocketChannel
    implements TcpChannel {
        private final boolean isServer;
        private final String profile;
        private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

        private MockSocketChannel(boolean isServer, String profile, SocketChannel socketChannel) {
            super(socketChannel);
            this.isServer = isServer;
            this.profile = profile;
        }

        public void close() {
            this.getContext().closeChannel();
        }

        public String getProfile() {
            return this.profile;
        }

        public boolean isServerChannel() {
            return this.isServer;
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.addCloseListener(ActionListener.toBiConsumer(listener));
        }

        public void addConnectListener(ActionListener<Void> listener) {
            this.addConnectListener(ActionListener.toBiConsumer(listener));
        }

        public TcpChannel.ChannelStats getChannelStats() {
            return this.stats;
        }

        public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
            this.getContext().sendMessage((Object)BytesReference.toByteBuffers((BytesReference)reference), ActionListener.toBiConsumer(listener));
        }
    }

    private static class MockServerChannel
    extends NioServerSocketChannel
    implements TcpServerChannel {
        MockServerChannel(ServerSocketChannel channel) {
            super(channel);
        }

        public void close() {
            this.getContext().closeChannel();
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.addCloseListener(ActionListener.toBiConsumer(listener));
        }
    }

    private static class MockTcpReadWriteHandler
    extends BytesWriteHandler {
        private final MockSocketChannel channel;
        private final TcpTransport transport;

        private MockTcpReadWriteHandler(MockSocketChannel channel, TcpTransport transport) {
            this.channel = channel;
            this.transport = transport;
        }

        public int consumeReads(InboundChannelBuffer channelBuffer) throws IOException {
            BytesReference bytesReference = BytesReference.fromByteBuffers((ByteBuffer[])channelBuffer.sliceBuffersTo(channelBuffer.getIndex()));
            return this.transport.consumeNetworkReads((TcpChannel)this.channel, bytesReference);
        }
    }

    private class MockTcpChannelFactory
    extends ChannelFactory<MockServerChannel, MockSocketChannel> {
        private final boolean isClient;
        private final String profileName;

        private MockTcpChannelFactory(boolean isClient, TcpTransport.ProfileSettings profileSettings, String profileName) {
            super(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.tcpKeepIdle, profileSettings.tcpKeepInterval, profileSettings.tcpKeepCount, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes()));
            this.isClient = isClient;
            this.profileName = profileName;
        }

        public MockSocketChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) {
            MockSocketChannel nioChannel = new MockSocketChannel(!this.isClient, this.profileName, channel);
            IntFunction<Page> pageSupplier = length -> {
                if (length > 16384) {
                    return new Page(ByteBuffer.allocate(length), () -> {});
                }
                Recycler.V bytes = MockNioTransport.this.pageCacheRecycler.bytePage(false);
                return new Page(ByteBuffer.wrap((byte[])bytes.v(), 0, length), () -> ((Recycler.V)bytes).close());
            };
            MockTcpReadWriteHandler readWriteHandler = new MockTcpReadWriteHandler(nioChannel, MockNioTransport.this);
            BytesChannelContext context = new BytesChannelContext((NioSocketChannel)nioChannel, selector, socketConfig, e -> MockNioTransport.this.exceptionCaught(nioChannel, e), (NioChannelHandler)readWriteHandler, new InboundChannelBuffer(pageSupplier));
            nioChannel.setContext((SocketChannelContext)context);
            nioChannel.addConnectListener((v, e) -> {
                if (e == null && channel.isConnected()) {
                    try {
                        channel.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)0);
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(new IOException());
                    }
                }
            });
            return nioChannel;
        }

        public MockServerChannel createServerChannel(NioSelector selector, final ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            MockServerChannel nioServerChannel = new MockServerChannel(channel);
            ServerChannelContext context = new ServerChannelContext(nioServerChannel, this, selector, socketConfig, x$0 -> MockNioTransport.this.acceptChannel(x$0), e -> MockNioTransport.this.onServerException(nioServerChannel, e)){

                public void acceptChannels(Supplier<NioSelector> selectorSupplier) throws IOException {
                    SocketChannel acceptedChannel;
                    int acceptCount = 0;
                    while ((acceptedChannel = 1.accept((ServerSocketChannel)((ServerSocketChannel)this.rawChannel))) != null) {
                        NioSocketChannel nioChannel = MockTcpChannelFactory.this.acceptNioChannel(acceptedChannel, selectorSupplier);
                        MockNioTransport.this.acceptChannel(nioChannel);
                        if (++acceptCount % 100 != 0) continue;
                        logger.warn("Accepted [{}] connections in a single select loop iteration on [{}]", (Object)acceptCount, (Object)channel);
                    }
                }
            };
            nioServerChannel.setContext(context);
            return nioServerChannel;
        }
    }
}

