/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class TestProcessor
implements Processor {
    private final String type;
    private final String tag;
    private final Function<IngestDocument, IngestDocument> ingestDocumentMapper;
    private final AtomicInteger invokedCounter = new AtomicInteger();

    public TestProcessor(Consumer<IngestDocument> ingestDocumentConsumer) {
        this(null, "test-processor", ingestDocumentConsumer);
    }

    public TestProcessor(RuntimeException e) {
        this(null, "test-processor", e);
    }

    public TestProcessor(String tag, String type, RuntimeException e) {
        this(tag, type, (IngestDocument i) -> {
            throw e;
        });
    }

    public TestProcessor(String tag, String type, Consumer<IngestDocument> ingestDocumentConsumer) {
        this(tag, type, (IngestDocument id) -> {
            ingestDocumentConsumer.accept((IngestDocument)id);
            return id;
        });
    }

    public TestProcessor(String tag, String type, Function<IngestDocument, IngestDocument> ingestDocumentMapper) {
        this.ingestDocumentMapper = ingestDocumentMapper;
        this.type = type;
        this.tag = tag;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        this.invokedCounter.incrementAndGet();
        return this.ingestDocumentMapper.apply(ingestDocument);
    }

    public String getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public int getInvokedCounter() {
        return this.invokedCounter.get();
    }

    public static final class Factory
    implements Processor.Factory {
        public TestProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            return new TestProcessor(processorTag, "test-processor", ingestDocument -> {});
        }
    }
}

