/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.util.SameThreadExecutorService;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;

public final class BlobStoreTestUtil {
    private static final byte[] SINK = new byte[1024];

    public static void assertRepoConsistency(InternalTestCluster testCluster, String repoName) {
        BlobStoreRepository repo = (BlobStoreRepository)testCluster.getCurrentMasterNodeInstance(RepositoriesService.class).repository(repoName);
        BlobStoreTestUtil.assertConsistency(repo, repo.threadPool().executor("generic"));
    }

    public static boolean blobExists(BlobContainer container, String blobName) throws IOException {
        boolean bl;
        block9: {
            InputStream input = container.readBlob(blobName);
            try {
                while (input.read(SINK) >= 0) {
                }
                bl = true;
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return false;
                }
            }
            input.close();
        }
        return bl;
    }

    public static void assertConsistency(BlobStoreRepository repository, Executor executor) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        executor.execute((Runnable)ActionRunnable.run((ActionListener)listener, () -> {
            RepositoryData repositoryData;
            long latestGen;
            BlobContainer blobContainer = repository.blobContainer();
            try (DataInputStream inputStream = new DataInputStream(blobContainer.readBlob("index.latest"));){
                latestGen = inputStream.readLong();
            }
            catch (NoSuchFileException e) {
                throw new AssertionError((Object)("Could not find index.latest blob for repo [" + repository + "]"));
            }
            BlobStoreTestUtil.assertIndexGenerations(blobContainer, latestGen);
            try (InputStream blob = blobContainer.readBlob("index-" + latestGen);
                 XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);){
                repositoryData = RepositoryData.snapshotsFromXContent((XContentParser)parser, (long)latestGen);
            }
            BlobStoreTestUtil.assertIndexUUIDs(blobContainer, repositoryData);
            BlobStoreTestUtil.assertSnapshotUUIDs(repository, repositoryData);
            BlobStoreTestUtil.assertShardIndexGenerations(blobContainer, repositoryData.shardGenerations());
        }));
        listener.actionGet(TimeValue.timeValueMinutes((long)1L));
    }

    private static void assertIndexGenerations(BlobContainer repoRoot, long latestGen) throws IOException {
        long[] indexGenerations = repoRoot.listBlobsByPrefix("index-").keySet().stream().map(s -> s.replace("index-", "")).mapToLong(Long::parseLong).sorted().toArray();
        Assert.assertEquals((long)latestGen, (long)indexGenerations[indexGenerations.length - 1]);
        Assert.assertTrue((indexGenerations.length <= 2 ? 1 : 0) != 0);
    }

    private static void assertShardIndexGenerations(BlobContainer repoRoot, ShardGenerations shardGenerations) throws IOException {
        BlobContainer indicesContainer = (BlobContainer)repoRoot.children().get("indices");
        for (IndexId index : shardGenerations.indices()) {
            List gens = shardGenerations.getGens(index);
            if (gens.isEmpty()) continue;
            BlobContainer indexContainer = (BlobContainer)indicesContainer.children().get(index.getId());
            Map shardContainers = indexContainer.children();
            for (int i = 0; i < gens.size(); ++i) {
                String generation = (String)gens.get(i);
                Assert.assertThat((Object)generation, (Matcher)org.hamcrest.Matchers.not((Object)"_deleted"));
                if (generation == null || generation.equals("_new")) continue;
                String shardId = Integer.toString(i);
                Assert.assertThat((Object)shardContainers, (Matcher)org.hamcrest.Matchers.hasKey((Object)shardId));
                Assert.assertThat((Object)((BlobContainer)shardContainers.get(shardId)).listBlobsByPrefix("index-"), (Matcher)org.hamcrest.Matchers.hasKey((Object)("index-" + generation)));
            }
        }
    }

    private static void assertIndexUUIDs(BlobContainer repoRoot, RepositoryData repositoryData) throws IOException {
        List<String> expectedIndexUUIDs = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toList());
        BlobContainer indicesContainer = (BlobContainer)repoRoot.children().get("indices");
        List foundIndexUUIDs = indicesContainer == null ? Collections.emptyList() : indicesContainer.children().keySet().stream().filter(s -> !s.startsWith("extra")).collect(Collectors.toList());
        Assert.assertThat(foundIndexUUIDs, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])expectedIndexUUIDs.toArray(Strings.EMPTY_ARRAY)));
    }

    private static void assertSnapshotUUIDs(BlobStoreRepository repository, RepositoryData repositoryData) throws IOException {
        BlobContainer repoRoot = repository.blobContainer();
        Collection snapshotIds = repositoryData.getSnapshotIds();
        List<String> expectedSnapshotUUIDs = snapshotIds.stream().map(SnapshotId::getUUID).collect(Collectors.toList());
        for (String prefix : new String[]{"snap-", "meta-"}) {
            Collection foundSnapshotUUIDs = repoRoot.listBlobs().keySet().stream().filter(p -> p.startsWith(prefix)).map(p -> p.replace(prefix, "").replace(".dat", "")).collect(Collectors.toSet());
            Assert.assertThat((Object)foundSnapshotUUIDs, (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])expectedSnapshotUUIDs.toArray(Strings.EMPTY_ARRAY)));
        }
        BlobContainer indicesContainer = (BlobContainer)repository.getBlobContainer().children().get("indices");
        Map indices = indicesContainer == null ? Collections.emptyMap() : indicesContainer.children();
        HashMap<IndexId, Integer> maxShardCountsExpected = new HashMap<IndexId, Integer>();
        HashMap<IndexId, Integer> maxShardCountsSeen = new HashMap<IndexId, Integer>();
        for (SnapshotId snapshotId : snapshotIds) {
            SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            for (String index : snapshotInfo.indices()) {
                IndexId indexId2 = repositoryData.resolveIndexId(index);
                Assert.assertThat((Object)indices, (Matcher)org.hamcrest.Matchers.hasKey((Object)indexId2.getId()));
                BlobContainer indexContainer = (BlobContainer)indices.get(indexId2.getId());
                Assert.assertThat((Object)indexContainer.listBlobs(), (Matcher)org.hamcrest.Matchers.hasKey((Object)String.format(Locale.ROOT, "meta-%s.dat", snapshotId.getUUID())));
                IndexMetaData indexMetaData = repository.getSnapshotIndexMetaData(snapshotId, indexId2);
                for (Map.Entry entry : indexContainer.children().entrySet()) {
                    if (((String)entry.getKey()).startsWith("extra")) continue;
                    int shardId = Integer.parseInt((String)entry.getKey());
                    int shardCount = indexMetaData.getNumberOfShards();
                    maxShardCountsExpected.compute(indexId2, (i, existing) -> existing == null || existing < shardCount ? shardCount : existing);
                    BlobContainer shardContainer = (BlobContainer)entry.getValue();
                    if (shardContainer.listBlobs().keySet().stream().anyMatch(blob -> !blob.startsWith("extra"))) {
                        int impliedCount = shardId - 1;
                        maxShardCountsSeen.compute(indexId2, (i, existing) -> existing == null || existing < impliedCount ? impliedCount : existing);
                    }
                    if (shardId >= shardCount || !snapshotInfo.shardFailures().stream().noneMatch(shardFailure -> shardFailure.index().equals(index) && shardFailure.shardId() == shardId)) continue;
                    Map shardPathContents = shardContainer.listBlobs();
                    Assert.assertThat((Object)shardPathContents, (Matcher)org.hamcrest.Matchers.hasKey((Object)String.format(Locale.ROOT, "snap-%s.dat", snapshotId.getUUID())));
                    Assert.assertThat((Object)shardPathContents.keySet().stream().filter(name -> name.startsWith("index-")).count(), (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
                }
            }
        }
        maxShardCountsSeen.forEach((indexId, count) -> Assert.assertThat((String)("Found unreferenced shard paths for index [" + indexId + "]"), (Object)count, (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)((Integer)maxShardCountsExpected.get(indexId)))));
    }

    public static long createDanglingIndex(BlobStoreRepository repository, String name, Set<String> files) throws InterruptedException, ExecutionException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        AtomicLong totalSize = new AtomicLong();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            BlobContainer container = blobStore.blobContainer(repository.basePath().add("indices").add(name));
            for (String file : files) {
                int size = ESTestCase.randomIntBetween(0, 10);
                totalSize.addAndGet(size);
                container.writeBlob(file, (InputStream)new ByteArrayInputStream(new byte[size]), (long)size, false);
            }
        }));
        future.get();
        return totalSize.get();
    }

    public static void assertCorruptionVisible(BlobStoreRepository repository, Map<String, Set<String>> indexToFiles) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            for (String index : indexToFiles.keySet()) {
                if (!blobStore.blobContainer(repository.basePath().add("indices")).children().containsKey(index)) {
                    return false;
                }
                for (String file : (Set)indexToFiles.get(index)) {
                    try {
                        InputStream ignored = blobStore.blobContainer(repository.basePath().add("indices").add(index)).readBlob(file);
                        if (ignored == null) continue;
                        ignored.close();
                    }
                    catch (NoSuchFileException e) {
                        return false;
                    }
                }
            }
            return true;
        }));
        Assert.assertTrue((boolean)((Boolean)future.actionGet()));
    }

    public static void assertBlobsByPrefix(BlobStoreRepository repository, BlobPath path, String prefix, Map<String, BlobMetaData> blobs) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).listBlobsByPrefix(prefix)));
        Map foundBlobs = (Map)future.actionGet();
        if (blobs.isEmpty()) {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)org.hamcrest.Matchers.empty());
        } else {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])blobs.keySet().toArray(Strings.EMPTY_ARRAY)));
            for (Map.Entry entry : foundBlobs.entrySet()) {
                Assert.assertEquals((long)((BlobMetaData)entry.getValue()).length(), (long)blobs.get(entry.getKey()).length());
            }
        }
    }

    public static ClusterService mockClusterService() {
        return BlobStoreTestUtil.mockClusterService(ClusterState.EMPTY_STATE);
    }

    public static ClusterService mockClusterService(RepositoryMetaData metaData) {
        return BlobStoreTestUtil.mockClusterService(ClusterState.builder((ClusterState)ClusterState.EMPTY_STATE).metaData(MetaData.builder().putCustom("repositories", (MetaData.Custom)new RepositoriesMetaData(Collections.singletonList(metaData))).build()).build());
    }

    private static ClusterService mockClusterService(ClusterState initialState) {
        ThreadPool threadPool = (ThreadPool)Mockito.mock(ThreadPool.class);
        Mockito.when((Object)threadPool.executor("snapshot")).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.generic()).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.info("snapshot")).thenReturn((Object)new ThreadPool.Info("snapshot", ThreadPool.ThreadPoolType.FIXED, ESTestCase.randomIntBetween(1, 10)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        ClusterApplierService clusterApplierService = (ClusterApplierService)Mockito.mock(ClusterApplierService.class);
        Mockito.when((Object)clusterService.getClusterApplierService()).thenReturn((Object)clusterApplierService);
        DiscoveryNode localNode = new DiscoveryNode("", ESTestCase.buildNewFakeTransportAddress(), Version.CURRENT);
        AtomicReference<ClusterState> currentState = new AtomicReference<ClusterState>(ClusterState.builder((ClusterState)initialState).nodes(DiscoveryNodes.builder().add(localNode).masterNodeId(localNode.getId()).localNodeId(localNode.getId()).build()).build());
        Mockito.when((Object)clusterService.state()).then(invocationOnMock -> currentState.get());
        CopyOnWriteArrayList appliers = new CopyOnWriteArrayList();
        ((ClusterService)Mockito.doAnswer(invocation -> {
            ClusterStateUpdateTask task = (ClusterStateUpdateTask)invocation.getArguments()[1];
            ClusterState current = (ClusterState)currentState.get();
            ClusterState next = task.execute(current);
            currentState.set(next);
            appliers.forEach(applier -> applier.applyClusterState(new ClusterChangedEvent((String)invocation.getArguments()[0], next, current)));
            task.clusterStateProcessed((String)invocation.getArguments()[0], current, next);
            return null;
        }).when((Object)clusterService)).submitStateUpdateTask(Matchers.anyString(), (ClusterStateTaskConfig)((ClusterStateUpdateTask)Matchers.any(ClusterStateUpdateTask.class)));
        ((ClusterService)Mockito.doAnswer(invocation -> {
            appliers.add((ClusterStateApplier)invocation.getArguments()[0]);
            return null;
        }).when((Object)clusterService)).addStateApplier((ClusterStateApplier)Matchers.any(ClusterStateApplier.class));
        Mockito.when((Object)clusterApplierService.threadPool()).thenReturn((Object)threadPool);
        return clusterService;
    }
}

