/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalTestCluster;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.TestSearchContext;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class ESSingleNodeTestCase
extends ESTestCase {
    private static Node NODE = null;

    protected void startNode(long seed) throws Exception {
        assert (NODE == null);
        NODE = (Node)RandomizedContext.current().runWithPrivateRandomness(seed, this::newNode);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)this.client().admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().get();
        ESSingleNodeTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
        this.client().admin().indices().preparePutTemplate("one_shard_index_template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0)).get();
        this.client().admin().indices().preparePutTemplate("random-soft-deletes-template").setPatterns(Collections.singletonList("*")).setOrder(0).setSettings(Settings.builder().put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), ESSingleNodeTestCase.randomBoolean()).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), ESSingleNodeTestCase.randomBoolean() ? (Long)IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.get(Settings.EMPTY) : (long)ESSingleNodeTestCase.between(0, 1000))).get();
    }

    private static void stopNode() throws IOException, InterruptedException {
        Node node = NODE;
        NODE = null;
        IOUtils.close((Closeable[])new Closeable[]{node});
        if (node != null && !node.awaitClose(10L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Node couldn't close within 10 seconds.");
        }
    }

    public void setUp() throws Exception {
        super.setUp();
        long seed = ESSingleNodeTestCase.random().nextLong();
        if (NODE == null) {
            this.startNode(seed);
        }
    }

    public void tearDown() throws Exception {
        this.logger.trace("[{}#{}]: cleaning up after test", (Object)ESSingleNodeTestCase.getTestClass().getSimpleName(), (Object)this.getTestName());
        super.tearDown();
        ElasticsearchAssertions.assertAcked((AcknowledgedResponse)this.client().admin().indices().prepareDelete(new String[]{"*"}).get());
        MetaData metaData = ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState().getMetaData();
        ESSingleNodeTestCase.assertThat((String)("test leaves persistent cluster metadata behind: " + metaData.persistentSettings().keySet()), (Object)metaData.persistentSettings().size(), (Matcher)Matchers.equalTo((Object)0));
        ESSingleNodeTestCase.assertThat((String)("test leaves transient cluster metadata behind: " + metaData.transientSettings().keySet()), (Object)metaData.transientSettings().size(), (Matcher)Matchers.equalTo((Object)0));
        GetIndexResponse indices = (GetIndexResponse)((GetIndexRequestBuilder)this.client().admin().indices().prepareGetIndex().addIndices(new String[]{"*"})).get();
        ESSingleNodeTestCase.assertThat((String)("test leaves indices that were not deleted: " + Strings.arrayToCommaDelimitedString((Object[])indices.indices())), (Object)indices.indices(), (Matcher)Matchers.equalTo((Object)Strings.EMPTY_ARRAY));
        if (this.resetNodeAfterTest()) {
            assert (NODE != null);
            ESSingleNodeTestCase.stopNode();
            this.startNode(ESSingleNodeTestCase.random().nextLong());
        }
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        ESSingleNodeTestCase.stopNode();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        ESSingleNodeTestCase.stopNode();
    }

    protected boolean resetNodeAfterTest() {
        return false;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.emptyList();
    }

    @SafeVarargs
    protected final Collection<Class<? extends Plugin>> pluginList(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings nodeSettings() {
        return Settings.EMPTY;
    }

    protected boolean addMockHttpTransport() {
        return true;
    }

    private Node newNode() {
        Path tempDir = ESSingleNodeTestCase.createTempDir();
        String nodeName = this.nodeSettings().get(Node.NODE_NAME_SETTING.getKey(), "node_s_0");
        Settings settings = Settings.builder().put(ClusterName.CLUSTER_NAME_SETTING.getKey(), InternalTestCluster.clusterName("single-node-cluster", ESSingleNodeTestCase.random().nextLong())).put(Environment.PATH_HOME_SETTING.getKey(), tempDir).put(Environment.PATH_REPO_SETTING.getKey(), tempDir.resolve("repo")).put(Environment.PATH_SHARED_DATA_SETTING.getKey(), ESSingleNodeTestCase.createTempDir().getParent()).put(Node.NODE_NAME_SETTING.getKey(), nodeName).put(ScriptService.SCRIPT_MAX_COMPILATIONS_RATE.getKey(), "1000/1m").put(EsExecutors.NODE_PROCESSORS_SETTING.getKey(), 1).put("transport.type", ESSingleNodeTestCase.getTestTransportType()).put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).put(Node.NODE_DATA_SETTING.getKey(), true).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), ESSingleNodeTestCase.random().nextLong()).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b").put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b").put(HierarchyCircuitBreakerService.USE_REAL_MEMORY_USAGE_SETTING.getKey(), false).putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]).putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), new String[]{nodeName}).put(this.nodeSettings()).build();
        Collection<Class<? extends Plugin>> plugins = this.getPlugins();
        if (!plugins.contains(ESSingleNodeTestCase.getTestTransportPlugin())) {
            plugins = new ArrayList<Class<? extends Plugin>>(plugins);
            plugins.add(ESSingleNodeTestCase.getTestTransportPlugin());
        }
        if (this.addMockHttpTransport()) {
            plugins.add(MockHttpTransport.TestPlugin.class);
        }
        MockNode node = new MockNode(settings, plugins, this.forbidPrivateIndexSettings());
        try {
            node.start();
        }
        catch (NodeValidationException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    public Client client() {
        return this.wrapClient(NODE.client());
    }

    public Client wrapClient(Client client) {
        return client;
    }

    protected Node node() {
        return NODE;
    }

    protected <T> T getInstanceFromNode(Class<T> clazz) {
        return (T)NODE.injector().getInstance(clazz);
    }

    protected IndexService createIndex(String index) {
        return this.createIndex(index, Settings.EMPTY);
    }

    protected IndexService createIndex(String index, Settings settings) {
        return this.createIndex(index, settings, null, null);
    }

    protected IndexService createIndex(String index, Settings settings, String type, XContentBuilder mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (type != null && mappings != null) {
            createIndexRequestBuilder.addMapping(type, mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    protected IndexService createIndex(String index, Settings settings, String type, Object ... mappings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(index).setSettings(settings);
        if (type != null) {
            createIndexRequestBuilder.addMapping(type, mappings);
        }
        return this.createIndex(index, createIndexRequestBuilder);
    }

    protected IndexService createIndex(String index, CreateIndexRequestBuilder createIndexRequestBuilder) {
        ElasticsearchAssertions.assertAcked((CreateIndexResponse)createIndexRequestBuilder.get());
        ClusterHealthResponse health = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])new String[]{index}).waitForYellowStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        ESSingleNodeTestCase.assertThat((Object)health.getStatus(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)ClusterHealthStatus.YELLOW));
        ESSingleNodeTestCase.assertThat((String)"Cluster must be a single node cluster", (Object)health.getNumberOfDataNodes(), (Matcher)Matchers.equalTo((Object)1));
        IndicesService instanceFromNode = this.getInstanceFromNode(IndicesService.class);
        return instanceFromNode.indexServiceSafe(this.resolveIndex(index));
    }

    public Index resolveIndex(String index) {
        GetIndexResponse getIndexResponse = (GetIndexResponse)((GetIndexRequestBuilder)this.client().admin().indices().prepareGetIndex().setIndices(new String[]{index})).get();
        ESSingleNodeTestCase.assertTrue((String)("index " + index + " not found"), (boolean)getIndexResponse.getSettings().containsKey((Object)index));
        String uuid = ((Settings)getIndexResponse.getSettings().get((Object)index)).get("index.uuid");
        return new Index(index, uuid);
    }

    protected SearchContext createSearchContext(IndexService indexService) {
        BigArrays bigArrays = indexService.getBigArrays();
        return new TestSearchContext(bigArrays, indexService);
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        return this.ensureGreen(TimeValue.timeValueSeconds((long)30L), indices);
    }

    public ClusterHealthStatus ensureGreen(TimeValue timeout, String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).timeout(timeout).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        if (actionGet.isTimedOut()) {
            this.logger.info("ensureGreen timed out, cluster state:\n{}\n{}", (Object)((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState(), (Object)this.client().admin().cluster().preparePendingClusterTasks().get());
            ESSingleNodeTestCase.assertThat((String)"timed out waiting for green state", (Object)actionGet.isTimedOut(), (Matcher)Matchers.equalTo((Object)false));
        }
        ESSingleNodeTestCase.assertThat((Object)actionGet.getStatus(), (Matcher)Matchers.equalTo((Object)ClusterHealthStatus.GREEN));
        this.logger.debug("indices {} are green", (Object)(indices.length == 0 ? "[_all]" : indices));
        return actionGet.getStatus();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return this.getInstanceFromNode(NamedXContentRegistry.class);
    }

    protected boolean forbidPrivateIndexSettings() {
        return true;
    }
}

