/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.disruption;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.transport.MockTransport;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class DisruptableMockTransport
extends MockTransport {
    private final DiscoveryNode localNode;
    private final Logger logger;

    public DisruptableMockTransport(DiscoveryNode localNode, Logger logger) {
        this.localNode = localNode;
        this.logger = logger;
    }

    protected abstract ConnectionStatus getConnectionStatus(DiscoveryNode var1);

    protected abstract Optional<DisruptableMockTransport> getDisruptableMockTransport(TransportAddress var1);

    protected abstract void execute(Runnable var1);

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders);
    }

    @Override
    public void openConnection(final DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        Optional<DisruptableMockTransport> optionalMatchingTransport = this.getDisruptableMockTransport(node.getAddress());
        if (optionalMatchingTransport.isPresent()) {
            final DisruptableMockTransport matchingTransport = optionalMatchingTransport.get();
            ConnectionStatus connectionStatus = this.getConnectionStatus(matchingTransport.getLocalNode());
            if (connectionStatus != ConnectionStatus.CONNECTED) {
                listener.onFailure((Exception)new ConnectTransportException(node, "node [" + node + "] is [" + (Object)((Object)connectionStatus) + "] not [CONNECTED]"));
            } else {
                listener.onResponse((Object)new CloseableConnection(){

                    public DiscoveryNode getNode() {
                        return node;
                    }

                    public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                        DisruptableMockTransport.this.onSendRequest(requestId, action, request, matchingTransport);
                    }
                });
            }
        } else {
            listener.onFailure((Exception)new ConnectTransportException(node, "node " + node + " does not exist"));
        }
    }

    protected void onSendRequest(final long requestId, final String action, final TransportRequest request, final DisruptableMockTransport destinationTransport) {
        assert (!destinationTransport.getLocalNode().equals((Object)this.getLocalNode())) : "non-local message from " + this.getLocalNode() + " to itself";
        destinationTransport.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionStatus connectionStatus = DisruptableMockTransport.this.getConnectionStatus(destinationTransport.getLocalNode());
                switch (connectionStatus) {
                    case BLACK_HOLE: 
                    case BLACK_HOLE_REQUESTS_ONLY: {
                        DisruptableMockTransport.this.onBlackholedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case DISCONNECTED: {
                        DisruptableMockTransport.this.onDisconnectedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case CONNECTED: {
                        DisruptableMockTransport.this.onConnectedDuringSend(requestId, action, request, destinationTransport);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected status: " + (Object)((Object)connectionStatus)));
                    }
                }
            }

            public String toString() {
                return DisruptableMockTransport.this.getRequestDescription(requestId, action, destinationTransport.getLocalNode());
            }
        });
    }

    protected Runnable getDisconnectException(final long requestId, final String action, final DiscoveryNode destination) {
        return new Runnable(){

            @Override
            public void run() {
                DisruptableMockTransport.this.handleError(requestId, (TransportException)new ConnectTransportException(destination, "disconnected"));
            }

            public String toString() {
                return "disconnection response to " + DisruptableMockTransport.this.getRequestDescription(requestId, action, destination);
            }
        };
    }

    protected String getRequestDescription(long requestId, String action, DiscoveryNode destination) {
        return new ParameterizedMessage("[{}][{}] from {} to {}", new Object[]{requestId, action, this.getLocalNode(), destination}).getFormattedMessage();
    }

    protected void onBlackholedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        this.logger.trace("dropping {}", (Object)this.getRequestDescription(requestId, action, destinationTransport.getLocalNode()));
    }

    protected void onDisconnectedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        destinationTransport.execute(this.getDisconnectException(requestId, action, destinationTransport.getLocalNode()));
    }

    protected void onConnectedDuringSend(final long requestId, String action, TransportRequest request, final DisruptableMockTransport destinationTransport) {
        TransportRequest copiedRequest;
        RequestHandlerRegistry<TransportRequest> requestHandler = destinationTransport.getRequestHandler(action);
        DiscoveryNode destination = destinationTransport.getLocalNode();
        final String requestDescription = this.getRequestDescription(requestId, action, destination);
        TransportChannel transportChannel = new TransportChannel(){

            public String getProfileName() {
                return "default";
            }

            public String getChannelType() {
                return "disruptable-mock-transport-channel";
            }

            public void sendResponse(final TransportResponse response) {
                DisruptableMockTransport.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(DisruptableMockTransport.this.getLocalNode());
                        switch (connectionStatus) {
                            case BLACK_HOLE_REQUESTS_ONLY: 
                            case CONNECTED: {
                                DisruptableMockTransport.this.handleResponse(requestId, response);
                                break;
                            }
                            case BLACK_HOLE: 
                            case DISCONNECTED: {
                                DisruptableMockTransport.this.logger.trace("dropping response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + (Object)((Object)connectionStatus)));
                            }
                        }
                    }

                    public String toString() {
                        return "response to " + requestDescription;
                    }
                });
            }

            public void sendResponse(final Exception exception) {
                DisruptableMockTransport.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(DisruptableMockTransport.this.getLocalNode());
                        switch (connectionStatus) {
                            case BLACK_HOLE_REQUESTS_ONLY: 
                            case CONNECTED: {
                                DisruptableMockTransport.this.handleRemoteError(requestId, exception);
                                break;
                            }
                            case BLACK_HOLE: 
                            case DISCONNECTED: {
                                DisruptableMockTransport.this.logger.trace("dropping exception response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + (Object)((Object)connectionStatus)));
                            }
                        }
                    }

                    public String toString() {
                        return "error response to " + requestDescription;
                    }
                });
            }
        };
        try {
            copiedRequest = ESTestCase.copyWriteable(request, this.writeableRegistry(), arg_0 -> requestHandler.newRequest(arg_0));
        }
        catch (IOException e) {
            throw new AssertionError("exception de/serializing request", e);
        }
        try {
            requestHandler.processMessageReceived(copiedRequest, transportChannel);
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (Exception ee) {
                this.logger.warn("failed to send failure", (Throwable)e);
            }
        }
    }

    public static enum ConnectionStatus {
        CONNECTED,
        DISCONNECTED,
        BLACK_HOLE,
        BLACK_HOLE_REQUESTS_ONLY;

    }
}

