/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.util.Collections;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.rest.FakeRestChannel;
import org.elasticsearch.usage.UsageService;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class RestActionTestCase
extends ESTestCase {
    private RestController controller;
    protected NodeClient nodeClient;

    @Before
    public void setUpController() {
        this.nodeClient = (NodeClient)Mockito.mock(NodeClient.class);
        this.controller = new RestController(Collections.emptySet(), null, this.nodeClient, (CircuitBreakerService)new NoneCircuitBreakerService(), new UsageService());
    }

    protected RestController controller() {
        return this.controller;
    }

    protected void dispatchRequest(RestRequest request) {
        FakeRestChannel channel = new FakeRestChannel(request, false, 1);
        ThreadContext threadContext = new ThreadContext(Settings.EMPTY);
        this.controller.dispatchRequest(request, (RestChannel)channel, threadContext);
    }
}

