/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.store;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.FsDirectoryFactory;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;

public class MockFSDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate_on_open", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Boolean> CRASH_INDEX_SETTING = Setting.boolSetting((String)"index.store.mock.random.crash_index", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});

    public Directory newDirectory(IndexSettings idxSettings, ShardPath path) throws IOException {
        Settings indexSettings = idxSettings.getSettings();
        Random random = new Random((Long)idxSettings.getValue(ESIntegTestCase.INDEX_TEST_SEED_SETTING));
        return this.wrap(this.randomDirectoryService(random, idxSettings, path), random, indexSettings, path.getShardId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIndex(Logger logger, Store store, ShardId shardId) {
        if (store.tryIncRef()) {
            logger.info("start check index");
            try {
                Directory dir = store.directory();
                if (!Lucene.indexExists((Directory)dir)) {
                    return;
                }
                try {
                    BytesStreamOutput os = new BytesStreamOutput();
                    PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
                    CheckIndex.Status status = store.checkIndex(out);
                    out.flush();
                    if (!status.clean) {
                        IOException failure = new IOException("failed to check index for shard " + shardId + ";index files [" + Arrays.toString(dir.listAll()) + "] os [" + os.bytes().utf8ToString() + "]");
                        ESTestCase.checkIndexFailures.add(failure);
                        throw failure;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
                    }
                }
                catch (LockObtainFailedException e) {
                    IllegalStateException failure = new IllegalStateException("IndexWriter is still open on shard " + shardId, e);
                    ESTestCase.checkIndexFailures.add(failure);
                    throw failure;
                }
            }
            catch (Exception e) {
                logger.warn("failed to check index", (Throwable)e);
            }
            finally {
                logger.info("end check index");
                store.decRef();
            }
        }
    }

    private Directory wrap(Directory dir, Random random, Settings indexSettings, ShardId shardId) {
        double randomIOExceptionRate = (Double)RANDOM_IO_EXCEPTION_RATE_SETTING.get(indexSettings);
        double randomIOExceptionRateOnOpen = (Double)RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING.get(indexSettings);
        random.nextInt(shardId.getId() + 1);
        MockDirectoryWrapper.Throttling throttle = MockDirectoryWrapper.Throttling.NEVER;
        boolean crashIndex = (Boolean)CRASH_INDEX_SETTING.get(indexSettings);
        ElasticsearchMockDirectoryWrapper w = new ElasticsearchMockDirectoryWrapper(random, dir, crashIndex);
        w.setRandomIOExceptionRate(randomIOExceptionRate);
        w.setRandomIOExceptionRateOnOpen(randomIOExceptionRateOnOpen);
        w.setThrottling(throttle);
        w.setCheckIndexOnClose(false);
        w.setAssertNoDeleteOpenFile(false);
        w.setUseSlowOpenClosers(false);
        LuceneTestCase.closeAfterSuite((Closeable)new CloseableDirectory((BaseDirectoryWrapper)w));
        return w;
    }

    private Directory randomDirectoryService(Random random, IndexSettings indexSettings, ShardPath path) throws IOException {
        IndexMetaData build = IndexMetaData.builder((IndexMetaData)indexSettings.getIndexMetaData()).settings(Settings.builder().put(indexSettings.getIndexMetaData().getSettings()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), ((IndexModule.Type)RandomPicks.randomFrom((Random)random, (Object[])IndexModule.Type.values())).getSettingsKey())).build();
        IndexSettings newIndexSettings = new IndexSettings(build, indexSettings.getNodeSettings());
        return new FsDirectoryFactory().newDirectory(newIndexSettings, path);
    }

    public static final class ElasticsearchMockDirectoryWrapper
    extends MockDirectoryWrapper {
        private final boolean crash;

        public ElasticsearchMockDirectoryWrapper(Random random, Directory delegate, boolean crash) {
            super(random, delegate);
            this.crash = crash;
        }

        public synchronized void crash() throws IOException {
            if (this.crash) {
                super.crash();
            }
        }

        public Set<String> getPendingDeletions() throws IOException {
            return this.in.getPendingDeletions();
        }
    }

    static final class CloseableDirectory
    implements Closeable {
        private final BaseDirectoryWrapper dir;
        private final TestRuleMarkFailure failureMarker;

        CloseableDirectory(BaseDirectoryWrapper dir) {
            this.dir = dir;
            this.failureMarker = ESTestCase.getSuiteFailureMarker();
        }

        @Override
        public void close() {
            if (this.failureMarker.wasSuccessful() && this.dir.isOpen()) {
                Assert.fail((String)("Directory not closed: " + this.dir));
            }
        }
    }
}

