/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.util.BigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;

public class MockBigArrays
extends BigArrays {
    private static final boolean TRACK_ALLOCATIONS = false;
    private static final ConcurrentMap<Object, Object> ACQUIRED_ARRAYS = new ConcurrentHashMap<Object, Object>();
    private final Random random;
    private final PageCacheRecycler recycler;
    private final CircuitBreakerService breakerService;

    public static void ensureAllArraysAreReleased() throws Exception {
        block4: {
            HashMap<Object, Object> masterCopy = new HashMap<Object, Object>(ACQUIRED_ARRAYS);
            if (!masterCopy.isEmpty()) {
                try {
                    ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertTrue((boolean)Sets.haveEmptyIntersection(masterCopy.keySet(), ACQUIRED_ARRAYS.keySet()))));
                }
                catch (AssertionError ex) {
                    masterCopy.keySet().retainAll(ACQUIRED_ARRAYS.keySet());
                    ACQUIRED_ARRAYS.keySet().removeAll(masterCopy.keySet());
                    if (masterCopy.isEmpty()) break block4;
                    Iterator causes = masterCopy.values().iterator();
                    Object firstCause = causes.next();
                    RuntimeException exception = new RuntimeException(masterCopy.size() + " arrays have not been released", firstCause instanceof Throwable ? (Throwable)firstCause : null);
                    while (causes.hasNext()) {
                        Object cause = causes.next();
                        if (!(cause instanceof Throwable)) continue;
                        exception.addSuppressed((Throwable)cause);
                    }
                    throw exception;
                }
            }
        }
    }

    public MockBigArrays(PageCacheRecycler recycler, CircuitBreakerService breakerService) {
        this(recycler, breakerService, false);
    }

    private MockBigArrays(PageCacheRecycler recycler, CircuitBreakerService breakerService, boolean checkBreaker) {
        super(recycler, breakerService, "request", checkBreaker);
        long seed;
        this.recycler = recycler;
        this.breakerService = breakerService;
        try {
            seed = SeedUtils.parseSeed((String)RandomizedContext.current().getRunnerSeedAsString());
        }
        catch (IllegalStateException e) {
            seed = 0L;
        }
        this.random = new Random(seed);
    }

    public BigArrays withCircuitBreaking() {
        return new MockBigArrays(this.recycler, this.breakerService, true);
    }

    public ByteArray newByteArray(long size, boolean clearOnResize) {
        ByteArrayWrapper array = new ByteArrayWrapper(super.newByteArray(size, clearOnResize), clearOnResize);
        if (!clearOnResize) {
            array.randomizeContent(0L, size);
        }
        return array;
    }

    public ByteArray resize(ByteArray array, long size) {
        ByteArrayWrapper arr = (ByteArrayWrapper)array;
        long originalSize = arr.size();
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof ByteArrayWrapper ? (ByteArrayWrapper)array : new ByteArrayWrapper(array, arr.clearOnResize);
        if (!arr.clearOnResize) {
            arr.randomizeContent(originalSize, size);
        }
        return arr;
    }

    public IntArray newIntArray(long size, boolean clearOnResize) {
        IntArrayWrapper array = new IntArrayWrapper(super.newIntArray(size, clearOnResize), clearOnResize);
        if (!clearOnResize) {
            array.randomizeContent(0L, size);
        }
        return array;
    }

    public IntArray resize(IntArray array, long size) {
        IntArrayWrapper arr = (IntArrayWrapper)array;
        long originalSize = arr.size();
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof IntArrayWrapper ? (IntArrayWrapper)array : new IntArrayWrapper(array, arr.clearOnResize);
        if (!arr.clearOnResize) {
            arr.randomizeContent(originalSize, size);
        }
        return arr;
    }

    public LongArray newLongArray(long size, boolean clearOnResize) {
        LongArrayWrapper array = new LongArrayWrapper(super.newLongArray(size, clearOnResize), clearOnResize);
        if (!clearOnResize) {
            array.randomizeContent(0L, size);
        }
        return array;
    }

    public LongArray resize(LongArray array, long size) {
        LongArrayWrapper arr = (LongArrayWrapper)array;
        long originalSize = arr.size();
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof LongArrayWrapper ? (LongArrayWrapper)array : new LongArrayWrapper(array, arr.clearOnResize);
        if (!arr.clearOnResize) {
            arr.randomizeContent(originalSize, size);
        }
        return arr;
    }

    public FloatArray newFloatArray(long size, boolean clearOnResize) {
        FloatArrayWrapper array = new FloatArrayWrapper(super.newFloatArray(size, clearOnResize), clearOnResize);
        if (!clearOnResize) {
            array.randomizeContent(0L, size);
        }
        return array;
    }

    public FloatArray resize(FloatArray array, long size) {
        FloatArrayWrapper arr = (FloatArrayWrapper)array;
        long originalSize = arr.size();
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof FloatArrayWrapper ? (FloatArrayWrapper)array : new FloatArrayWrapper(array, arr.clearOnResize);
        if (!arr.clearOnResize) {
            arr.randomizeContent(originalSize, size);
        }
        return arr;
    }

    public DoubleArray newDoubleArray(long size, boolean clearOnResize) {
        DoubleArrayWrapper array = new DoubleArrayWrapper(super.newDoubleArray(size, clearOnResize), clearOnResize);
        if (!clearOnResize) {
            array.randomizeContent(0L, size);
        }
        return array;
    }

    public DoubleArray resize(DoubleArray array, long size) {
        DoubleArrayWrapper arr = (DoubleArrayWrapper)array;
        long originalSize = arr.size();
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof DoubleArrayWrapper ? (DoubleArrayWrapper)array : new DoubleArrayWrapper(array, arr.clearOnResize);
        if (!arr.clearOnResize) {
            arr.randomizeContent(originalSize, size);
        }
        return arr;
    }

    public <T> ObjectArray<T> newObjectArray(long size) {
        return new ObjectArrayWrapper(super.newObjectArray(size));
    }

    public <T> ObjectArray<T> resize(ObjectArray<T> array, long size) {
        ObjectArrayWrapper arr = (ObjectArrayWrapper)array;
        array = super.resize(arr.in, size);
        ACQUIRED_ARRAYS.remove(arr);
        arr = array instanceof ObjectArrayWrapper ? (ObjectArrayWrapper)array : new ObjectArrayWrapper(array);
        return arr;
    }

    private class ByteArrayWrapper
    extends AbstractArrayWrapper
    implements ByteArray {
        private final ByteArray in;

        ByteArrayWrapper(ByteArray in, boolean clearOnResize) {
            super(clearOnResize);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        @Override
        protected void randomizeContent(long from, long to) {
            this.fill(from, to, (byte)MockBigArrays.this.random.nextInt(256));
        }

        public byte get(long index) {
            return this.in.get(index);
        }

        public byte set(long index, byte value) {
            return this.in.set(index, value);
        }

        public boolean get(long index, int len, BytesRef ref) {
            return this.in.get(index, len, ref);
        }

        public void set(long index, byte[] buf, int offset, int len) {
            this.in.set(index, buf, offset, len);
        }

        public void fill(long fromIndex, long toIndex, byte value) {
            this.in.fill(fromIndex, toIndex, value);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", (Accountable)this.in));
        }
    }

    private class IntArrayWrapper
    extends AbstractArrayWrapper
    implements IntArray {
        private final IntArray in;

        IntArrayWrapper(IntArray in, boolean clearOnResize) {
            super(clearOnResize);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        @Override
        protected void randomizeContent(long from, long to) {
            this.fill(from, to, MockBigArrays.this.random.nextInt());
        }

        public int get(long index) {
            return this.in.get(index);
        }

        public int set(long index, int value) {
            return this.in.set(index, value);
        }

        public int increment(long index, int inc) {
            return this.in.increment(index, inc);
        }

        public void fill(long fromIndex, long toIndex, int value) {
            this.in.fill(fromIndex, toIndex, value);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", (Accountable)this.in));
        }
    }

    private class LongArrayWrapper
    extends AbstractArrayWrapper
    implements LongArray {
        private final LongArray in;

        LongArrayWrapper(LongArray in, boolean clearOnResize) {
            super(clearOnResize);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        @Override
        protected void randomizeContent(long from, long to) {
            this.fill(from, to, MockBigArrays.this.random.nextLong());
        }

        public long get(long index) {
            return this.in.get(index);
        }

        public long set(long index, long value) {
            return this.in.set(index, value);
        }

        public long increment(long index, long inc) {
            return this.in.increment(index, inc);
        }

        public void fill(long fromIndex, long toIndex, long value) {
            this.in.fill(fromIndex, toIndex, value);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", (Accountable)this.in));
        }
    }

    private class FloatArrayWrapper
    extends AbstractArrayWrapper
    implements FloatArray {
        private final FloatArray in;

        FloatArrayWrapper(FloatArray in, boolean clearOnResize) {
            super(clearOnResize);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        @Override
        protected void randomizeContent(long from, long to) {
            this.fill(from, to, (MockBigArrays.this.random.nextFloat() - 0.5f) * 1000.0f);
        }

        public float get(long index) {
            return this.in.get(index);
        }

        public float set(long index, float value) {
            return this.in.set(index, value);
        }

        public float increment(long index, float inc) {
            return this.in.increment(index, inc);
        }

        public void fill(long fromIndex, long toIndex, float value) {
            this.in.fill(fromIndex, toIndex, value);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", (Accountable)this.in));
        }
    }

    private class DoubleArrayWrapper
    extends AbstractArrayWrapper
    implements DoubleArray {
        private final DoubleArray in;

        DoubleArrayWrapper(DoubleArray in, boolean clearOnResize) {
            super(clearOnResize);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        @Override
        protected void randomizeContent(long from, long to) {
            this.fill(from, to, (MockBigArrays.this.random.nextDouble() - 0.5) * 1000.0);
        }

        public double get(long index) {
            return this.in.get(index);
        }

        public double set(long index, double value) {
            return this.in.set(index, value);
        }

        public double increment(long index, double inc) {
            return this.in.increment(index, inc);
        }

        public void fill(long fromIndex, long toIndex, double value) {
            this.in.fill(fromIndex, toIndex, value);
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", (Accountable)this.in));
        }
    }

    private class ObjectArrayWrapper<T>
    extends AbstractArrayWrapper
    implements ObjectArray<T> {
        private final ObjectArray<T> in;

        ObjectArrayWrapper(ObjectArray<T> in) {
            super(false);
            this.in = in;
        }

        @Override
        protected BigArray getDelegate() {
            return this.in;
        }

        public T get(long index) {
            return (T)this.in.get(index);
        }

        public T set(long index, T value) {
            return (T)this.in.set(index, value);
        }

        @Override
        protected void randomizeContent(long from, long to) {
        }

        public Collection<Accountable> getChildResources() {
            return Collections.singleton(Accountables.namedAccountable((String)"delegate", this.in));
        }
    }

    private static abstract class AbstractArrayWrapper {
        final boolean clearOnResize;
        private final AtomicReference<AssertionError> originalRelease;

        AbstractArrayWrapper(boolean clearOnResize) {
            this.clearOnResize = clearOnResize;
            this.originalRelease = new AtomicReference();
            ACQUIRED_ARRAYS.put(this, Boolean.TRUE);
        }

        protected abstract BigArray getDelegate();

        protected abstract void randomizeContent(long var1, long var3);

        public long size() {
            return this.getDelegate().size();
        }

        public long ramBytesUsed() {
            return this.getDelegate().ramBytesUsed();
        }

        public void close() {
            if (!this.originalRelease.compareAndSet(null, new AssertionError())) {
                throw new IllegalStateException("Double release. Original release attached as cause", (Throwable)((Object)this.originalRelease.get()));
            }
            ACQUIRED_ARRAYS.remove(this);
            this.randomizeContent(0L, this.size());
            this.getDelegate().close();
        }
    }
}

