/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.mockito.Mockito;

public class MockGatewayMetaState
extends GatewayMetaState {
    private final DiscoveryNode localNode;

    public MockGatewayMetaState(DiscoveryNode localNode) {
        this.localNode = localNode;
    }

    Metadata upgradeMetadataForNode(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        return metadata;
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        return ClusterStateUpdaters.setLocalNode((ClusterState)clusterState, (DiscoveryNode)this.localNode);
    }

    public void start(Settings settings, NodeEnvironment nodeEnvironment, NamedXContentRegistry xContentRegistry) {
        TransportService transportService = (TransportService)Mockito.mock(TransportService.class);
        Mockito.when((Object)transportService.getThreadPool()).thenReturn((Object)((ThreadPool)Mockito.mock(ThreadPool.class)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        Mockito.when((Object)clusterService.getClusterSettings()).thenReturn((Object)new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
        MetaStateService metaStateService = (MetaStateService)Mockito.mock(MetaStateService.class);
        try {
            Mockito.when((Object)metaStateService.loadFullState()).thenReturn((Object)new Tuple((Object)Manifest.empty(), (Object)Metadata.builder().build()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.start(settings, transportService, clusterService, metaStateService, null, null, new PersistedClusterStateService(nodeEnvironment, xContentRegistry, BigArrays.NON_RECYCLING_INSTANCE, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), () -> 0L));
    }
}

