/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.resync.ResyncReplicationResponse;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.action.support.ActionTestUtils;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.PendingReplicationActions;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.support.replication.TransportWriteActionTestHelper;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingHelper;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.DocIdSeqNoAndSource;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeaseSyncAction;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardTestCase;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class ESIndexLevelReplicationTestCase
extends IndexShardTestCase {
    protected final Index index = new Index("test", "uuid");
    private final ShardId shardId = new ShardId(this.index, 0);
    protected final Map<String, String> indexMapping = Collections.singletonMap("type", "{ \"type\": {} }");

    protected ReplicationGroup createGroup(int replicas) throws IOException {
        return this.createGroup(replicas, Settings.EMPTY);
    }

    protected ReplicationGroup createGroup(int replicas, Settings settings) throws IOException {
        IndexMetadata metadata = this.buildIndexMetadata(replicas, settings, this.indexMapping);
        return new ReplicationGroup(metadata);
    }

    protected IndexMetadata buildIndexMetadata(int replicas) throws IOException {
        return this.buildIndexMetadata(replicas, this.indexMapping);
    }

    protected IndexMetadata buildIndexMetadata(int replicas, Map<String, String> mappings) throws IOException {
        return this.buildIndexMetadata(replicas, Settings.EMPTY, mappings);
    }

    protected IndexMetadata buildIndexMetadata(int replicas, Settings indexSettings, Map<String, String> mappings) throws IOException {
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", replicas).put("index.number_of_shards", 1).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), ESIndexLevelReplicationTestCase.randomBoolean()).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), ESIndexLevelReplicationTestCase.randomBoolean() ? (Long)IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.get(Settings.EMPTY) : (long)ESIndexLevelReplicationTestCase.between(0, 1000)).put(indexSettings).build();
        IndexMetadata.Builder metadata = IndexMetadata.builder((String)this.index.getName()).settings(settings).primaryTerm(0, (long)ESIndexLevelReplicationTestCase.randomIntBetween(1, 100));
        for (Map.Entry<String, String> typeMapping : mappings.entrySet()) {
            metadata.putMapping(typeMapping.getKey(), typeMapping.getValue());
        }
        return metadata.build();
    }

    IndexRequest copyIndexRequest(IndexRequest inRequest) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            IndexRequest indexRequest;
            block11: {
                inRequest.writeTo((StreamOutput)out);
                StreamInput in = out.bytes().streamInput();
                try {
                    indexRequest = new IndexRequest(in);
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return indexRequest;
        }
    }

    protected DiscoveryNode getDiscoveryNode(String id) {
        return new DiscoveryNode(id, id, ESIndexLevelReplicationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), Collections.singleton(DiscoveryNodeRole.DATA_ROLE), Version.CURRENT);
    }

    private void executeShardBulkOnPrimary(IndexShard primary, BulkShardRequest request, ActionListener<TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        for (BulkItemRequest itemRequest : request.items()) {
            if (!(itemRequest.request() instanceof IndexRequest)) continue;
            ((IndexRequest)itemRequest.request()).process(Version.CURRENT, null, this.index.getName());
        }
        PlainActionFuture permitAcquiredFuture = new PlainActionFuture();
        primary.acquirePrimaryOperationPermit((ActionListener)permitAcquiredFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)permitAcquiredFuture.actionGet();){
            MappingUpdatePerformer noopMappingUpdater = (update, shardId, type, listener1) -> {};
            TransportShardBulkAction.performOnPrimary((BulkShardRequest)request, (IndexShard)primary, null, System::currentTimeMillis, (MappingUpdatePerformer)noopMappingUpdater, null, ActionTestUtils.assertNoFailureListener(result -> {
                TransportWriteActionTestHelper.performPostWriteActions(primary, request, ((TransportWriteAction.WritePrimaryResult)result).location, this.logger);
                listener.onResponse((Object)((TransportWriteAction.WritePrimaryResult)result));
            }), (ThreadPool)this.threadPool);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private <Request extends ReplicatedWriteRequest> BulkShardRequest executeReplicationRequestOnPrimary(IndexShard primary, Request request) throws Exception {
        BulkShardRequest bulkShardRequest = new BulkShardRequest(this.shardId, request.getRefreshPolicy(), new BulkItemRequest[]{new BulkItemRequest(0, (DocWriteRequest)request)});
        PlainActionFuture res = new PlainActionFuture();
        this.executeShardBulkOnPrimary(primary, bulkShardRequest, (ActionListener<TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>>)ActionListener.map((ActionListener)res, TransportReplicationAction.PrimaryResult::replicaRequest));
        return (BulkShardRequest)res.get();
    }

    private void executeShardBulkOnReplica(BulkShardRequest request, IndexShard replica, long operationPrimaryTerm, long globalCheckpointOnPrimary, long maxSeqNoOfUpdatesOrDeletes) throws Exception {
        Translog.Location location;
        PlainActionFuture permitAcquiredFuture = new PlainActionFuture();
        replica.acquireReplicaOperationPermit(operationPrimaryTerm, globalCheckpointOnPrimary, maxSeqNoOfUpdatesOrDeletes, (ActionListener)permitAcquiredFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)permitAcquiredFuture.actionGet();){
            location = TransportShardBulkAction.performOnReplica((BulkShardRequest)request, (IndexShard)replica);
        }
        TransportWriteActionTestHelper.performPostWriteActions(replica, request, location, this.logger);
    }

    public BulkShardRequest indexOnPrimary(IndexRequest request, IndexShard primary) throws Exception {
        return this.executeReplicationRequestOnPrimary(primary, request);
    }

    BulkShardRequest deleteOnPrimary(DeleteRequest request, IndexShard primary) throws Exception {
        return this.executeReplicationRequestOnPrimary(primary, request);
    }

    public void indexOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica) throws Exception {
        this.indexOnReplica(request, group, replica, group.primary.getPendingPrimaryTerm());
    }

    void indexOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica, long term) throws Exception {
        this.executeShardBulkOnReplica(request, replica, term, group.primary.getLastKnownGlobalCheckpoint(), group.primary.getMaxSeqNoOfUpdatesOrDeletes());
    }

    void deleteOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica) throws Exception {
        this.executeShardBulkOnReplica(request, replica, group.primary.getPendingPrimaryTerm(), group.primary.getLastKnownGlobalCheckpoint(), group.primary.getMaxSeqNoOfUpdatesOrDeletes());
    }

    private TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse> executeResyncOnPrimary(IndexShard primary, ResyncReplicationRequest request) {
        TransportWriteAction.WritePrimaryResult result = new TransportWriteAction.WritePrimaryResult((ReplicatedWriteRequest)TransportResyncReplicationAction.performOnPrimary((ResyncReplicationRequest)request), (ReplicationResponse)new ResyncReplicationResponse(), null, null, primary, this.logger);
        TransportWriteActionTestHelper.performPostWriteActions(primary, request, result.location, this.logger);
        return result;
    }

    private void executeResyncOnReplica(IndexShard replica, ResyncReplicationRequest request, long operationPrimaryTerm, long globalCheckpointOnPrimary, long maxSeqNoOfUpdatesOrDeletes) throws Exception {
        Translog.Location location;
        PlainActionFuture acquirePermitFuture = new PlainActionFuture();
        replica.acquireReplicaOperationPermit(operationPrimaryTerm, globalCheckpointOnPrimary, maxSeqNoOfUpdatesOrDeletes, (ActionListener)acquirePermitFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)acquirePermitFuture.actionGet();){
            location = TransportResyncReplicationAction.performOnReplica((ResyncReplicationRequest)request, (IndexShard)replica);
        }
        TransportWriteActionTestHelper.performPostWriteActions(replica, request, location, this.logger);
    }

    static /* synthetic */ ThreadPool access$000(ESIndexLevelReplicationTestCase x0) {
        return x0.threadPool;
    }

    protected class ReplicationGroup
    implements AutoCloseable,
    Iterable<IndexShard> {
        private IndexShard primary;
        private IndexMetadata indexMetadata;
        private final List<IndexShard> replicas;
        private final AtomicInteger replicaId = new AtomicInteger();
        private final AtomicInteger docId = new AtomicInteger();
        boolean closed = false;
        private volatile ReplicationTargets replicationTargets;
        private final PrimaryReplicaSyncer primaryReplicaSyncer = new PrimaryReplicaSyncer(new TaskManager(Settings.EMPTY, ESIndexLevelReplicationTestCase.access$000(ESIndexLevelReplicationTestCase.this), Collections.emptySet()), (request, parentTask, primaryAllocationId, primaryTerm, listener) -> {
            try {
                new ResyncAction(request, (ActionListener<ResyncReplicationResponse>)listener, this).execute();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
        private final RetentionLeaseSyncer retentionLeaseSyncer = new RetentionLeaseSyncer((shardId, primaryAllocationId, primaryTerm, retentionLeases, listener) -> this.syncRetentionLeases(shardId, retentionLeases, (ActionListener<ReplicationResponse>)listener), (shardId, primaryAllocationId, primaryTerm, retentionLeases) -> this.syncRetentionLeases(shardId, retentionLeases, (ActionListener<ReplicationResponse>)ActionListener.wrap(r -> {}, e -> {
            throw new AssertionError("failed to background sync retention lease", (Throwable)e);
        })));

        protected ReplicationGroup(IndexMetadata indexMetadata) throws IOException {
            ShardRouting primaryRouting = this.createShardRouting("s0", true);
            this.primary = ESIndexLevelReplicationTestCase.this.newShard(primaryRouting, indexMetadata, (CheckedFunction<DirectoryReader, DirectoryReader, IOException>)null, this.getEngineFactory(primaryRouting), () -> {}, this.retentionLeaseSyncer, new IndexingOperationListener[0]);
            this.replicas = new CopyOnWriteArrayList<IndexShard>();
            this.indexMetadata = indexMetadata;
            this.updateAllocationIDsOnPrimary();
            for (int i = 0; i < indexMetadata.getNumberOfReplicas(); ++i) {
                this.addReplica();
            }
        }

        private ShardRouting createShardRouting(String nodeId, boolean primary) {
            return TestShardRouting.newShardRouting(ESIndexLevelReplicationTestCase.this.shardId, nodeId, primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        }

        protected EngineFactory getEngineFactory(ShardRouting routing) {
            return new InternalEngineFactory();
        }

        public int indexDocs(int numOfDoc) throws Exception {
            for (int doc = 0; doc < numOfDoc; ++doc) {
                IndexRequest indexRequest = new IndexRequest(ESIndexLevelReplicationTestCase.this.index.getName(), "type", Integer.toString(this.docId.incrementAndGet())).source("{}", XContentType.JSON);
                BulkItemResponse response = this.index(indexRequest);
                if (response.isFailed()) {
                    throw response.getFailure().getCause();
                }
                Assert.assertEquals((Object)DocWriteResponse.Result.CREATED, (Object)response.getResponse().getResult());
            }
            return numOfDoc;
        }

        public int appendDocs(int numOfDoc) throws Exception {
            for (int doc = 0; doc < numOfDoc; ++doc) {
                IndexRequest indexRequest = new IndexRequest(ESIndexLevelReplicationTestCase.this.index.getName(), "type").source("{}", XContentType.JSON);
                BulkItemResponse response = this.index(indexRequest);
                if (response.isFailed()) {
                    throw response.getFailure().getCause();
                }
                if (response.isFailed()) continue;
                Assert.assertEquals((Object)DocWriteResponse.Result.CREATED, (Object)response.getResponse().getResult());
            }
            return numOfDoc;
        }

        public BulkItemResponse index(IndexRequest indexRequest) throws Exception {
            return this.executeWriteRequest((DocWriteRequest<?>)indexRequest, indexRequest.getRefreshPolicy());
        }

        public BulkItemResponse delete(DeleteRequest deleteRequest) throws Exception {
            return this.executeWriteRequest((DocWriteRequest<?>)deleteRequest, deleteRequest.getRefreshPolicy());
        }

        private BulkItemResponse executeWriteRequest(DocWriteRequest<?> writeRequest, WriteRequest.RefreshPolicy refreshPolicy) throws Exception {
            PlainActionFuture listener = new PlainActionFuture();
            ActionListener wrapBulkListener = ActionListener.map((ActionListener)listener, bulkShardResponse -> bulkShardResponse.getResponses()[0]);
            BulkItemRequest[] items = new BulkItemRequest[]{new BulkItemRequest(0, writeRequest)};
            BulkShardRequest request = new BulkShardRequest(ESIndexLevelReplicationTestCase.this.shardId, refreshPolicy, items);
            new WriteReplicationAction(request, (ActionListener<BulkShardResponse>)wrapBulkListener, this).execute();
            return (BulkItemResponse)listener.get();
        }

        public synchronized void startAll() throws IOException {
            this.startReplicas(this.replicas.size());
        }

        public synchronized int startReplicas(int numOfReplicasToStart) throws IOException {
            if (this.primary.routingEntry().initializing()) {
                this.startPrimary();
            }
            int started = 0;
            for (IndexShard replicaShard : this.replicas) {
                if (!replicaShard.routingEntry().initializing()) continue;
                this.recoverReplica(replicaShard);
                if (++started <= numOfReplicasToStart) continue;
                break;
            }
            return started;
        }

        public void startPrimary() throws IOException {
            this.recoverPrimary(this.primary);
            this.computeReplicationTargets();
            HashSet<String> activeIds = new HashSet<String>();
            activeIds.addAll(this.activeIds());
            activeIds.add(this.primary.routingEntry().allocationId().getId());
            ShardRouting startedRoutingEntry = ShardRoutingHelper.moveToStarted(this.primary.routingEntry());
            IndexShardRoutingTable routingTable = this.routingTable(shr -> shr == this.primary.routingEntry() ? startedRoutingEntry : shr);
            this.primary.updateShardState(startedRoutingEntry, this.primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), activeIds, routingTable);
            for (IndexShard replica : this.replicas) {
                this.recoverReplica(replica);
            }
            this.computeReplicationTargets();
        }

        public IndexShard addReplica() throws IOException {
            ShardRouting replicaRouting = this.createShardRouting("s" + this.replicaId.incrementAndGet(), false);
            IndexShard replica = ESIndexLevelReplicationTestCase.this.newShard(replicaRouting, this.indexMetadata, (CheckedFunction<DirectoryReader, DirectoryReader, IOException>)null, this.getEngineFactory(replicaRouting), () -> {}, this.retentionLeaseSyncer, new IndexingOperationListener[0]);
            this.addReplica(replica);
            return replica;
        }

        public synchronized void addReplica(IndexShard replica) throws IOException {
            assert (!this.shardRoutings().stream().anyMatch(shardRouting -> shardRouting.isSameAllocation(replica.routingEntry()))) : "replica with aId [" + replica.routingEntry().allocationId() + "] already exists";
            this.replicas.add(replica);
            if (this.replicationTargets != null) {
                this.replicationTargets.addReplica(replica);
            }
            this.updateAllocationIDsOnPrimary();
        }

        protected synchronized void recoverPrimary(IndexShard primary) {
            DiscoveryNode pNode = ESIndexLevelReplicationTestCase.this.getDiscoveryNode(primary.routingEntry().currentNodeId());
            primary.markAsRecovering("store", new RecoveryState(primary.routingEntry(), pNode, null));
            IndexShardTestCase.recoverFromStore(primary);
        }

        public synchronized IndexShard addReplicaWithExistingPath(ShardPath shardPath, String nodeId) throws IOException {
            ShardRouting shardRouting = TestShardRouting.newShardRouting(ESIndexLevelReplicationTestCase.this.shardId, nodeId, false, ShardRoutingState.INITIALIZING, (RecoverySource)RecoverySource.PeerRecoverySource.INSTANCE);
            IndexShard newReplica = ESIndexLevelReplicationTestCase.this.newShard(shardRouting, shardPath, this.indexMetadata, (CheckedFunction<IndexSettings, Store, IOException>)null, (CheckedFunction<DirectoryReader, DirectoryReader, IOException>)null, this.getEngineFactory(shardRouting), () -> {}, this.retentionLeaseSyncer, IndexShardTestCase.EMPTY_EVENT_LISTENER, new IndexingOperationListener[0]);
            this.replicas.add(newReplica);
            if (this.replicationTargets != null) {
                this.replicationTargets.addReplica(newReplica);
            }
            this.updateAllocationIDsOnPrimary();
            return newReplica;
        }

        public synchronized List<IndexShard> getReplicas() {
            return Collections.unmodifiableList(this.replicas);
        }

        public Future<PrimaryReplicaSyncer.ResyncTask> promoteReplicaToPrimary(IndexShard replica) throws IOException {
            final PlainActionFuture fut = new PlainActionFuture();
            this.promoteReplicaToPrimary(replica, (shard, listener) -> {
                this.computeReplicationTargets();
                this.primaryReplicaSyncer.resync(shard, (ActionListener)new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                    public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                        listener.onResponse((Object)resyncTask);
                        fut.onResponse((Object)resyncTask);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                        fut.onFailure(e);
                    }
                });
            });
            return fut;
        }

        public synchronized void promoteReplicaToPrimary(IndexShard replica, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer) throws IOException {
            long newTerm = this.indexMetadata.primaryTerm(ESIndexLevelReplicationTestCase.this.shardId.id()) + 1L;
            IndexMetadata.Builder newMetadata = IndexMetadata.builder((IndexMetadata)this.indexMetadata).primaryTerm(ESIndexLevelReplicationTestCase.this.shardId.id(), newTerm);
            this.indexMetadata = newMetadata.build();
            Assert.assertTrue((boolean)this.replicas.remove(replica));
            ESIndexLevelReplicationTestCase.this.closeShards(new IndexShard[]{this.primary});
            this.primary = replica;
            assert (this.primary.routingEntry().active()) : "only active replicas can be promoted to primary: " + this.primary.routingEntry();
            ShardRouting primaryRouting = replica.routingEntry().moveActiveReplicaToPrimary();
            IndexShardRoutingTable routingTable = this.routingTable(shr -> shr == replica.routingEntry() ? primaryRouting : shr);
            this.primary.updateShardState(primaryRouting, newTerm, primaryReplicaSyncer, currentClusterStateVersion.incrementAndGet(), this.activeIds(), routingTable);
        }

        private synchronized Set<String> activeIds() {
            return this.shardRoutings().stream().filter(ShardRouting::active).map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet());
        }

        private synchronized IndexShardRoutingTable routingTable(Function<ShardRouting, ShardRouting> transformer) {
            IndexShardRoutingTable.Builder routingTable = new IndexShardRoutingTable.Builder(this.primary.shardId());
            this.shardRoutings().stream().map(transformer).forEach(arg_0 -> ((IndexShardRoutingTable.Builder)routingTable).addShard(arg_0));
            return routingTable.build();
        }

        public synchronized boolean removeReplica(IndexShard replica) throws IOException {
            boolean removed = this.replicas.remove(replica);
            if (removed) {
                this.updateAllocationIDsOnPrimary();
                this.computeReplicationTargets();
            }
            return removed;
        }

        public void recoverReplica(IndexShard replica) throws IOException {
            this.recoverReplica(replica, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, recoveryListener));
        }

        public void recoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier) throws IOException {
            this.recoverReplica(replica, targetSupplier, true);
        }

        public void recoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering) throws IOException {
            IndexShardRoutingTable routingTable = this.routingTable(Function.identity());
            Set<String> inSyncIds = this.activeIds();
            ESIndexLevelReplicationTestCase.this.recoverUnstartedReplica(replica, this.primary, targetSupplier, markAsRecovering, inSyncIds, routingTable);
            ESIndexLevelReplicationTestCase.this.startReplicaAfterRecovery(replica, this.primary, inSyncIds, routingTable);
            this.computeReplicationTargets();
        }

        public synchronized DiscoveryNode getPrimaryNode() {
            return ESIndexLevelReplicationTestCase.this.getDiscoveryNode(this.primary.routingEntry().currentNodeId());
        }

        public Future<Void> asyncRecoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier) {
            FutureTask<Void> task = new FutureTask<Void>(() -> {
                this.recoverReplica(replica, targetSupplier);
                return null;
            });
            ESIndexLevelReplicationTestCase.this.threadPool.generic().execute(task);
            return task;
        }

        public synchronized void assertAllEqual(int expectedCount) throws IOException {
            Set<String> primaryIds = IndexShardTestCase.getShardDocUIDs(this.primary);
            Assert.assertThat((Object)primaryIds.size(), (Matcher)Matchers.equalTo((Object)expectedCount));
            for (IndexShard replica : this.replicas) {
                Set<String> replicaIds = IndexShardTestCase.getShardDocUIDs(replica);
                HashSet<String> temp = new HashSet<String>(primaryIds);
                temp.removeAll(replicaIds);
                Assert.assertThat((String)(replica.routingEntry() + " is missing docs"), temp, (Matcher)Matchers.empty());
                temp = new HashSet<String>(replicaIds);
                temp.removeAll(primaryIds);
                Assert.assertThat((String)(replica.routingEntry() + " has extra docs"), temp, (Matcher)Matchers.empty());
            }
        }

        public synchronized void refresh(String source) {
            for (IndexShard shard : this) {
                shard.refresh(source);
            }
        }

        public synchronized void flush() {
            FlushRequest request = new FlushRequest(new String[0]);
            for (IndexShard shard : this) {
                shard.flush(request);
            }
        }

        public synchronized List<ShardRouting> shardRoutings() {
            return StreamSupport.stream(this.spliterator(), false).map(IndexShard::routingEntry).collect(Collectors.toList());
        }

        @Override
        public synchronized void close() throws Exception {
            if (!this.closed) {
                this.closed = true;
                try {
                    List<DocIdSeqNoAndSource> docsOnPrimary = IndexShardTestCase.getDocIdAndSeqNos(this.primary);
                    for (IndexShard replica : this.replicas) {
                        Assert.assertThat((Object)replica.getMaxSeenAutoIdTimestamp(), (Matcher)Matchers.equalTo((Object)this.primary.getMaxSeenAutoIdTimestamp()));
                        Assert.assertThat((Object)replica.getMaxSeqNoOfUpdatesOrDeletes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.primary.getMaxSeqNoOfUpdatesOrDeletes())));
                        Assert.assertThat(IndexShardTestCase.getDocIdAndSeqNos(replica), (Matcher)Matchers.equalTo(docsOnPrimary));
                    }
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            } else {
                throw new AlreadyClosedException("too bad");
            }
            ESIndexLevelReplicationTestCase.this.closeShards(this);
        }

        @Override
        public Iterator<IndexShard> iterator() {
            return Iterators.concat((Iterator[])new Iterator[]{this.replicas.iterator(), Collections.singleton(this.primary).iterator()});
        }

        public synchronized IndexShard getPrimary() {
            return this.primary;
        }

        public synchronized void reinitPrimaryShard() throws IOException {
            this.primary = ESIndexLevelReplicationTestCase.this.reinitShard(this.primary, new IndexingOperationListener[0]);
            this.computeReplicationTargets();
        }

        public void syncGlobalCheckpoint() {
            PlainActionFuture listener = new PlainActionFuture();
            try {
                new GlobalCheckpointSync((ActionListener<ReplicationResponse>)listener, this).execute();
                listener.get();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        private void updateAllocationIDsOnPrimary() throws IOException {
            this.primary.updateShardState(this.primary.routingEntry(), this.primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), this.activeIds(), this.routingTable(Function.identity()));
        }

        private synchronized void computeReplicationTargets() {
            this.replicationTargets = new ReplicationTargets(this.primary, new ArrayList<IndexShard>(this.replicas));
        }

        private ReplicationTargets getReplicationTargets() {
            return this.replicationTargets;
        }

        protected void syncRetentionLeases(ShardId shardId, RetentionLeases leases, ActionListener<ReplicationResponse> listener) {
            new SyncRetentionLeases(new RetentionLeaseSyncAction.Request(shardId, leases), this, (ActionListener<RetentionLeaseSyncAction.Response>)ActionListener.map(listener, r -> new ReplicationResponse())).execute();
        }

        public synchronized RetentionLease addRetentionLease(String id, long retainingSequenceNumber, String source, ActionListener<ReplicationResponse> listener) {
            return this.getPrimary().addRetentionLease(id, retainingSequenceNumber, source, listener);
        }

        public synchronized RetentionLease renewRetentionLease(String id, long retainingSequenceNumber, String source) {
            return this.getPrimary().renewRetentionLease(id, retainingSequenceNumber, source);
        }

        public synchronized void removeRetentionLease(String id, ActionListener<ReplicationResponse> listener) {
            this.getPrimary().removeRetentionLease(id, listener);
        }

        public void executeRetentionLeasesSyncRequestOnReplica(RetentionLeaseSyncAction.Request request, IndexShard replica) {
            PlainActionFuture acquirePermitFuture = new PlainActionFuture();
            replica.acquireReplicaOperationPermit(this.getPrimary().getOperationPrimaryTerm(), this.getPrimary().getLastKnownGlobalCheckpoint(), this.getPrimary().getMaxSeqNoOfUpdatesOrDeletes(), (ActionListener)acquirePermitFuture, "same", (Object)request);
            try (Releasable ignored = (Releasable)acquirePermitFuture.actionGet();){
                replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
                replica.persistRetentionLeases();
            }
            catch (Exception e) {
                throw new AssertionError("failed to execute retention lease request on replica [" + replica.routingEntry() + "]", e);
            }
        }
    }

    class SyncRetentionLeases
    extends ReplicationAction<RetentionLeaseSyncAction.Request, RetentionLeaseSyncAction.Request, RetentionLeaseSyncAction.Response> {
        SyncRetentionLeases(RetentionLeaseSyncAction.Request request, ReplicationGroup group, ActionListener<RetentionLeaseSyncAction.Response> listener) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)request, listener, group, "sync-retention-leases");
        }

        @Override
        protected void performOnPrimary(IndexShard primary, RetentionLeaseSyncAction.Request request, ActionListener<ReplicationAction.PrimaryResult> listener) {
            ActionListener.completeWith(listener, () -> {
                primary.persistRetentionLeases();
                return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)request, (ReplicationResponse)new RetentionLeaseSyncAction.Response());
            });
        }

        @Override
        protected void performOnReplica(RetentionLeaseSyncAction.Request request, IndexShard replica) throws Exception {
            replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
            replica.persistRetentionLeases();
        }
    }

    class ResyncAction
    extends ReplicationAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse> {
        ResyncAction(ResyncReplicationRequest request, ActionListener<ResyncReplicationResponse> listener, ReplicationGroup group) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)request, listener, group, "resync");
        }

        @Override
        protected void performOnPrimary(IndexShard primary, ResyncReplicationRequest request, ActionListener<ReplicationAction.PrimaryResult> listener) {
            ActionListener.completeWith(listener, () -> {
                TransportWriteAction.WritePrimaryResult result = ESIndexLevelReplicationTestCase.this.executeResyncOnPrimary(primary, request);
                return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)((ResyncReplicationRequest)result.replicaRequest()), (ReplicationResponse)((ResyncReplicationResponse)result.finalResponseIfSuccessful));
            });
        }

        @Override
        protected void performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
            ESIndexLevelReplicationTestCase.this.executeResyncOnReplica(replica, request, this.getPrimaryShard().getPendingPrimaryTerm(), this.getPrimaryShard().getLastKnownGlobalCheckpoint(), this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes());
        }
    }

    class GlobalCheckpointSync
    extends ReplicationAction<GlobalCheckpointSyncAction.Request, GlobalCheckpointSyncAction.Request, ReplicationResponse> {
        GlobalCheckpointSync(ActionListener<ReplicationResponse> listener, ReplicationGroup replicationGroup) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)new GlobalCheckpointSyncAction.Request(replicationGroup.getPrimary().shardId()), listener, replicationGroup, "global_checkpoint_sync");
        }

        @Override
        protected void performOnPrimary(IndexShard primary, GlobalCheckpointSyncAction.Request request, ActionListener<ReplicationAction.PrimaryResult> listener) {
            ActionListener.completeWith(listener, () -> {
                primary.sync();
                return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)request, new ReplicationResponse());
            });
        }

        @Override
        protected void performOnReplica(GlobalCheckpointSyncAction.Request request, IndexShard replica) throws IOException {
            replica.sync();
        }
    }

    class WriteReplicationAction
    extends ReplicationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
        WriteReplicationAction(BulkShardRequest request, ActionListener<BulkShardResponse> listener, ReplicationGroup replicationGroup) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)request, listener, replicationGroup, "indexing");
        }

        @Override
        protected void performOnPrimary(IndexShard primary, BulkShardRequest request, ActionListener<ReplicationAction.PrimaryResult> listener) {
            ESIndexLevelReplicationTestCase.this.executeShardBulkOnPrimary(primary, request, (ActionListener<TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>>)ActionListener.map(listener, result -> new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)((BulkShardRequest)result.replicaRequest()), (ReplicationResponse)((BulkShardResponse)result.finalResponseIfSuccessful))));
        }

        @Override
        protected void performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
            ESIndexLevelReplicationTestCase.this.executeShardBulkOnReplica(request, replica, this.getPrimaryShard().getPendingPrimaryTerm(), this.getPrimaryShard().getLastKnownGlobalCheckpoint(), this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes());
        }
    }

    protected static abstract class ReplicationAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse> {
        private final Request request;
        private ActionListener<Response> listener;
        private final ReplicationTargets replicationTargets;
        private final String opType;
        final /* synthetic */ ESIndexLevelReplicationTestCase this$0;

        protected ReplicationAction(Request request, ActionListener<Response> listener, ReplicationGroup group, String opType) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            this.replicationTargets = group.getReplicationTargets();
            this.opType = opType;
        }

        public void execute() {
            try {
                new ReplicationOperation(this.request, (ReplicationOperation.Primary)new PrimaryRef(), ActionListener.map(this.listener, result -> {
                    this.adaptResponse(result.finalResponse, this.getPrimaryShard());
                    return result.finalResponse;
                }), (ReplicationOperation.Replicas)new ReplicasRef(), this.this$0.logger, this.this$0.threadPool, this.opType, this.this$0.primaryTerm, TimeValue.timeValueMillis((long)20L), TimeValue.timeValueSeconds((long)60L)).execute();
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        protected void adaptResponse(Response response, IndexShard indexShard) {
        }

        protected IndexShard getPrimaryShard() {
            return this.replicationTargets.primary;
        }

        protected abstract void performOnPrimary(IndexShard var1, Request var2, ActionListener<PrimaryResult> var3);

        protected abstract void performOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

        class PrimaryRef
        implements ReplicationOperation.Primary<Request, ReplicaRequest, PrimaryResult> {
            PrimaryRef() {
            }

            public ShardRouting routingEntry() {
                return ReplicationAction.this.getPrimaryShard().routingEntry();
            }

            public void failShard(String message, Exception exception) {
                throw new UnsupportedOperationException("failing a primary isn't supported. failure: " + message, exception);
            }

            public void perform(Request request, ActionListener<PrimaryResult> listener) {
                ReplicationAction.this.performOnPrimary(ReplicationAction.this.getPrimaryShard(), request, listener);
            }

            public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
                ReplicationAction.this.getPrimaryShard().updateLocalCheckpointForShard(allocationId, checkpoint);
            }

            public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
                ReplicationAction.this.getPrimaryShard().updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
            }

            public long localCheckpoint() {
                return ReplicationAction.this.getPrimaryShard().getLocalCheckpoint();
            }

            public long globalCheckpoint() {
                return ReplicationAction.this.getPrimaryShard().getLastSyncedGlobalCheckpoint();
            }

            public long computedGlobalCheckpoint() {
                return ReplicationAction.this.getPrimaryShard().getLastKnownGlobalCheckpoint();
            }

            public long maxSeqNoOfUpdatesOrDeletes() {
                return ReplicationAction.this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes();
            }

            public org.elasticsearch.index.shard.ReplicationGroup getReplicationGroup() {
                return ReplicationAction.this.getPrimaryShard().getReplicationGroup();
            }

            public PendingReplicationActions getPendingReplicationActions() {
                return ReplicationAction.this.getPrimaryShard().getPendingReplicationActions();
            }
        }

        class ReplicasRef
        implements ReplicationOperation.Replicas<ReplicaRequest> {
            ReplicasRef() {
            }

            public void performOn(ShardRouting replicaRouting, ReplicaRequest request, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
                IndexShard replica = ReplicationAction.this.replicationTargets.findReplicaShard(replicaRouting);
                replica.acquireReplicaOperationPermit(ReplicationAction.this.getPrimaryShard().getPendingPrimaryTerm(), globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, ActionListener.delegateFailure(listener, (delegatedListener, releasable) -> {
                    try {
                        ReplicationAction.this.performOnReplica(request, replica);
                        releasable.close();
                        delegatedListener.onResponse((Object)new TransportReplicationAction.ReplicaResponse(replica.getLocalCheckpoint(), replica.getLastKnownGlobalCheckpoint()));
                    }
                    catch (Exception e) {
                        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{releasable});
                        delegatedListener.onFailure(e);
                    }
                }), "write", request);
            }

            public void failShardIfNeeded(ShardRouting replica, long primaryTerm, String message, Exception exception, ActionListener<Void> listener) {
                throw new UnsupportedOperationException("failing shard " + replica + " isn't supported. failure: " + message, exception);
            }

            public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
                throw new UnsupportedOperationException("can't mark " + shardId + ", aid [" + allocationId + "] as stale");
            }
        }

        protected static class PrimaryResult
        implements ReplicationOperation.PrimaryResult<ReplicaRequest> {
            final ReplicaRequest replicaRequest;
            final Response finalResponse;
            final /* synthetic */ ReplicationAction this$1;

            public PrimaryResult(ReplicaRequest replicaRequest, Response finalResponse) {
                this.this$1 = this$1;
                this.replicaRequest = replicaRequest;
                this.finalResponse = finalResponse;
            }

            public ReplicaRequest replicaRequest() {
                return this.replicaRequest;
            }

            public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
                this.finalResponse.setShardInfo(shardInfo);
            }

            public void runPostReplicationActions(ActionListener<Void> listener) {
                listener.onResponse(null);
            }
        }
    }

    static final class ReplicationTargets {
        final IndexShard primary;
        final List<IndexShard> replicas;

        ReplicationTargets(IndexShard primary, List<IndexShard> replicas) {
            this.primary = primary;
            this.replicas = replicas;
        }

        synchronized void addReplica(IndexShard replica) {
            this.replicas.add(replica);
        }

        synchronized IndexShard findReplicaShard(ShardRouting replicaRouting) {
            for (IndexShard replica : this.replicas) {
                if (!replica.routingEntry().isSameAllocation(replicaRouting)) continue;
                return replica;
            }
            throw new AssertionError((Object)("replica [" + replicaRouting + "] is not found; replicas[" + this.replicas + "] primary[" + this.primary + "]"));
        }
    }
}

