/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MapperTestUtils;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.engine.DocIdSeqNoAndSource;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.InternalTestEngine;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.TranslogHandler;
import org.elasticsearch.index.fieldvisitor.IdOnlyFieldVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogDeletionPolicies;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.test.DummyShardLock;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;

public abstract class EngineTestCase
extends ESTestCase {
    protected final ShardId shardId = new ShardId(new Index("index", "_na_"), 0);
    protected final AllocationId allocationId = AllocationId.newInitializing();
    protected static final IndexSettings INDEX_SETTINGS = IndexSettingsModule.newIndexSettings("index", Settings.EMPTY, new Setting[0]);
    protected ThreadPool threadPool;
    protected TranslogHandler translogHandler;
    protected Store store;
    protected Store storeReplica;
    protected InternalEngine engine;
    protected InternalEngine replicaEngine;
    protected IndexSettings defaultSettings;
    protected String codecName;
    protected Path primaryTranslogDir;
    protected Path replicaTranslogDir;
    protected final PrimaryTermSupplier primaryTerm = new PrimaryTermSupplier(1L);
    protected static final BytesReference B_1 = new BytesArray(new byte[]{1});
    protected static final BytesReference B_2 = new BytesArray(new byte[]{2});
    protected static final BytesReference B_3 = new BytesArray(new byte[]{3});
    protected static final BytesArray SOURCE = EngineTestCase.bytesArray("{}");

    protected static void assertVisibleCount(Engine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(Engine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            TotalHitCountCollector collector = new TotalHitCountCollector();
            searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
            EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)numDocs));
        }
    }

    protected Settings indexSettings() {
        return Settings.builder().put(IndexSettings.INDEX_GC_DELETES_SETTING.getKey(), "1h").put(EngineConfig.INDEX_CODEC_SETTING.getKey(), this.codecName).put("index.version.created", Version.CURRENT).put(IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.getKey(), EngineTestCase.between(10, 10 * (Integer)IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.get(Settings.EMPTY))).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), EngineTestCase.randomBoolean()).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), EngineTestCase.randomBoolean() ? (Long)IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.get(Settings.EMPTY) : (long)EngineTestCase.between(0, 1000)).build();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.primaryTerm.set(EngineTestCase.randomLongBetween(1L, Long.MAX_VALUE));
        CodecService codecService = new CodecService(null, this.logger);
        String name = Codec.getDefault().getName();
        this.codecName = Arrays.asList(codecService.availableCodecs()).contains(name) ? name : "default";
        this.defaultSettings = IndexSettingsModule.newIndexSettings("test", this.indexSettings(), new Setting[0]);
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName(), new ExecutorBuilder[0]);
        this.store = this.createStore();
        this.storeReplica = this.createStore();
        Lucene.cleanLuceneIndex((Directory)this.store.directory());
        Lucene.cleanLuceneIndex((Directory)this.storeReplica.directory());
        this.primaryTranslogDir = EngineTestCase.createTempDir((String)"translog-primary");
        this.translogHandler = this.createTranslogHandler(this.defaultSettings);
        this.engine = this.createEngine(this.store, this.primaryTranslogDir);
        LiveIndexWriterConfig currentIndexWriterConfig = this.engine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.engine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
        this.replicaTranslogDir = EngineTestCase.createTempDir((String)"translog-replica");
        this.replicaEngine = this.createEngine(this.storeReplica, this.replicaTranslogDir);
        currentIndexWriterConfig = this.replicaEngine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.replicaEngine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
    }

    public EngineConfig copy(EngineConfig config, LongSupplier globalCheckpointSupplier) {
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), config.getAnalyzer(), config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), globalCheckpointSupplier, config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), EngineTestCase.tombstoneDocSupplier());
    }

    public EngineConfig copy(EngineConfig config, Analyzer analyzer) {
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), config.getMergePolicy(), analyzer, config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getTombstoneDocSupplier());
    }

    public EngineConfig copy(EngineConfig config, MergePolicy mergePolicy) {
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), config.getIndexSettings(), config.getWarmer(), config.getStore(), mergePolicy, config.getAnalyzer(), config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), config.getTranslogConfig(), config.getFlushMergesAfter(), config.getExternalRefreshListener(), Collections.emptyList(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), config.getTombstoneDocSupplier());
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.engine != null && !this.engine.isClosed.get()) {
                this.engine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
                EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex((Engine)this.engine, EngineTestCase.createMapperService("test"));
                EngineTestCase.assertMaxSeqNoInCommitUserData((Engine)this.engine);
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber((Engine)this.engine);
            }
            if (this.replicaEngine != null && !this.replicaEngine.isClosed.get()) {
                this.replicaEngine.getTranslog().getDeletionPolicy().assertNoOpenTranslogRefs();
                EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex((Engine)this.replicaEngine, EngineTestCase.createMapperService("test"));
                EngineTestCase.assertMaxSeqNoInCommitUserData((Engine)this.replicaEngine);
                EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber((Engine)this.replicaEngine);
            }
            EngineTestCase.assertThat((Object)this.engine.config().getCircuitBreakerService().getBreaker("accounting").getUsed(), (Matcher)Matchers.equalTo((Object)0L));
            EngineTestCase.assertThat((Object)this.replicaEngine.config().getCircuitBreakerService().getBreaker("accounting").getUsed(), (Matcher)Matchers.equalTo((Object)0L));
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
    }

    protected static ParseContext.Document testDocumentWithTextField() {
        return EngineTestCase.testDocumentWithTextField("test");
    }

    protected static ParseContext.Document testDocumentWithTextField(String value) {
        ParseContext.Document document = EngineTestCase.testDocument();
        document.add((IndexableField)new TextField("value", value, Field.Store.YES));
        return document;
    }

    protected static ParseContext.Document testDocument() {
        return new ParseContext.Document();
    }

    public static ParsedDocument createParsedDoc(String id, String routing) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null);
    }

    public static ParsedDocument createParsedDoc(String id, String routing, boolean recoverySource) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null, recoverySource);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, ParseContext.Document document, BytesReference source, Mapping mappingUpdate) {
        return EngineTestCase.testParsedDocument(id, routing, document, source, mappingUpdate, false);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, ParseContext.Document document, BytesReference source, Mapping mappingUpdate, boolean recoverySource) {
        Field uidField = new Field("_id", Uid.encodeId((String)id), (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE);
        NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
        SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
        document.add((IndexableField)uidField);
        document.add((IndexableField)versionField);
        document.add((IndexableField)seqID.seqNo);
        document.add((IndexableField)seqID.seqNoDocValue);
        document.add((IndexableField)seqID.primaryTerm);
        BytesRef ref = source.toBytesRef();
        if (recoverySource) {
            document.add((IndexableField)new StoredField("_recovery_source", ref.bytes, ref.offset, ref.length));
            document.add((IndexableField)new NumericDocValuesField("_recovery_source", 1L));
        } else {
            document.add((IndexableField)new StoredField("_source", ref.bytes, ref.offset, ref.length));
        }
        return new ParsedDocument((Field)versionField, seqID, id, "test", routing, Arrays.asList(document), source, XContentType.JSON, mappingUpdate);
    }

    public static CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory() throws Exception {
        MapperService mapperService = EngineTestCase.createMapperService("type");
        String nestedMapping = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().startObject().startObject("type").startObject("properties").startObject("nested_field").field("type", "nested").endObject().endObject().endObject().endObject());
        DocumentMapper nestedMapper = mapperService.documentMapperParser().parse("type", new CompressedXContent(nestedMapping));
        return (docId, nestedFieldValues) -> {
            XContentBuilder source = XContentFactory.jsonBuilder().startObject().field("field", "value");
            if (nestedFieldValues > 0) {
                XContentBuilder nestedField = source.startObject("nested_field");
                for (int i = 0; i < nestedFieldValues; ++i) {
                    nestedField.field("field-" + i, "value-" + i);
                }
                source.endObject();
            }
            source.endObject();
            return nestedMapper.parse(new SourceToParse("test", "type", docId, BytesReference.bytes((XContentBuilder)source), XContentType.JSON));
        };
    }

    public static EngineConfig.TombstoneDocSupplier tombstoneDocSupplier() {
        return new EngineConfig.TombstoneDocSupplier(){

            public ParsedDocument newDeleteTombstoneDoc(String type, String id) {
                ParseContext.Document doc = new ParseContext.Document();
                Field uidField = new Field("_id", Uid.encodeId((String)id), (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE);
                doc.add((IndexableField)uidField);
                NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
                doc.add((IndexableField)versionField);
                SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
                doc.add((IndexableField)seqID.seqNo);
                doc.add((IndexableField)seqID.seqNoDocValue);
                doc.add((IndexableField)seqID.primaryTerm);
                seqID.tombstoneField.setLongValue(1L);
                doc.add((IndexableField)seqID.tombstoneField);
                return new ParsedDocument((Field)versionField, seqID, id, type, null, Collections.singletonList(doc), (BytesReference)new BytesArray("{}"), XContentType.JSON, null);
            }

            public ParsedDocument newNoopTombstoneDoc(String reason) {
                ParseContext.Document doc = new ParseContext.Document();
                SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
                doc.add((IndexableField)seqID.seqNo);
                doc.add((IndexableField)seqID.seqNoDocValue);
                doc.add((IndexableField)seqID.primaryTerm);
                seqID.tombstoneField.setLongValue(1L);
                doc.add((IndexableField)seqID.tombstoneField);
                NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
                doc.add((IndexableField)versionField);
                BytesRef byteRef = new BytesRef((CharSequence)reason);
                doc.add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
                return new ParsedDocument((Field)versionField, seqID, null, null, null, Collections.singletonList(doc), null, XContentType.JSON, null);
            }
        };
    }

    protected Store createStore() throws IOException {
        return this.createStore((Directory)EngineTestCase.newDirectory());
    }

    protected Store createStore(Directory directory) throws IOException {
        return this.createStore(INDEX_SETTINGS, directory);
    }

    protected Store createStore(IndexSettings indexSettings, Directory directory) throws IOException {
        return new Store(this.shardId, indexSettings, directory, (ShardLock)new DummyShardLock(this.shardId));
    }

    protected Translog createTranslog(LongSupplier primaryTermSupplier) throws IOException {
        return this.createTranslog(this.primaryTranslogDir, primaryTermSupplier);
    }

    protected Translog createTranslog(Path translogPath, LongSupplier primaryTermSupplier) throws IOException {
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, INDEX_SETTINGS, BigArrays.NON_RECYCLING_INSTANCE);
        String translogUUID = Translog.createEmptyTranslog((Path)translogPath, (long)-1L, (ShardId)this.shardId, (long)primaryTermSupplier.getAsLong());
        return new Translog(translogConfig, translogUUID, TranslogDeletionPolicies.createTranslogDeletionPolicy(INDEX_SETTINGS), () -> -1L, primaryTermSupplier, seqNo -> {});
    }

    protected TranslogHandler createTranslogHandler(IndexSettings indexSettings) {
        return new TranslogHandler(this.xContentRegistry(), indexSettings);
    }

    protected InternalEngine createEngine(Store store, Path translogPath) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null, seqNoForOperation);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, null, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, @Nullable Sort indexSort, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        EngineConfig config = this.config(indexSettings, store, translogPath, mergePolicy, null, indexSort, globalCheckpointSupplier);
        return this.createEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
    }

    protected InternalEngine createEngine(EngineConfig config) throws IOException {
        return this.createEngine(null, null, null, config);
    }

    protected InternalEngine createEngine(@Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) throws IOException {
        Store store = config.getStore();
        Directory directory = store.directory();
        if (!Lucene.indexExists((Directory)directory)) {
            store.createEmpty(config.getIndexSettings().getIndexVersionCreated().luceneVersion);
            String translogUuid = Translog.createEmptyTranslog((Path)config.getTranslogConfig().getTranslogPath(), (long)-1L, (ShardId)this.shardId, (long)this.primaryTerm.get());
            store.associateIndexWithNewTranslog(translogUuid);
        }
        InternalEngine internalEngine = EngineTestCase.createInternalEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
        internalEngine.recoverFromTranslog((Engine.TranslogRecoveryRunner)this.translogHandler, Long.MAX_VALUE);
        return internalEngine;
    }

    public static long generateNewSeqNo(Engine engine) {
        assert (engine instanceof InternalEngine) : "expected InternalEngine, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.getLocalCheckpointTracker().generateSeqNo();
    }

    public static InternalEngine createInternalEngine(final @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, final @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) {
        if (localCheckpointTrackerSupplier == null) {
            return new InternalTestEngine(config){

                IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                    return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
                }

                protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                    return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
                }
            };
        }
        return new InternalTestEngine(config, localCheckpointTrackerSupplier){

            IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
            }

            protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
            }
        };
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, () -> -1L);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, indexSort, globalCheckpointSupplier, globalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, indexSort, globalCheckpointSupplier, retentionLeasesSupplier, (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, CircuitBreakerService breakerService) {
        return this.config(indexSettings, store, translogPath, mergePolicy, externalRefreshListener, internalRefreshListener, indexSort, maybeGlobalCheckpointSupplier, maybeGlobalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY, breakerService);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, @Nullable Supplier<RetentionLeases> maybeRetentionLeasesSupplier, CircuitBreakerService breakerService) {
        Supplier<RetentionLeases> retentionLeasesSupplier;
        LongSupplier globalCheckpointSupplier;
        List<Object> intRefreshListenerList;
        IndexWriterConfig iwc = EngineTestCase.newIndexWriterConfig();
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
        Engine.EventListener eventListener = new Engine.EventListener(){};
        List<Object> extRefreshListenerList = externalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(externalRefreshListener);
        List<Object> list = intRefreshListenerList = internalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(internalRefreshListener);
        if (maybeGlobalCheckpointSupplier == null) {
            assert (maybeRetentionLeasesSupplier == null);
            ReplicationTracker replicationTracker = new ReplicationTracker(this.shardId, this.allocationId.getId(), indexSettings, EngineTestCase.randomNonNegativeLong(), -1L, update -> {}, () -> 0L, (leases, listener) -> listener.onResponse((Object)new ReplicationResponse()), () -> SafeCommitInfo.EMPTY);
            globalCheckpointSupplier = replicationTracker;
            retentionLeasesSupplier = () -> ((ReplicationTracker)replicationTracker).getRetentionLeases();
        } else {
            assert (maybeRetentionLeasesSupplier != null);
            globalCheckpointSupplier = maybeGlobalCheckpointSupplier;
            retentionLeasesSupplier = maybeRetentionLeasesSupplier;
        }
        return new EngineConfig(this.shardId, this.allocationId.getId(), this.threadPool, indexSettings, null, store, mergePolicy, iwc.getAnalyzer(), iwc.getSimilarity(), new CodecService(null, this.logger), eventListener, IndexSearcher.getDefaultQueryCache(), IndexSearcher.getDefaultQueryCachingPolicy(), translogConfig, TimeValue.timeValueMinutes((long)5L), extRefreshListenerList, intRefreshListenerList, indexSort, breakerService, globalCheckpointSupplier, retentionLeasesSupplier, (LongSupplier)this.primaryTerm, EngineTestCase.tombstoneDocSupplier());
    }

    protected EngineConfig config(EngineConfig config, Store store, Path translogPath, EngineConfig.TombstoneDocSupplier tombstoneDocSupplier) {
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", Settings.builder().put(config.getIndexSettings().getSettings()).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true).build(), new Setting[0]);
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE);
        return new EngineConfig(config.getShardId(), config.getAllocationId(), config.getThreadPool(), indexSettings, config.getWarmer(), store, config.getMergePolicy(), config.getAnalyzer(), config.getSimilarity(), new CodecService(null, this.logger), config.getEventListener(), config.getQueryCache(), config.getQueryCachingPolicy(), translogConfig, config.getFlushMergesAfter(), config.getExternalRefreshListener(), config.getInternalRefreshListener(), config.getIndexSort(), config.getCircuitBreakerService(), config.getGlobalCheckpointSupplier(), config.retentionLeasesSupplier(), config.getPrimaryTermSupplier(), tombstoneDocSupplier);
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath) {
        return this.noOpConfig(indexSettings, store, translogPath, null);
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected static BytesArray bytesArray(String string) {
        return new BytesArray(string.getBytes(Charset.defaultCharset()));
    }

    public static Term newUid(String id) {
        return new Term("_id", Uid.encodeId((String)id));
    }

    public static Term newUid(ParsedDocument doc) {
        return EngineTestCase.newUid(doc.id());
    }

    protected Engine.Get newGet(boolean realtime, ParsedDocument doc) {
        return new Engine.Get(realtime, realtime, doc.type(), doc.id(), EngineTestCase.newUid(doc));
    }

    protected Engine.Index indexForDoc(ParsedDocument doc) {
        return new Engine.Index(EngineTestCase.newUid(doc), this.primaryTerm.get(), doc);
    }

    protected Engine.Index replicaIndexForDoc(ParsedDocument doc, long version, long seqNo, boolean isRetry) {
        return new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), version, null, Engine.Operation.Origin.REPLICA, System.nanoTime(), -1L, isRetry, -2L, 0L);
    }

    protected Engine.Delete replicaDeleteForDoc(String id, long version, long seqNo, long startTime) {
        return new Engine.Delete("test", id, EngineTestCase.newUid(id), seqNo, 1L, version, null, Engine.Operation.Origin.REPLICA, startTime, -2L, 0L);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            TotalHitCountCollector collector = new TotalHitCountCollector();
            searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
            EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)numDocs));
        }
    }

    public static List<Engine.Operation> generateSingleDocHistory(boolean forReplica, VersionType versionType, long primaryTerm, int minOpCount, int maxOpCount, String docId) {
        int numOfOps = EngineTestCase.randomIntBetween(minOpCount, maxOpCount);
        ArrayList<Engine.Operation> ops = new ArrayList<Engine.Operation>();
        Term id = EngineTestCase.newUid(docId);
        boolean startWithSeqNo = false;
        String valuePrefix = (forReplica ? "r_" : "p_") + docId + "_";
        boolean incrementTermWhenIntroducingSeqNo = EngineTestCase.randomBoolean();
        for (int i = 0; i < numOfOps; ++i) {
            long version;
            switch (versionType) {
                case INTERNAL: {
                    version = forReplica ? (long)i : -3L;
                    break;
                }
                case EXTERNAL: {
                    version = i;
                    break;
                }
                case EXTERNAL_GTE: {
                    version = EngineTestCase.randomBoolean() ? (long)Math.max(i - 1, 0) : (long)i;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown version type: " + versionType);
                }
            }
            Object op = EngineTestCase.randomBoolean() ? new Engine.Index(id, EngineTestCase.testParsedDocument(docId, null, EngineTestCase.testDocumentWithTextField(valuePrefix + i), (BytesReference)SOURCE, null), forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -1L, false, -2L, 0L) : new Engine.Delete("test", docId, id, forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -2L, 0L);
            ops.add((Engine.Operation)op);
        }
        return ops;
    }

    public List<Engine.Operation> generateHistoryOnReplica(int numOps, boolean allowGapInSeqNo, boolean allowDuplicate, boolean includeNestedDocs) throws Exception {
        long seqNo = 0L;
        int maxIdValue = EngineTestCase.randomInt(numOps * 2);
        ArrayList<Engine.Operation> operations = new ArrayList<Engine.Operation>(numOps);
        CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory = EngineTestCase.nestedParsedDocFactory();
        for (int i = 0; i < numOps; ++i) {
            String id = Integer.toString(EngineTestCase.randomInt(maxIdValue));
            Engine.Operation.TYPE opType = EngineTestCase.randomFrom(Engine.Operation.TYPE.values());
            boolean isNestedDoc = includeNestedDocs && opType == Engine.Operation.TYPE.INDEX && EngineTestCase.randomBoolean();
            int nestedValues = EngineTestCase.between(0, 3);
            long startTime = this.threadPool.relativeTimeInNanos();
            int copies = allowDuplicate && EngineTestCase.rarely() ? EngineTestCase.between(2, 4) : 1;
            block6: for (int copy = 0; copy < copies; ++copy) {
                ParsedDocument doc = isNestedDoc ? (ParsedDocument)nestedParsedDocFactory.apply((Object)id, (Object)nestedValues) : EngineTestCase.createParsedDoc(id, null);
                switch (opType) {
                    case INDEX: {
                        operations.add((Engine.Operation)new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -1L, true, -2L, 0L));
                        continue block6;
                    }
                    case DELETE: {
                        operations.add((Engine.Operation)new Engine.Delete(doc.type(), doc.id(), EngineTestCase.newUid(doc), seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -2L, 0L));
                        continue block6;
                    }
                    case NO_OP: {
                        operations.add((Engine.Operation)new Engine.NoOp(seqNo, this.primaryTerm.get(), EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, "test-" + i));
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown operation type [" + opType + "]");
                    }
                }
            }
            ++seqNo;
            if (!allowGapInSeqNo || !EngineTestCase.rarely()) continue;
            ++seqNo;
        }
        Randomness.shuffle(operations);
        return operations;
    }

    public static void assertOpsOnReplica(List<Engine.Operation> ops, InternalEngine replicaEngine, boolean shuffleOps, Logger logger) throws IOException {
        String lastFieldValue;
        Engine.Operation lastOp = ops.get(ops.size() - 1);
        if (lastOp instanceof Engine.Index) {
            Engine.Index index = (Engine.Index)lastOp;
            lastFieldValue = ((ParseContext.Document)index.docs().get(0)).get("value");
        } else {
            lastFieldValue = null;
        }
        if (shuffleOps) {
            int firstOpWithSeqNo;
            for (firstOpWithSeqNo = 0; firstOpWithSeqNo < ops.size() && ops.get(firstOpWithSeqNo).seqNo() < 0L; ++firstOpWithSeqNo) {
            }
            Collections.shuffle(ops.subList(0, firstOpWithSeqNo), EngineTestCase.random());
            Collections.shuffle(ops.subList(firstOpWithSeqNo, ops.size()), EngineTestCase.random());
        }
        boolean firstOp = true;
        for (Engine.Operation op : ops) {
            Engine.IndexResult result;
            logger.info("performing [{}], v [{}], seq# [{}], term [{}]", (Object)Character.valueOf(op.operationType().name().charAt(0)), (Object)op.version(), (Object)op.seqNo(), (Object)op.primaryTerm());
            if (op instanceof Engine.Index) {
                result = replicaEngine.index((Engine.Index)op);
                EngineTestCase.assertThat((Object)result.isCreated(), (Matcher)Matchers.equalTo((Object)firstOp));
                EngineTestCase.assertThat((Object)result.getVersion(), (Matcher)Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat((Object)result.getResultType(), (Matcher)Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            } else {
                result = replicaEngine.delete((Engine.Delete)op);
                EngineTestCase.assertThat((Object)result.isFound(), (Matcher)Matchers.equalTo((Object)(!firstOp ? 1 : 0)));
                EngineTestCase.assertThat((Object)result.getVersion(), (Matcher)Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat((Object)result.getResultType(), (Matcher)Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.refresh("test");
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.flush();
                replicaEngine.refresh("test");
            }
            firstOp = false;
        }
        EngineTestCase.assertVisibleCount(replicaEngine, lastFieldValue == null ? 0 : 1);
        if (lastFieldValue != null) {
            try (Engine.Searcher searcher = replicaEngine.acquireSearcher("test");){
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search((Query)new TermQuery(new Term("value", lastFieldValue)), (Collector)collector);
                EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)1));
            }
        }
    }

    public static void concurrentlyApplyOps(List<Engine.Operation> ops, InternalEngine engine) throws InterruptedException {
        int i;
        Thread[] thread = new Thread[EngineTestCase.randomIntBetween(3, 5)];
        CountDownLatch startGun = new CountDownLatch(thread.length);
        AtomicInteger offset = new AtomicInteger(-1);
        for (i = 0; i < thread.length; ++i) {
            thread[i] = new Thread(() -> {
                int docOffset;
                startGun.countDown();
                try {
                    startGun.await();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                while ((docOffset = offset.incrementAndGet()) < ops.size()) {
                    try {
                        EngineTestCase.applyOperation((Engine)engine, (Engine.Operation)ops.get(docOffset));
                        if ((docOffset + 1) % 4 == 0) {
                            engine.refresh("test");
                        }
                        if (!EngineTestCase.rarely()) continue;
                        engine.flush();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
            thread[i].start();
        }
        for (i = 0; i < thread.length; ++i) {
            thread[i].join();
        }
    }

    public static void applyOperations(Engine engine, List<Engine.Operation> operations) throws IOException {
        for (Engine.Operation operation : operations) {
            EngineTestCase.applyOperation(engine, operation);
            if (EngineTestCase.randomInt(100) < 10) {
                engine.refresh("test");
            }
            if (!EngineTestCase.rarely()) continue;
            engine.flush();
        }
    }

    public static Engine.Result applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        Engine.IndexResult result;
        switch (operation.operationType()) {
            case INDEX: {
                result = engine.index((Engine.Index)operation);
                break;
            }
            case DELETE: {
                result = engine.delete((Engine.Delete)operation);
                break;
            }
            case NO_OP: {
                result = engine.noOp((Engine.NoOp)operation);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
        return result;
    }

    public static List<DocIdSeqNoAndSource> getDocIds(Engine engine, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test_get_doc_ids");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test_get_doc_ids", Engine.SearcherScope.INTERNAL);){
            ArrayList<DocIdSeqNoAndSource> docs = new ArrayList<DocIdSeqNoAndSource>();
            for (LeafReaderContext leafContext : searcher.getIndexReader().leaves()) {
                LeafReader reader = leafContext.reader();
                NumericDocValues seqNoDocValues = reader.getNumericDocValues("_seq_no");
                NumericDocValues primaryTermDocValues = reader.getNumericDocValues("_primary_term");
                NumericDocValues versionDocValues = reader.getNumericDocValues("_version");
                Bits liveDocs = reader.getLiveDocs();
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i) || !primaryTermDocValues.advanceExact(i)) continue;
                    long primaryTerm = primaryTermDocValues.longValue();
                    Document doc = reader.document(i, (Set)Sets.newHashSet((Object[])new String[]{"_id", "_source"}));
                    BytesRef binaryID = doc.getBinaryValue("_id");
                    String id = Uid.decodeId((byte[])Arrays.copyOfRange(binaryID.bytes, binaryID.offset, binaryID.offset + binaryID.length));
                    BytesRef source = doc.getBinaryValue("_source");
                    if (!seqNoDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("seqNoDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long seqNo = seqNoDocValues.longValue();
                    if (!versionDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("versionDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long version = versionDocValues.longValue();
                    docs.add(new DocIdSeqNoAndSource(id, source, seqNo, primaryTerm, version));
                }
            }
            docs.sort(Comparator.comparingLong(DocIdSeqNoAndSource::getSeqNo).thenComparingLong(DocIdSeqNoAndSource::getPrimaryTerm).thenComparing(DocIdSeqNoAndSource::getId));
            ArrayList<DocIdSeqNoAndSource> arrayList = docs;
            return arrayList;
        }
    }

    public static List<Translog.Operation> readAllOperationsInLucene(Engine engine, MapperService mapper) throws IOException {
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = engine.newChangesSnapshot("test", mapper, 0L, Long.MAX_VALUE, false);){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
            }
        }
        return operations;
    }

    public static void assertConsistentHistoryBetweenTranslogAndLuceneIndex(Engine engine, MapperService mapper) throws IOException {
        long seqNoForRecovery;
        if (mapper == null || mapper.documentMapper() == null || !engine.config().getIndexSettings().isSoftDeleteEnabled() || !(engine instanceof InternalEngine)) {
            return;
        }
        ArrayList<Translog.Operation> translogOps = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = EngineTestCase.getTranslog(engine).newSnapshot();){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                translogOps.add(op);
            }
        }
        Map luceneOps = EngineTestCase.readAllOperationsInLucene(engine, mapper).stream().collect(Collectors.toMap(Translog.Operation::seqNo, Function.identity()));
        long maxSeqNo = ((InternalEngine)engine).getLocalCheckpointTracker().getMaxSeqNo();
        for (Translog.Operation op : translogOps) {
            EngineTestCase.assertThat((String)("translog operation [" + op + "] > max_seq_no[" + maxSeqNo + "]"), (Object)op.seqNo(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        for (Translog.Operation op : luceneOps.values()) {
            EngineTestCase.assertThat((String)("lucene operation [" + op + "] > max_seq_no[" + maxSeqNo + "]"), (Object)op.seqNo(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        long globalCheckpoint = EngineTestCase.getTranslog(engine).getLastSyncedGlobalCheckpoint();
        long retainedOps = engine.config().getIndexSettings().getSoftDeleteRetentionOperations();
        try (Engine.IndexCommitRef safeCommit = engine.acquireSafeIndexCommit();){
            seqNoForRecovery = Long.parseLong((String)safeCommit.getIndexCommit().getUserData().get("local_checkpoint")) + 1L;
        }
        long minSeqNoToRetain = Math.min(seqNoForRecovery, globalCheckpoint + 1L - retainedOps);
        for (Translog.Operation translogOp : translogOps) {
            Translog.Operation luceneOp = (Translog.Operation)luceneOps.get(translogOp.seqNo());
            if (luceneOp == null) {
                if (minSeqNoToRetain > translogOp.seqNo()) continue;
                EngineTestCase.fail((String)("Operation not found seq# [" + translogOp.seqNo() + "], global checkpoint [" + globalCheckpoint + "], retention policy [" + retainedOps + "], maxSeqNo [" + maxSeqNo + "], translog op [" + translogOp + "]"));
            }
            EngineTestCase.assertThat((Object)luceneOp, (Matcher)Matchers.notNullValue());
            EngineTestCase.assertThat((String)luceneOp.toString(), (Object)luceneOp.primaryTerm(), (Matcher)Matchers.equalTo((Object)translogOp.primaryTerm()));
            EngineTestCase.assertThat((Object)luceneOp.opType(), (Matcher)Matchers.equalTo((Object)translogOp.opType()));
            if (luceneOp.opType() != Translog.Operation.Type.INDEX) continue;
            EngineTestCase.assertThat((Object)luceneOp.getSource().source, (Matcher)Matchers.equalTo((Object)translogOp.getSource().source));
        }
    }

    public static void assertMaxSeqNoInCommitUserData(Engine engine) throws Exception {
        List commits = DirectoryReader.listCommits((Directory)engine.store.directory());
        for (IndexCommit commit : commits) {
            DirectoryReader reader = DirectoryReader.open((IndexCommit)commit);
            try {
                EngineTestCase.assertThat((Object)Long.parseLong((String)commit.getUserData().get("max_seq_no")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(EngineTestCase.maxSeqNosInReader(reader))));
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(Engine engine) throws IOException {
        if (engine instanceof InternalEngine) {
            try {
                engine.refresh("test");
                try (Engine.Searcher searcher = engine.acquireSearcher("test");){
                    EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine.config().getIndexSettings(), searcher.getDirectoryReader());
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(IndexSettings indexSettings, DirectoryReader reader) throws IOException {
        HashSet<Long> seqNos = new HashSet<Long>();
        DirectoryReader wrappedReader = indexSettings.isSoftDeleteEnabled() ? Lucene.wrapAllDocsLive((DirectoryReader)reader) : reader;
        for (LeafReaderContext leaf : wrappedReader.leaves()) {
            int docId;
            NumericDocValues primaryTermDocValues = leaf.reader().getNumericDocValues("_primary_term");
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while ((docId = seqNoDocValues.nextDoc()) != Integer.MAX_VALUE) {
                EngineTestCase.assertTrue((boolean)seqNoDocValues.advanceExact(docId));
                long seqNo = seqNoDocValues.longValue();
                EngineTestCase.assertThat((Object)seqNo, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
                if (!primaryTermDocValues.advanceExact(docId) || seqNos.add(seqNo)) continue;
                IdOnlyFieldVisitor idFieldVisitor = new IdOnlyFieldVisitor();
                leaf.reader().document(docId, (StoredFieldVisitor)idFieldVisitor);
                throw new AssertionError((Object)("found multiple documents for seq=" + seqNo + " id=" + idFieldVisitor.getId()));
            }
        }
    }

    public static MapperService createMapperService(String type) throws IOException {
        IndexMetadata indexMetadata = IndexMetadata.builder((String)"test").settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", 1).put("index.number_of_replicas", 1)).putMapping(type, "{\"properties\": {}}").build();
        MapperService mapperService = MapperTestUtils.newMapperService(new NamedXContentRegistry(ClusterModule.getNamedXWriteables()), EngineTestCase.createTempDir(), Settings.EMPTY, "test");
        mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        return mapperService;
    }

    public static Translog getTranslog(Engine engine) {
        assert (engine instanceof InternalEngine) : "only InternalEngines have translogs, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.getTranslog();
    }

    public static void waitForOpsToComplete(InternalEngine engine, long seqNo) throws InterruptedException {
        engine.getLocalCheckpointTracker().waitForProcessedOpsToComplete(seqNo);
    }

    public static boolean hasSnapshottedCommits(Engine engine) {
        assert (engine instanceof InternalEngine) : "only InternalEngines have snapshotted commits, got: " + engine.getClass();
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.hasSnapshottedCommits();
    }

    static long maxSeqNosInReader(DirectoryReader reader) throws IOException {
        long maxSeqNo = -1L;
        for (LeafReaderContext leaf : reader.leaves()) {
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while (seqNoDocValues.nextDoc() != Integer.MAX_VALUE) {
                maxSeqNo = SequenceNumbers.max((long)maxSeqNo, (long)seqNoDocValues.longValue());
            }
        }
        return maxSeqNo;
    }

    public static long getNumVersionLookups(Engine engine) {
        return ((InternalEngine)engine).getNumVersionLookups();
    }

    public static final class PrimaryTermSupplier
    implements LongSupplier {
        private final AtomicLong term;

        PrimaryTermSupplier(long initialTerm) {
            this.term = new AtomicLong(initialTerm);
        }

        public long get() {
            return this.term.get();
        }

        public void set(long newTerm) {
            this.term.set(newTerm);
        }

        @Override
        public long getAsLong() {
            return this.get();
        }
    }

    @FunctionalInterface
    public static interface IndexWriterFactory {
        public IndexWriter createWriter(Directory var1, IndexWriterConfig var2) throws IOException;
    }
}

