/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.mapper.MapperRegistry;

public class TranslogHandler
implements Engine.TranslogRecoveryRunner {
    private final MapperService mapperService;
    public Mapping mappingUpdate = null;
    private final Map<String, Mapping> recoveredTypes = new HashMap<String, Mapping>();
    private final AtomicLong appliedOperations = new AtomicLong();

    long appliedOperations() {
        return this.appliedOperations.get();
    }

    public TranslogHandler(NamedXContentRegistry xContentRegistry, IndexSettings indexSettings) {
        HashMap<String, NamedAnalyzer> analyzers = new HashMap<String, NamedAnalyzer>();
        analyzers.put("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        IndexAnalyzers indexAnalyzers = new IndexAnalyzers(analyzers, Collections.emptyMap(), Collections.emptyMap());
        SimilarityService similarityService = new SimilarityService(indexSettings, null, Collections.emptyMap());
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        this.mapperService = new MapperService(indexSettings, indexAnalyzers, xContentRegistry, similarityService, mapperRegistry, () -> null, () -> false);
    }

    private DocumentMapperForType docMapper(String type) {
        RootObjectMapper.Builder rootBuilder = new RootObjectMapper.Builder(type);
        DocumentMapper.Builder b = new DocumentMapper.Builder(rootBuilder, this.mapperService);
        return new DocumentMapperForType(b.build(this.mapperService), this.mappingUpdate);
    }

    private void applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        switch (operation.operationType()) {
            case INDEX: {
                Engine.Index engineIndex = (Engine.Index)operation;
                Mapping update = engineIndex.parsedDoc().dynamicMappingsUpdate();
                if (engineIndex.parsedDoc().dynamicMappingsUpdate() != null) {
                    this.recoveredTypes.compute(engineIndex.type(), (k, mapping) -> mapping == null ? update : mapping.merge(update, MapperService.MergeReason.MAPPING_RECOVERY));
                }
                engine.index(engineIndex);
                break;
            }
            case DELETE: {
                engine.delete((Engine.Delete)operation);
                break;
            }
            case NO_OP: {
                engine.noOp((Engine.NoOp)operation);
                break;
            }
            default: {
                throw new IllegalStateException("No operation defined for [" + operation + "]");
            }
        }
    }

    public Map<String, Mapping> getRecoveredTypes() {
        return this.recoveredTypes;
    }

    public int run(Engine engine, Translog.Snapshot snapshot) throws IOException {
        Translog.Operation operation;
        int opsRecovered = 0;
        while ((operation = snapshot.next()) != null) {
            this.applyOperation(engine, this.convertToEngineOp(operation, Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY));
            ++opsRecovered;
            this.appliedOperations.incrementAndGet();
        }
        engine.syncTranslog();
        return opsRecovered;
    }

    public Engine.Operation convertToEngineOp(Translog.Operation operation, Engine.Operation.Origin origin) {
        VersionType versionType = origin == Engine.Operation.Origin.PRIMARY ? VersionType.EXTERNAL : null;
        switch (operation.opType()) {
            case INDEX: {
                Translog.Index index = (Translog.Index)operation;
                String indexName = this.mapperService.index().getName();
                Engine.Index engineIndex = IndexShard.prepareIndex((DocumentMapperForType)this.docMapper(index.type()), (SourceToParse)new SourceToParse(indexName, index.type(), index.id(), index.source(), XContentHelper.xContentType((BytesReference)index.source()), index.routing()), (long)index.seqNo(), (long)index.primaryTerm(), (long)index.version(), (VersionType)versionType, (Engine.Operation.Origin)origin, (long)index.getAutoGeneratedIdTimestamp(), (boolean)true, (long)-2L, (long)0L);
                return engineIndex;
            }
            case DELETE: {
                Translog.Delete delete = (Translog.Delete)operation;
                Engine.Delete engineDelete = new Engine.Delete(delete.type(), delete.id(), delete.uid(), delete.seqNo(), delete.primaryTerm(), delete.version(), versionType, origin, System.nanoTime(), -2L, 0L);
                return engineDelete;
            }
            case NO_OP: {
                Translog.NoOp noOp = (Translog.NoOp)operation;
                Engine.NoOp engineNoOp = new Engine.NoOp(noOp.seqNo(), noOp.primaryTerm(), origin, System.nanoTime(), noOp.reason());
                return engineNoOp;
            }
        }
        throw new IllegalStateException("No operation defined for [" + operation + "]");
    }
}

