/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.QueryShardContext;

public class MockFieldMapper
extends FieldMapper {
    public MockFieldMapper(String fullName) {
        this((MappedFieldType)new FakeFieldType(fullName));
    }

    public MockFieldMapper(MappedFieldType fieldType) {
        super(MockFieldMapper.findSimpleName(fieldType.name()), new FieldType(), fieldType, FieldMapper.MultiFields.empty(), new FieldMapper.CopyTo.Builder().build());
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(ParseContext context) throws IOException {
    }

    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType(String name) {
            super(name, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        public String typeName() {
            return "faketype";
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }
    }
}

