/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.transport.Transport;

public class ActionTestUtils {
    private ActionTestUtils() {
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> Response executeBlocking(TransportAction<Request, Response> action, Request request) {
        return (Response)((ActionResponse)PlainActionFuture.get(future -> action.execute(request.createTask(1L, "direct", action.actionName, TaskId.EMPTY_TASK_ID, Map.of()), request, (ActionListener)future), (long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> Response executeBlockingWithTask(TaskManager taskManager, Transport.Connection localConnection, TransportAction<Request, Response> action, Request request) {
        return (Response)((ActionResponse)PlainActionFuture.get(future -> taskManager.registerAndExecute("transport", action, request, localConnection, (ActionListener)future), (long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void execute(TransportAction<Request, Response> action, Task task, Request request, ActionListener<Response> listener) {
        action.execute(task, request, listener);
    }

    public static <T> ActionListener<T> assertNoFailureListener(CheckedConsumer<T, Exception> consumer) {
        return ActionListener.wrap(consumer, e -> {
            throw new AssertionError("unexpected", (Throwable)e);
        });
    }

    public static ResponseListener wrapAsRestResponseListener(final ActionListener<Response> listener) {
        return new ResponseListener(){

            public void onSuccess(Response response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception exception) {
                listener.onFailure(exception);
            }
        };
    }
}

