/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.MockTerminal;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;

@ESTestCase.WithoutSecurityManager
public abstract class CommandTestCase
extends ESTestCase {
    protected final MockTerminal terminal = MockTerminal.create();
    protected final Map<String, String> sysprops = new HashMap<String, String>();
    protected final Map<String, String> envVars = new HashMap<String, String>();
    protected Path esHomeDir;
    protected Path configDir;
    private final boolean spaceInPath;

    protected CommandTestCase() {
        this(false);
    }

    protected CommandTestCase(boolean spaceInPath) {
        this.spaceInPath = spaceInPath;
    }

    @Before
    public void resetTerminal() throws IOException {
        this.terminal.reset();
        this.terminal.setSupportsBinary(false);
        this.terminal.setVerbosity(Terminal.Verbosity.NORMAL);
        this.esHomeDir = this.spaceInPath ? CommandTestCase.createTempDir((String)"a b") : CommandTestCase.createTempDir();
        this.configDir = this.esHomeDir.resolve("config");
        Files.createDirectory(this.configDir, new FileAttribute[0]);
        this.sysprops.clear();
        this.sysprops.put("es.path.home", this.esHomeDir.toString());
        this.sysprops.put("es.path.conf", this.esHomeDir.resolve("config").toString());
        this.sysprops.put("os.name", "Linux");
        this.envVars.clear();
    }

    protected abstract Command newCommand();

    public int executeMain(String ... args) throws Exception {
        return this.newCommand().main(args, (Terminal)this.terminal, new ProcessInfo(this.sysprops, this.envVars, this.esHomeDir));
    }

    public String execute(String ... args) throws Exception {
        return this.execute(this.newCommand(), args);
    }

    public String execute(Command command, String ... args) throws Exception {
        command.mainWithoutErrorHandling(args, (Terminal)this.terminal, new ProcessInfo(this.sysprops, this.envVars, this.esHomeDir));
        return this.terminal.getOutput();
    }

    protected void assertOk(String ... args) throws Exception {
        this.assertOkWithOutput((Matcher<String>)Matchers.emptyString(), (Matcher<String>)Matchers.emptyString(), args);
    }

    protected void assertOkWithOutput(Matcher<String> outMatcher, Matcher<String> errMatcher, String ... args) throws Exception {
        int status = this.executeMain(args);
        CommandTestCase.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)0));
        CommandTestCase.assertThat((Object)this.terminal.getErrorOutput(), errMatcher);
        CommandTestCase.assertThat((Object)this.terminal.getOutput(), outMatcher);
    }

    protected void assertUsage(Matcher<String> matcher, String ... args) throws Exception {
        this.terminal.reset();
        int status = this.executeMain(args);
        CommandTestCase.assertThat((Object)status, (Matcher)CoreMatchers.equalTo((Object)64));
        CommandTestCase.assertThat((Object)this.terminal.getErrorOutput(), matcher);
    }
}

