/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.EmptyClusterInfoService;
import org.elasticsearch.cluster.TestShardRoutingRoleStrategies;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodesHelper;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.ExistingShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.DeterministicTaskQueue;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.snapshots.SnapshotsInfoService;
import org.elasticsearch.test.ClusterServiceUtils;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.gateway.TestGatewayAllocator;

public abstract class ESAllocationTestCase
extends ESTestCase {
    public static final SnapshotsInfoService SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES = () -> new SnapshotShardSizeInfo(Map.of()){

        public Long getShardSize(ShardRouting shardRouting) {
            assert (shardRouting.recoverySource().getType() == RecoverySource.Type.SNAPSHOT) : "Expecting a recovery source of type [SNAPSHOT] but got [" + shardRouting.recoverySource().getType() + "]";
            throw new UnsupportedOperationException();
        }
    };
    public static final WriteLoadForecaster TEST_WRITE_LOAD_FORECASTER = new WriteLoadForecaster(){

        public Metadata.Builder withWriteLoadForecastForWriteIndex(String dataStreamName, Metadata.Builder metadata) {
            throw new AssertionError((Object)"Not required for testing");
        }

        @SuppressForbidden(reason="tests do not need a license to access the write load")
        public OptionalDouble getForecastedWriteLoad(IndexMetadata indexMetadata) {
            return indexMetadata.getForecastedWriteLoad();
        }
    };
    protected static Set<DiscoveryNodeRole> MASTER_DATA_ROLES = Set.of(DiscoveryNodeRole.MASTER_ROLE, DiscoveryNodeRole.DATA_ROLE);

    public static MockAllocationService createAllocationService() {
        return ESAllocationTestCase.createAllocationService(Settings.EMPTY);
    }

    public static MockAllocationService createAllocationService(Settings settings) {
        return ESAllocationTestCase.createAllocationService(settings, new TestGatewayAllocator(), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator) {
        return ESAllocationTestCase.createAllocationService(settings, gatewayAllocator, (ClusterInfoService)EmptyClusterInfoService.INSTANCE, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, ClusterInfoService clusterInfoService) {
        return ESAllocationTestCase.createAllocationService(settings, new TestGatewayAllocator(), clusterInfoService, SNAPSHOT_INFO_SERVICE_WITH_NO_SHARD_SIZES);
    }

    public static MockAllocationService createAllocationService(Settings settings, SnapshotsInfoService snapshotsInfoService) {
        return ESAllocationTestCase.createAllocationService(settings, new TestGatewayAllocator(), (ClusterInfoService)EmptyClusterInfoService.INSTANCE, snapshotsInfoService);
    }

    public static MockAllocationService createAllocationService(Settings settings, GatewayAllocator gatewayAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
        return new MockAllocationService(ESAllocationTestCase.randomAllocationDeciders(settings, ClusterSettings.createBuiltInClusterSettings((Settings)settings)), gatewayAllocator, ESAllocationTestCase.createShardsAllocator(settings), clusterInfoService, snapshotsInfoService);
    }

    public static AllocationDeciders randomAllocationDeciders(Settings settings, ClusterSettings clusterSettings) {
        ArrayList deciders = new ArrayList(ClusterModule.createAllocationDeciders((Settings)settings, (ClusterSettings)clusterSettings, Collections.emptyList()));
        Collections.shuffle(deciders, ESAllocationTestCase.random());
        return new AllocationDeciders(deciders);
    }

    protected static ShardsAllocator createShardsAllocator(Settings settings) {
        return switch (ESAllocationTestCase.pickShardsAllocator(settings)) {
            case "balanced" -> new BalancedShardsAllocator(settings);
            case "desired_balance" -> ESAllocationTestCase.createDesiredBalanceShardsAllocator(settings);
            default -> throw new AssertionError((Object)"Unknown allocator");
        };
    }

    private static String pickShardsAllocator(Settings settings) {
        return ClusterModule.SHARDS_ALLOCATOR_TYPE_SETTING.exists(settings) ? (String)ClusterModule.SHARDS_ALLOCATOR_TYPE_SETTING.get(settings) : ESAllocationTestCase.randomFrom("balanced", "desired_balance");
    }

    private static DesiredBalanceShardsAllocator createDesiredBalanceShardsAllocator(Settings settings) {
        final DeterministicTaskQueue queue = new DeterministicTaskQueue();
        ClusterSettings clusterSettings = ClusterSettings.createBuiltInClusterSettings((Settings)settings);
        ClusterService clusterService = ClusterServiceUtils.createClusterService(queue.getThreadPool(), clusterSettings);
        return new DesiredBalanceShardsAllocator(clusterSettings, (ShardsAllocator)new BalancedShardsAllocator(settings), queue.getThreadPool(), clusterService, null){
            private RoutingAllocation lastAllocation;

            public void allocate(RoutingAllocation allocation, ActionListener<Void> listener) {
                this.lastAllocation = allocation;
                super.allocate(allocation, listener);
                queue.runAllTasks();
                this.completeToLastConvergedIndex();
                queue.runAllTasks();
            }

            protected void reconcile(DesiredBalance desiredBalance, RoutingAllocation allocation) {
            }

            protected void submitReconcileTask(DesiredBalance desiredBalance) {
                super.reconcile(desiredBalance, this.lastAllocation);
            }
        };
    }

    protected static DiscoveryNode newNode(String nodeId) {
        return ESAllocationTestCase.newNode(nodeId, (Version)null);
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Map<String, String> attributes) {
        return DiscoveryNodeUtils.builder(nodeId).name(nodeName).attributes(attributes).roles(MASTER_DATA_ROLES).build();
    }

    protected static DiscoveryNode newNode(String nodeId, Map<String, String> attributes) {
        return DiscoveryNodeUtils.builder(nodeId).attributes(attributes).build();
    }

    protected static DiscoveryNode newNode(String nodeId, Set<DiscoveryNodeRole> roles) {
        return DiscoveryNodeUtils.builder(nodeId).roles(roles).build();
    }

    protected static DiscoveryNode newNode(String nodeName, String nodeId, Set<DiscoveryNodeRole> roles) {
        return DiscoveryNodeUtils.builder(nodeId).name(nodeName).roles(roles).build();
    }

    protected static DiscoveryNode newNode(String nodeId, Version version) {
        return DiscoveryNodeUtils.builder(nodeId).roles(MASTER_DATA_ROLES).version(version).build();
    }

    protected static DiscoveryNode newNode(String nodeId, Version version, IndexVersion indexVersion) {
        return DiscoveryNodeUtils.builder(nodeId).roles(MASTER_DATA_ROLES).version(version, IndexVersion.MINIMUM_COMPATIBLE, indexVersion).build();
    }

    protected static ClusterState startRandomInitializingShard(ClusterState clusterState, AllocationService strategy) {
        List<ShardRouting> initializingShards = RoutingNodesHelper.shardsWithState(clusterState.getRoutingNodes(), ShardRoutingState.INITIALIZING);
        if (initializingShards.isEmpty()) {
            return clusterState;
        }
        return ESAllocationTestCase.startShardsAndReroute(strategy, clusterState, ESAllocationTestCase.randomFrom(initializingShards));
    }

    protected static AllocationDeciders yesAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.YES), new SameShardAllocationDecider(ClusterSettings.createBuiltInClusterSettings())}));
    }

    protected static AllocationDeciders noAllocationDeciders() {
        return new AllocationDeciders(Collections.singleton(new TestAllocateDecision(Decision.NO)));
    }

    protected static AllocationDeciders throttleAllocationDeciders() {
        return new AllocationDeciders(Arrays.asList(new AllocationDecider[]{new TestAllocateDecision(Decision.THROTTLE), new SameShardAllocationDecider(ClusterSettings.createBuiltInClusterSettings())}));
    }

    protected ClusterState applyStartedShardsUntilNoChange(ClusterState clusterState, AllocationService service) {
        ClusterState previousClusterState;
        int iterations = 0;
        do {
            if (++iterations % 100 == 0) {
                this.logger.info("applyStartedShardsUntilNoChange: iteration [{}]", (Object)iterations);
            }
            previousClusterState = clusterState;
            this.logger.debug(() -> Strings.format((String)"ClusterState: %s", (Object[])new Object[]{previousClusterState.getRoutingNodes()}));
        } while (!previousClusterState.equals(clusterState = ESAllocationTestCase.startInitializingShardsAndReroute(service, clusterState)));
        return clusterState;
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState state) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, state, RoutingNodesHelper.shardsWithState(state.getRoutingNodes(), ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, RoutingNode routingNode) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, routingNode.shardsWithState(ShardRoutingState.INITIALIZING).toList());
    }

    public static ClusterState startInitializingShardsAndReroute(AllocationService allocationService, ClusterState clusterState, String index) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, clusterState.routingTable().index(index).shardsWithState(ShardRoutingState.INITIALIZING));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, ShardRouting ... initializingShards) {
        return ESAllocationTestCase.startShardsAndReroute(allocationService, clusterState, Arrays.asList(initializingShards));
    }

    public static ClusterState startShardsAndReroute(AllocationService allocationService, ClusterState clusterState, List<ShardRouting> initializingShards) {
        return ESAllocationTestCase.reroute(allocationService, allocationService.applyStartedShards(clusterState, initializingShards));
    }

    public static ClusterState reroute(AllocationService allocationService, ClusterState clusterState) {
        PlainActionFuture listener = new PlainActionFuture();
        ClusterState result = allocationService.reroute(clusterState, "test reroute", (ActionListener)listener);
        listener.result();
        return result;
    }

    protected static class MockAllocationService
    extends AllocationService {
        private volatile long nanoTimeOverride = -1L;
        public final GatewayAllocator gatewayAllocator;
        public final ShardsAllocator shardsAllocator;

        public MockAllocationService(AllocationDeciders allocationDeciders, GatewayAllocator gatewayAllocator, ShardsAllocator shardsAllocator, ClusterInfoService clusterInfoService, SnapshotsInfoService snapshotsInfoService) {
            super(allocationDeciders, gatewayAllocator, shardsAllocator, clusterInfoService, snapshotsInfoService, TestShardRoutingRoleStrategies.DEFAULT_ROLE_ONLY);
            this.gatewayAllocator = gatewayAllocator;
            this.shardsAllocator = shardsAllocator;
        }

        public void setNanoTimeOverride(long nanoTime) {
            this.nanoTimeOverride = nanoTime;
        }

        protected long currentNanoTime() {
            return this.nanoTimeOverride == -1L ? super.currentNanoTime() : this.nanoTimeOverride;
        }
    }

    public static class TestAllocateDecision
    extends AllocationDecider {
        private final Decision decision;

        public TestAllocateDecision(Decision decision) {
            this.decision = decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
            return this.decision;
        }

        public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
            return this.decision;
        }
    }

    protected static class DelayedShardsMockGatewayAllocator
    extends GatewayAllocator {
        public void applyStartedShards(List<ShardRouting> startedShards, RoutingAllocation allocation) {
        }

        public void applyFailedShards(List<FailedShard> failedShards, RoutingAllocation allocation) {
        }

        public void beforeAllocation(RoutingAllocation allocation) {
        }

        public void afterPrimariesBeforeReplicas(RoutingAllocation allocation) {
        }

        public void allocateUnassigned(ShardRouting shardRouting, RoutingAllocation allocation, ExistingShardsAllocator.UnassignedAllocationHandler unassignedAllocationHandler) {
            if (shardRouting.primary() || shardRouting.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) {
                return;
            }
            if (shardRouting.unassignedInfo().isDelayed()) {
                unassignedAllocationHandler.removeAndIgnore(UnassignedInfo.AllocationStatus.DELAYED_ALLOCATION, allocation.changes());
            }
        }
    }
}

